/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.validation;

import java.math.BigDecimal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.validation.ValidationConstraintResolver;
import org.apache.flink.shaded.jackson2.javax.validation.constraints.DecimalMax;
import org.apache.flink.shaded.jackson2.javax.validation.constraints.DecimalMin;
import org.apache.flink.shaded.jackson2.javax.validation.constraints.Max;
import org.apache.flink.shaded.jackson2.javax.validation.constraints.Min;
import org.apache.flink.shaded.jackson2.javax.validation.constraints.Pattern;
import org.apache.flink.shaded.jackson2.javax.validation.constraints.Size;

public class AnnotationConstraintResolver
implements ValidationConstraintResolver {
    private Size getSizeAnnotation(BeanProperty prop) {
        return prop.getAnnotation(Size.class);
    }

    private Integer getMaxSize(BeanProperty prop) {
        Size sizeAnnotation = this.getSizeAnnotation(prop);
        return sizeAnnotation != null && sizeAnnotation.max() != Integer.MAX_VALUE ? Integer.valueOf(sizeAnnotation.max()) : null;
    }

    private Integer getMinSize(BeanProperty prop) {
        Size sizeAnnotation = this.getSizeAnnotation(prop);
        return sizeAnnotation != null && sizeAnnotation.min() != 0 ? Integer.valueOf(sizeAnnotation.min()) : null;
    }

    @Override
    public Integer getArrayMaxItems(BeanProperty prop) {
        return this.getMaxSize(prop);
    }

    @Override
    public Integer getArrayMinItems(BeanProperty prop) {
        return this.getMinSize(prop);
    }

    @Override
    public Double getNumberMaximum(BeanProperty prop) {
        Max maxAnnotation = prop.getAnnotation(Max.class);
        if (maxAnnotation != null) {
            return maxAnnotation.value();
        }
        DecimalMax decimalMaxAnnotation = prop.getAnnotation(DecimalMax.class);
        return decimalMaxAnnotation != null ? Double.valueOf(new BigDecimal(decimalMaxAnnotation.value()).doubleValue()) : null;
    }

    @Override
    public Double getNumberMinimum(BeanProperty prop) {
        Min minAnnotation = prop.getAnnotation(Min.class);
        if (minAnnotation != null) {
            return minAnnotation.value();
        }
        DecimalMin decimalMinAnnotation = prop.getAnnotation(DecimalMin.class);
        return decimalMinAnnotation != null ? Double.valueOf(new BigDecimal(decimalMinAnnotation.value()).doubleValue()) : null;
    }

    @Override
    public Integer getStringMaxLength(BeanProperty prop) {
        return this.getMaxSize(prop);
    }

    @Override
    public Integer getStringMinLength(BeanProperty prop) {
        return this.getMinSize(prop);
    }

    @Override
    public String getStringPattern(BeanProperty prop) {
        Pattern patternAnnotation = prop.getAnnotation(Pattern.class);
        if (patternAnnotation != null) {
            return patternAnnotation.regexp();
        }
        return null;
    }
}

