/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.InvalidContainerRequestException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMRMClientImpl<T extends AMRMClient.ContainerRequest>
extends AMRMClient<T> {
    private static final Log LOG = LogFactory.getLog(AMRMClientImpl.class);
    private static final List<String> ANY_LIST = Collections.singletonList("*");
    private int lastResponseId = 0;
    protected String appHostName;
    protected int appHostPort;
    protected String appTrackingUrl;
    protected ApplicationMasterProtocol rmClient;
    protected Resource clusterAvailableResources;
    protected int clusterNodeCount;
    protected final Set<String> blacklistedNodes = new HashSet<String>();
    protected final Set<String> blacklistAdditions = new HashSet<String>();
    protected final Set<String> blacklistRemovals = new HashSet<String>();
    protected final Map<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>> remoteRequestsTable = new TreeMap<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>>();
    protected final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>(new ResourceRequest.ResourceRequestComparator());
    protected final Set<ContainerId> release = new TreeSet<ContainerId>();
    protected Set<ContainerId> pendingRelease = new TreeSet<ContainerId>();
    protected final Map<ContainerId, AbstractMap.SimpleEntry<Container, Resource>> change = new HashMap<ContainerId, AbstractMap.SimpleEntry<Container, Resource>>();
    protected final Map<ContainerId, AbstractMap.SimpleEntry<Container, Resource>> pendingChange = new HashMap<ContainerId, AbstractMap.SimpleEntry<Container, Resource>>();

    static boolean canFit(Resource arg0, Resource arg1) {
        long mem0 = arg0.getMemorySize();
        long mem1 = arg1.getMemorySize();
        long cpu0 = arg0.getVirtualCores();
        long cpu1 = arg1.getVirtualCores();
        return mem0 <= mem1 && cpu0 <= cpu1;
    }

    public AMRMClientImpl() {
        super(AMRMClientImpl.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        RackResolver.init(conf);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration(this.getConfig());
        try {
            this.rmClient = ClientRMProxy.createRMProxy(conf, ApplicationMasterProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy(this.rmClient);
        }
        super.serviceStop();
    }

    @Override
    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnException, IOException {
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        Preconditions.checkArgument(appHostName != null, "The host name should not be null");
        Preconditions.checkArgument(appHostPort >= -1, "Port number of the host should be any integers larger than or equal to -1");
        return this.registerApplicationMaster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterApplicationMasterResponse registerApplicationMaster() throws YarnException, IOException {
        RegisterApplicationMasterRequest request = RegisterApplicationMasterRequest.newInstance(this.appHostName, this.appHostPort, this.appTrackingUrl);
        RegisterApplicationMasterResponse response = this.rmClient.registerApplicationMaster(request);
        AMRMClientImpl aMRMClientImpl = this;
        synchronized (aMRMClientImpl) {
            this.lastResponseId = 0;
            if (!response.getNMTokensFromPreviousAttempts().isEmpty()) {
                this.populateNMTokens(response.getNMTokensFromPreviousAttempts());
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateResponse allocate(float progressIndicator) throws YarnException, IOException {
        Preconditions.checkArgument(progressIndicator >= 0.0f, "Progress indicator should not be negative");
        AllocateResponse allocateResponse = null;
        List<ResourceRequest> askList = null;
        ArrayList<ContainerId> releaseList = null;
        AllocateRequest allocateRequest = null;
        ArrayList<String> blacklistToAdd = new ArrayList<String>();
        ArrayList<String> blacklistToRemove = new ArrayList<String>();
        HashMap<ContainerId, AbstractMap.SimpleEntry<Container, Resource>> oldChange = new HashMap<ContainerId, AbstractMap.SimpleEntry<Container, Resource>>();
        try {
            Object updateList;
            AMRMClientImpl aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                askList = this.cloneAsks();
                oldChange.putAll(this.change);
                updateList = this.createUpdateList();
                releaseList = new ArrayList<ContainerId>(this.release);
                this.ask.clear();
                this.release.clear();
                this.change.clear();
                blacklistToAdd.addAll(this.blacklistAdditions);
                blacklistToRemove.addAll(this.blacklistRemovals);
                ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(blacklistToAdd, blacklistToRemove);
                allocateRequest = AllocateRequest.newInstance(this.lastResponseId, progressIndicator, askList, releaseList, updateList, blacklistRequest);
                this.blacklistAdditions.clear();
                this.blacklistRemovals.clear();
            }
            try {
                allocateResponse = this.rmClient.allocate(allocateRequest);
            }
            catch (ApplicationMasterNotRegisteredException e) {
                LOG.warn((Object)"ApplicationMaster is out of sync with ResourceManager, hence resyncing.");
                updateList = this;
                synchronized (updateList) {
                    this.release.addAll(this.pendingRelease);
                    this.blacklistAdditions.addAll(this.blacklistedNodes);
                    for (Map<String, TreeMap<Resource, ResourceRequestInfo>> rr : this.remoteRequestsTable.values()) {
                        for (Map map : rr.values()) {
                            for (ResourceRequestInfo request : map.values()) {
                                this.addResourceRequestToAsk(request.remoteRequest);
                            }
                        }
                    }
                    this.change.putAll(this.pendingChange);
                }
                this.registerApplicationMaster();
                allocateResponse = this.allocate(progressIndicator);
                updateList = allocateResponse;
                if (allocateResponse == null) {
                    AMRMClientImpl i$ = this;
                    synchronized (i$) {
                        this.release.addAll(releaseList);
                        for (ResourceRequest resourceRequest : askList) {
                            if (this.ask.contains(resourceRequest)) continue;
                            this.ask.add(resourceRequest);
                        }
                        for (Map.Entry entry : oldChange.entrySet()) {
                            ContainerId containerId = (ContainerId)entry.getKey();
                            Container oldContainer = (Container)((AbstractMap.SimpleEntry)entry.getValue()).getKey();
                            Resource oldResource = (Resource)((AbstractMap.SimpleEntry)entry.getValue()).getValue();
                            if (this.change.get(containerId) != null) continue;
                            this.change.put(containerId, new AbstractMap.SimpleEntry<Container, Resource>(oldContainer, oldResource));
                        }
                        this.blacklistAdditions.addAll(blacklistToAdd);
                        this.blacklistRemovals.addAll(blacklistToRemove);
                    }
                }
                return updateList;
            }
            aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                this.clusterNodeCount = allocateResponse.getNumClusterNodes();
                this.lastResponseId = allocateResponse.getResponseId();
                this.clusterAvailableResources = allocateResponse.getAvailableResources();
                if (!allocateResponse.getNMTokens().isEmpty()) {
                    this.populateNMTokens(allocateResponse.getNMTokens());
                }
                if (allocateResponse.getAMRMToken() != null) {
                    this.updateAMRMToken(allocateResponse.getAMRMToken());
                }
                if (!this.pendingRelease.isEmpty() && !allocateResponse.getCompletedContainersStatuses().isEmpty()) {
                    this.removePendingReleaseRequests(allocateResponse.getCompletedContainersStatuses());
                }
                if (!this.pendingChange.isEmpty()) {
                    List<ContainerStatus> completed = allocateResponse.getCompletedContainersStatuses();
                    ArrayList<UpdatedContainer> changed = new ArrayList<UpdatedContainer>();
                    changed.addAll(allocateResponse.getUpdatedContainers());
                    for (ContainerStatus containerStatus : completed) {
                        ContainerId containerId = containerStatus.getContainerId();
                        this.pendingChange.remove(containerId);
                    }
                    if (!changed.isEmpty()) {
                        this.removePendingChangeRequests(changed);
                    }
                }
            }
        }
        finally {
            if (allocateResponse == null) {
                AMRMClientImpl aMRMClientImpl = this;
                synchronized (aMRMClientImpl) {
                    this.release.addAll(releaseList);
                    for (ResourceRequest resourceRequest : askList) {
                        if (this.ask.contains(resourceRequest)) continue;
                        this.ask.add(resourceRequest);
                    }
                    for (Map.Entry entry : oldChange.entrySet()) {
                        ContainerId oldContainerId = (ContainerId)entry.getKey();
                        Container oldContainer = (Container)((AbstractMap.SimpleEntry)entry.getValue()).getKey();
                        Resource oldResource = (Resource)((AbstractMap.SimpleEntry)entry.getValue()).getValue();
                        if (this.change.get(oldContainerId) != null) continue;
                        this.change.put(oldContainerId, new AbstractMap.SimpleEntry<Container, Resource>(oldContainer, oldResource));
                    }
                    this.blacklistAdditions.addAll(blacklistToAdd);
                    this.blacklistRemovals.addAll(blacklistToRemove);
                }
            }
        }
        return allocateResponse;
    }

    private List<UpdateContainerRequest> createUpdateList() {
        ArrayList<UpdateContainerRequest> updateList = new ArrayList<UpdateContainerRequest>();
        for (Map.Entry<ContainerId, AbstractMap.SimpleEntry<Container, Resource>> entry : this.change.entrySet()) {
            Resource targetCapability = entry.getValue().getValue();
            Resource currCapability = entry.getValue().getKey().getResource();
            int version = entry.getValue().getKey().getVersion();
            ContainerUpdateType updateType = ContainerUpdateType.INCREASE_RESOURCE;
            if (Resources.fitsIn(targetCapability, currCapability)) {
                updateType = ContainerUpdateType.DECREASE_RESOURCE;
            }
            updateList.add(UpdateContainerRequest.newInstance(version, entry.getKey(), updateType, targetCapability));
        }
        return updateList;
    }

    private List<ResourceRequest> cloneAsks() {
        ArrayList<ResourceRequest> askList = new ArrayList<ResourceRequest>(this.ask.size());
        for (ResourceRequest r : this.ask) {
            ResourceRequest rr = ResourceRequest.newInstance(r.getPriority(), r.getResourceName(), r.getCapability(), r.getNumContainers(), r.getRelaxLocality(), r.getNodeLabelExpression());
            askList.add(rr);
        }
        return askList;
    }

    protected void removePendingReleaseRequests(List<ContainerStatus> completedContainersStatuses) {
        for (ContainerStatus containerStatus : completedContainersStatuses) {
            this.pendingRelease.remove(containerStatus.getContainerId());
        }
    }

    protected void removePendingChangeRequests(List<UpdatedContainer> changedContainers) {
        for (UpdatedContainer changedContainer : changedContainers) {
            ContainerId containerId = changedContainer.getContainer().getId();
            if (this.pendingChange.get(containerId) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RM has confirmed changed resource allocation for container " + containerId + ". Current resource allocation:" + changedContainer.getContainer().getResource() + ". Remove pending change request:" + this.pendingChange.get(containerId).getValue()));
            }
            this.pendingChange.remove(containerId);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void populateNMTokens(List<NMToken> nmTokens) {
        for (NMToken token : nmTokens) {
            String nodeId = token.getNodeId().toString();
            if (this.getNMTokenCache().containsToken(nodeId)) {
                LOG.info((Object)("Replacing token for : " + nodeId));
            } else {
                LOG.info((Object)("Received new token for : " + nodeId));
            }
            this.getNMTokenCache().setToken(nodeId, token.getToken());
        }
    }

    @Override
    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) throws YarnException, IOException {
        Preconditions.checkArgument(appStatus != null, "AppStatus should not be null.");
        FinishApplicationMasterRequest request = FinishApplicationMasterRequest.newInstance(appStatus, appMessage, appTrackingUrl);
        try {
            FinishApplicationMasterResponse response;
            while (!(response = this.rmClient.finishApplicationMaster(request)).getIsUnregistered()) {
                LOG.info((Object)"Waiting for application to be successfully unregistered.");
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted while waiting for application to be removed from RMStateStore");
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.warn((Object)"ApplicationMaster is out of sync with ResourceManager, hence resyncing.");
            this.registerApplicationMaster();
            this.unregisterApplicationMaster(appStatus, appMessage, appTrackingUrl);
        }
    }

    @Override
    public synchronized void addContainerRequest(T req) {
        Preconditions.checkArgument(req != null, "Resource request can not be null.");
        HashSet<String> dedupedRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            dedupedRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
            if (((AMRMClient.ContainerRequest)req).getRacks().size() != dedupedRacks.size()) {
                Joiner joiner = Joiner.on(',');
                LOG.warn((Object)("ContainerRequest has duplicate racks: " + joiner.join(((AMRMClient.ContainerRequest)req).getRacks())));
            }
        }
        Set<String> inferredRacks = this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes());
        inferredRacks.removeAll(dedupedRacks);
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), ANY_LIST, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), dedupedRacks, true);
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), inferredRacks, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        this.checkNodeLabelExpression(req);
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            HashSet<String> dedupedNodes = new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes());
            if (dedupedNodes.size() != ((AMRMClient.ContainerRequest)req).getNodes().size()) {
                Joiner joiner = Joiner.on(',');
                LOG.warn((Object)("ContainerRequest has duplicate nodes: " + joiner.join(((AMRMClient.ContainerRequest)req).getNodes())));
            }
            for (String node : dedupedNodes) {
                this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getCapability(), req, true, ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
            }
        }
        for (String rack : dedupedRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req, true, ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
        }
        for (String rack : inferredRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req, ((AMRMClient.ContainerRequest)req).getRelaxLocality(), ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
        }
        this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getCapability(), req, ((AMRMClient.ContainerRequest)req).getRelaxLocality(), ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
    }

    @Override
    public synchronized void removeContainerRequest(T req) {
        Preconditions.checkArgument(req != null, "Resource request can not be null.");
        HashSet<String> allRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            allRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
        }
        allRacks.addAll(this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes()));
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            for (String node : new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes())) {
                this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getCapability(), req);
            }
        }
        for (String rack : allRacks) {
            this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req);
        }
        this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getCapability(), req);
    }

    @Override
    public synchronized void requestContainerResourceChange(Container container, Resource capability) {
        this.validateContainerResourceChangeRequest(container.getId(), container.getResource(), capability);
        if (this.change.get(container.getId()) == null) {
            this.change.put(container.getId(), new AbstractMap.SimpleEntry<Container, Resource>(container, capability));
        } else {
            this.change.get(container.getId()).setValue(capability);
        }
        if (this.pendingChange.get(container.getId()) == null) {
            this.pendingChange.put(container.getId(), new AbstractMap.SimpleEntry<Container, Resource>(container, capability));
        } else {
            this.pendingChange.get(container.getId()).setValue(capability);
        }
    }

    @Override
    public synchronized void releaseAssignedContainer(ContainerId containerId) {
        Preconditions.checkArgument(containerId != null, "ContainerId can not be null.");
        this.pendingRelease.add(containerId);
        this.release.add(containerId);
        this.pendingChange.remove(containerId);
    }

    @Override
    public synchronized Resource getAvailableResources() {
        return this.clusterAvailableResources;
    }

    @Override
    public synchronized int getClusterNodeCount() {
        return this.clusterNodeCount;
    }

    @Override
    public synchronized List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, Resource capability) {
        Preconditions.checkArgument(capability != null, "The Resource to be requested should not be null ");
        Preconditions.checkArgument(priority != null, "The priority at which to request containers should not be null ");
        LinkedList list = new LinkedList();
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            return list;
        }
        TreeMap<Resource, ResourceRequestInfo> reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            return list;
        }
        ResourceRequestInfo resourceRequestInfo = reqMap.get(capability);
        if (resourceRequestInfo != null && !resourceRequestInfo.containerRequests.isEmpty()) {
            list.add(resourceRequestInfo.containerRequests);
            return list;
        }
        SortedMap<Resource, ResourceRequestInfo> tailMap = reqMap.tailMap(capability);
        for (Map.Entry<Resource, ResourceRequestInfo> entry : tailMap.entrySet()) {
            if (!AMRMClientImpl.canFit(entry.getKey(), capability) || entry.getValue().containerRequests.isEmpty()) continue;
            list.add(entry.getValue().containerRequests);
        }
        return list;
    }

    private Set<String> resolveRacks(List<String> nodes) {
        HashSet<String> racks = new HashSet<String>();
        if (nodes != null) {
            for (String node : nodes) {
                String rack = RackResolver.resolve(node).getNetworkLocation();
                if (rack == null) {
                    LOG.warn((Object)("Failed to resolve rack for node " + node + "."));
                    continue;
                }
                racks.add(rack);
            }
        }
        return racks;
    }

    private void checkLocalityRelaxationConflict(Priority priority, Collection<String> locations, boolean relaxLocality) {
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            return;
        }
        for (String location : locations) {
            boolean existingRelaxLocality;
            TreeMap<Resource, ResourceRequestInfo> reqs = remoteRequests.get(location);
            if (reqs == null || reqs.isEmpty() || relaxLocality == (existingRelaxLocality = reqs.values().iterator().next().remoteRequest.getRelaxLocality())) continue;
            throw new InvalidContainerRequestException("Cannot submit a ContainerRequest asking for location " + location + " with locality relaxation " + relaxLocality + " when it has " + "already been requested with locality relaxation " + existingRelaxLocality);
        }
    }

    private void checkNodeLabelExpression(T containerRequest) {
        String exp = ((AMRMClient.ContainerRequest)containerRequest).getNodeLabelExpression();
        if (null == exp || exp.isEmpty()) {
            return;
        }
        if (exp.contains("&&") || exp.contains("||")) {
            throw new InvalidContainerRequestException("Cannot specify more than two node labels in a single node label expression");
        }
    }

    private void validateContainerResourceChangeRequest(ContainerId containerId, Resource original, Resource target) {
        Preconditions.checkArgument(containerId != null, "ContainerId cannot be null");
        Preconditions.checkArgument(original != null, "Original resource capability cannot be null");
        Preconditions.checkArgument(!Resources.equals(Resources.none(), original) && Resources.fitsIn(Resources.none(), original), "Original resource capability must be greater than 0");
        Preconditions.checkArgument(target != null, "Target resource capability cannot be null");
        Preconditions.checkArgument(!Resources.equals(Resources.none(), target) && Resources.fitsIn(Resources.none(), target), "Target resource capability must be greater than 0");
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        if (this.ask.contains(remoteRequest)) {
            this.ask.remove(remoteRequest);
        }
        this.ask.add(remoteRequest);
    }

    private void addResourceRequest(Priority priority, String resourceName, Resource capability, T req, boolean relaxLocality, String labelExpression) {
        ResourceRequestInfo resourceRequestInfo;
        TreeMap<Resource, ResourceRequestInfo> reqMap;
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            remoteRequests = new HashMap<String, TreeMap<Resource, ResourceRequestInfo>>();
            this.remoteRequestsTable.put(priority, remoteRequests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority));
            }
        }
        if ((reqMap = remoteRequests.get(resourceName)) == null) {
            reqMap = new TreeMap(new ResourceReverseMemoryThenCpuComparator());
            remoteRequests.put(resourceName, reqMap);
        }
        if ((resourceRequestInfo = reqMap.get(capability)) == null) {
            resourceRequestInfo = new ResourceRequestInfo(priority, resourceName, capability, relaxLocality);
            reqMap.put(capability, resourceRequestInfo);
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() + 1);
        if (relaxLocality) {
            resourceRequestInfo.containerRequests.add(req);
        }
        if ("*".equals(resourceName)) {
            resourceRequestInfo.remoteRequest.setNodeLabelExpression(labelExpression);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, Resource capability, T req) {
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as priority " + priority + " is not present in request table"));
            }
            return;
        }
        Map reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as " + resourceName + " is not present in request table"));
            }
            return;
        }
        ResourceRequestInfo resourceRequestInfo = (ResourceRequestInfo)reqMap.get(capability);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEFORE decResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() - 1);
        resourceRequestInfo.containerRequests.remove(req);
        if (resourceRequestInfo.remoteRequest.getNumContainers() < 0) {
            resourceRequestInfo.remoteRequest.setNumContainers(0);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (resourceRequestInfo.remoteRequest.getNumContainers() == 0) {
            reqMap.remove(capability);
            if (reqMap.size() == 0) {
                remoteRequests.remove(resourceName);
            }
            if (remoteRequests.size() == 0) {
                this.remoteRequestsTable.remove(priority);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("AFTER decResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    @Override
    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (blacklistAdditions != null) {
            this.blacklistAdditions.addAll(blacklistAdditions);
            this.blacklistedNodes.addAll(blacklistAdditions);
            this.blacklistRemovals.removeAll(blacklistAdditions);
        }
        if (blacklistRemovals != null) {
            this.blacklistRemovals.addAll(blacklistRemovals);
            this.blacklistedNodes.removeAll(blacklistRemovals);
            this.blacklistAdditions.removeAll(blacklistRemovals);
        }
        if (blacklistAdditions != null && blacklistRemovals != null && blacklistAdditions.removeAll(blacklistRemovals)) {
            LOG.warn((Object)"The same resources appear in both blacklistAdditions and blacklistRemovals in updateBlacklist.");
        }
    }

    private void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token) throws IOException {
        Token amrmToken = new Token(token.getIdentifier().array(), token.getPassword().array(), new Text(token.getKind()), new Text(token.getService()));
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        LOG.info((Object)"Updating with new AMRMToken");
        currentUGI.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService(this.getConfig()));
    }

    class ResourceReverseMemoryThenCpuComparator
    implements Comparator<Resource> {
        ResourceReverseMemoryThenCpuComparator() {
        }

        @Override
        public int compare(Resource arg0, Resource arg1) {
            long mem0 = arg0.getMemorySize();
            long mem1 = arg1.getMemorySize();
            long cpu0 = arg0.getVirtualCores();
            long cpu1 = arg1.getVirtualCores();
            if (mem0 == mem1) {
                if (cpu0 == cpu1) {
                    return 0;
                }
                if (cpu0 < cpu1) {
                    return 1;
                }
                return -1;
            }
            if (mem0 < mem1) {
                return 1;
            }
            return -1;
        }
    }

    class ResourceRequestInfo {
        ResourceRequest remoteRequest;
        LinkedHashSet<T> containerRequests;

        ResourceRequestInfo(Priority priority, String resourceName, Resource capability, boolean relaxLocality) {
            this.remoteRequest = ResourceRequest.newInstance(priority, resourceName, capability, 0);
            this.remoteRequest.setRelaxLocality(relaxLocality);
            this.containerRequests = new LinkedHashSet();
        }
    }
}

