/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timeline;

import java.util.Iterator;
import org.apache.flink.hadoop.shaded.com.google.common.base.Splitter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineEntityGroupId
implements Comparable<TimelineEntityGroupId> {
    private static final Splitter SPLITTER = Splitter.on('_').trimResults();
    private ApplicationId applicationId;
    private String id;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String TIMELINE_ENTITY_GROUPID_STR_PREFIX = "timelineEntityGroupId";

    public static TimelineEntityGroupId newInstance(ApplicationId applicationId, String id) {
        TimelineEntityGroupId timelineEntityGroupId = new TimelineEntityGroupId();
        timelineEntityGroupId.setApplicationId(applicationId);
        timelineEntityGroupId.setTimelineEntityGroupId(id);
        return timelineEntityGroupId;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(ApplicationId appID) {
        this.applicationId = appID;
    }

    public String getTimelineEntityGroupId() {
        return this.id;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected void setTimelineEntityGroupId(String timelineEntityGroupId) {
        this.id = timelineEntityGroupId;
    }

    public int hashCode() {
        int result = this.getTimelineEntityGroupId().hashCode();
        result = 31 * result + this.getApplicationId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineEntityGroupId otherObject = (TimelineEntityGroupId)obj;
        if (!this.getApplicationId().equals(otherObject.getApplicationId())) {
            return false;
        }
        return this.getTimelineEntityGroupId().equals(otherObject.getTimelineEntityGroupId());
    }

    @Override
    public int compareTo(TimelineEntityGroupId other) {
        int compareAppIds = this.getApplicationId().compareTo(other.getApplicationId());
        if (compareAppIds == 0) {
            return this.getTimelineEntityGroupId().compareTo(other.getTimelineEntityGroupId());
        }
        return compareAppIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("timelineEntityGroupId_");
        ApplicationId appId = this.getApplicationId();
        sb.append(appId.getClusterTimestamp()).append("_");
        sb.append(appId.getId()).append("_");
        sb.append(this.getTimelineEntityGroupId());
        return sb.toString();
    }

    public static TimelineEntityGroupId fromString(String timelineEntityGroupIdStr) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = SPLITTER.split(timelineEntityGroupIdStr).iterator();
        if (!it.next().equals(TIMELINE_ENTITY_GROUPID_STR_PREFIX)) {
            throw new IllegalArgumentException("Invalid TimelineEntityGroupId prefix: " + timelineEntityGroupIdStr);
        }
        ApplicationId appId = ApplicationId.newInstance(Long.parseLong(it.next()), Integer.parseInt(it.next()));
        buf.append(it.next());
        while (it.hasNext()) {
            buf.append("_");
            buf.append(it.next());
        }
        return TimelineEntityGroupId.newInstance(appId, buf.toString());
    }
}

