/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationUtilsClient;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String WEBSERVICE = "webservice";
    private static final String RENEWER = "renewer";
    private static final String CANCEL = "cancel";
    private static final String RENEW = "renew";
    private static final String PRINT = "print";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";

    private static void printUsage(PrintStream err) {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err.println("  --print             Print the delegation token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage(err);
        ExitUtil.terminate(1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile(file, conf);
        return creds.getAllTokens();
    }

    public static void main(String[] args) throws Exception {
        final HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at");
        fetcherOptions.addOption(RENEWER, true, "Name of the delegation token renewer");
        fetcherOptions.addOption(CANCEL, false, "cancel the token");
        fetcherOptions.addOption(RENEW, false, "renew the token");
        fetcherOptions.addOption(PRINT, false, "print the token");
        fetcherOptions.addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser(conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        final String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        final String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        final boolean cancel = cmd.hasOption(CANCEL);
        final boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        boolean help = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help) {
            DelegationTokenFetcher.printUsage(System.out);
            System.exit(0);
        }
        if (cancel && renew || cancel && print || renew && print || cancel && renew && print) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exacltly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal(conf);
        final Path tokenFile = new Path(((FileSystem)local).getWorkingDirectory(), remaining[0]);
        final URLConnectionFactory connectionFactory = URLConnectionFactory.DEFAULT_SYSTEM_CONNECTION_FACTORY;
        UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
                        id.readFields(in);
                        System.out.println("Token (" + id + ") for " + token.getService());
                    }
                    return null;
                }
                if (renew) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token.isManaged()) continue;
                        long result = token.renew(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Renewed token for " + token.getService() + " until: " + new Date(result)));
                    }
                } else if (cancel) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token.isManaged()) continue;
                        token.cancel(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Cancelled token for " + token.getService()));
                    }
                } else if (webUrl != null) {
                    Credentials creds = DelegationUtilsClient.getDTfromRemote(connectionFactory, new URI(webUrl), renewer, null);
                    creds.writeTokenStorageFile(tokenFile, conf);
                    for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
                        System.out.println("Fetched token via " + webUrl + " for " + token.getService() + " into " + tokenFile);
                    }
                } else {
                    FileSystem fs = FileSystem.get(conf);
                    Credentials cred = new Credentials();
                    Token<?>[] tokens = fs.addDelegationTokens(renewer, cred);
                    cred.writeTokenStorageFile(tokenFile, conf);
                    for (Token<?> token : tokens) {
                        System.out.println("Fetched token for " + token.getService() + " into " + tokenFile);
                    }
                }
                return null;
            }
        });
    }
}

