/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.client.impl.BlockReaderFactory;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.StoragePolicySummary;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.util.Time;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
public class NamenodeFsck
implements DataEncryptionKeyFactory {
    public static final Log LOG = LogFactory.getLog((String)NameNode.class.getName());
    public static final String CORRUPT_STATUS = "is CORRUPT";
    public static final String HEALTHY_STATUS = "is HEALTHY";
    public static final String DECOMMISSIONING_STATUS = "is DECOMMISSIONING";
    public static final String DECOMMISSIONED_STATUS = "is DECOMMISSIONED";
    public static final String NONEXISTENT_STATUS = "does not exist";
    public static final String FAILURE_STATUS = "FAILED";
    public static final String UNDEFINED = "undefined";
    private final NameNode namenode;
    private final NetworkTopology networktopology;
    private final int totalDatanodes;
    private final InetAddress remoteAddress;
    private String lostFound = null;
    private boolean lfInited = false;
    private boolean lfInitedOk = false;
    private boolean showFiles = false;
    private boolean showOpenFiles = false;
    private boolean showBlocks = false;
    private boolean showLocations = false;
    private boolean showRacks = false;
    private boolean showStoragePolcies = false;
    private boolean showCorruptFileBlocks = false;
    private boolean showReplicaDetails = false;
    private boolean showUpgradeDomains = false;
    private long staleInterval;
    private Tracer tracer;
    private boolean internalError = false;
    private boolean doMove = false;
    private boolean doDelete = false;
    String path = "/";
    private String blockIds = null;
    private final String[] currentCookie = new String[]{null};
    private final Configuration conf;
    private final PrintWriter out;
    private List<String> snapshottableDirs = null;
    private final BlockPlacementPolicy bpPolicy;
    private StoragePolicySummary storageTypeSummary = null;

    NamenodeFsck(Configuration conf, NameNode namenode, NetworkTopology networktopology, Map<String, String[]> pmap, PrintWriter out, int totalDatanodes, InetAddress remoteAddress) {
        this.conf = conf;
        this.namenode = namenode;
        this.networktopology = networktopology;
        this.out = out;
        this.totalDatanodes = totalDatanodes;
        this.remoteAddress = remoteAddress;
        this.bpPolicy = BlockPlacementPolicy.getInstance(conf, null, networktopology, namenode.getNamesystem().getBlockManager().getDatanodeManager().getHost2DatanodeMap());
        this.staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
        this.tracer = new Tracer.Builder("NamenodeFsck").conf(TraceUtils.wrapHadoopConf("namenode.fsck.htrace.", conf)).build();
        for (String key : pmap.keySet()) {
            if (key.equals("path")) {
                this.path = pmap.get("path")[0];
                continue;
            }
            if (key.equals("move")) {
                this.doMove = true;
                continue;
            }
            if (key.equals("delete")) {
                this.doDelete = true;
                continue;
            }
            if (key.equals("files")) {
                this.showFiles = true;
                continue;
            }
            if (key.equals("blocks")) {
                this.showBlocks = true;
                continue;
            }
            if (key.equals("locations")) {
                this.showLocations = true;
                continue;
            }
            if (key.equals("racks")) {
                this.showRacks = true;
                continue;
            }
            if (key.equals("replicadetails")) {
                this.showReplicaDetails = true;
                continue;
            }
            if (key.equals("upgradedomains")) {
                this.showUpgradeDomains = true;
                continue;
            }
            if (key.equals("storagepolicies")) {
                this.showStoragePolcies = true;
                continue;
            }
            if (key.equals("openforwrite")) {
                this.showOpenFiles = true;
                continue;
            }
            if (key.equals("listcorruptfileblocks")) {
                this.showCorruptFileBlocks = true;
                continue;
            }
            if (key.equals("startblockafter")) {
                this.currentCookie[0] = pmap.get("startblockafter")[0];
                continue;
            }
            if (key.equals("includeSnapshots")) {
                this.snapshottableDirs = new ArrayList<String>();
                continue;
            }
            if (!key.equals("blockId")) continue;
            this.blockIds = pmap.get("blockId")[0];
        }
    }

    public void blockIdCK(String blockId) {
        if (blockId == null) {
            this.out.println("Please provide valid blockId!");
            return;
        }
        BlockManager bm = this.namenode.getNamesystem().getBlockManager();
        try {
            Block block = new Block(Block.getBlockId(blockId));
            BlockInfo blockInfo = bm.getStoredBlock(block);
            if (blockInfo == null) {
                this.out.println("Block " + blockId + " " + NONEXISTENT_STATUS);
                LOG.warn((Object)("Block " + blockId + " " + NONEXISTENT_STATUS));
                return;
            }
            INodeFile iNode = this.namenode.getNamesystem().getBlockCollection(blockInfo);
            NumberReplicas numberReplicas = bm.countNodes(blockInfo);
            this.out.println("Block Id: " + blockId);
            this.out.println("Block belongs to: " + iNode.getFullPathName());
            this.out.println("No. of Expected Replica: " + blockInfo.getReplication());
            this.out.println("No. of live Replica: " + numberReplicas.liveReplicas());
            this.out.println("No. of excess Replica: " + numberReplicas.excessReplicas());
            this.out.println("No. of stale Replica: " + numberReplicas.replicasOnStaleNodes());
            this.out.println("No. of decommissioned Replica: " + numberReplicas.decommissioned());
            this.out.println("No. of decommissioning Replica: " + numberReplicas.decommissioning());
            this.out.println("No. of corrupted Replica: " + numberReplicas.corruptReplicas());
            Collection<DatanodeDescriptor> corruptionRecord = null;
            if (bm.getCorruptReplicas(block) != null) {
                corruptionRecord = bm.getCorruptReplicas(block);
            }
            for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
                DatanodeDescriptor dn = blockInfo.getDatanode(idx);
                this.out.print("Block replica on datanode/rack: " + dn.getHostName() + dn.getNetworkLocation() + " ");
                if (corruptionRecord != null && corruptionRecord.contains(dn)) {
                    this.out.print("is CORRUPT\t ReasonCode: " + bm.getCorruptReason(block, dn));
                } else if (dn.isDecommissioned()) {
                    this.out.print(DECOMMISSIONED_STATUS);
                } else if (dn.isDecommissionInProgress()) {
                    this.out.print(DECOMMISSIONING_STATUS);
                } else {
                    this.out.print(HEALTHY_STATUS);
                }
                this.out.print("\n");
            }
        }
        catch (Exception e) {
            String errMsg = "Fsck on blockId '" + blockId;
            LOG.warn((Object)errMsg, (Throwable)e);
            this.out.println(e.getMessage());
            this.out.print("\n\n" + errMsg);
            LOG.warn((Object)"Error in looking up block", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsck() {
        long startTime = Time.monotonicNow();
        try {
            HdfsFileStatus file;
            SnapshottableDirectoryStatus[] snapshotDirs;
            if (this.blockIds != null) {
                String[] blocks = this.blockIds.split(" ");
                StringBuilder sb = new StringBuilder();
                sb.append("FSCK started by " + UserGroupInformation.getCurrentUser() + " from " + this.remoteAddress + " at " + new Date());
                this.out.println(sb);
                sb.append(" for blockIds: \n");
                for (String blk : blocks) {
                    if (blk == null || !blk.contains("blk_")) {
                        this.out.println("Incorrect blockId format: " + blk);
                        continue;
                    }
                    this.out.print("\n");
                    this.blockIdCK(blk);
                    sb.append(blk + "\n");
                }
                LOG.info((Object)sb);
                this.namenode.getNamesystem().logFsckEvent("/", this.remoteAddress);
                this.out.flush();
                return;
            }
            String msg = "FSCK started by " + UserGroupInformation.getCurrentUser() + " from " + this.remoteAddress + " for path " + this.path + " at " + new Date();
            LOG.info((Object)msg);
            this.out.println(msg);
            this.namenode.getNamesystem().logFsckEvent(this.path, this.remoteAddress);
            if (this.snapshottableDirs != null && (snapshotDirs = this.namenode.getRpcServer().getSnapshottableDirListing()) != null) {
                for (SnapshottableDirectoryStatus dir : snapshotDirs) {
                    this.snapshottableDirs.add(dir.getFullPath().toString());
                }
            }
            if ((file = this.namenode.getRpcServer().getFileInfo(this.path)) != null) {
                if (this.showCorruptFileBlocks) {
                    this.listCorruptFileBlocks();
                    return;
                }
                if (this.showStoragePolcies) {
                    this.storageTypeSummary = new StoragePolicySummary(this.namenode.getNamesystem().getBlockManager().getStoragePolicies());
                }
                Result res = new Result(this.conf);
                this.check(this.path, file, res);
                this.out.println(res);
                this.out.println(" Number of data-nodes:\t\t" + this.totalDatanodes);
                this.out.println(" Number of racks:\t\t" + this.networktopology.getNumOfRacks());
                if (this.showStoragePolcies) {
                    this.out.print(this.storageTypeSummary);
                }
                this.out.println("FSCK ended at " + new Date() + " in " + (Time.monotonicNow() - startTime) + " milliseconds");
                if (this.internalError) {
                    throw new IOException("fsck encountered internal errors!");
                }
                if (res.isHealthy()) {
                    this.out.print("\n\nThe filesystem under path '" + this.path + "' " + HEALTHY_STATUS);
                } else {
                    this.out.print("\n\nThe filesystem under path '" + this.path + "' " + CORRUPT_STATUS);
                }
            } else {
                this.out.print("\n\nPath '" + this.path + "' " + NONEXISTENT_STATUS);
            }
        }
        catch (Exception e) {
            String errMsg = "Fsck on path '" + this.path + "' " + FAILURE_STATUS;
            LOG.warn((Object)errMsg, (Throwable)e);
            this.out.println("FSCK ended at " + new Date() + " in " + (Time.monotonicNow() - startTime) + " milliseconds");
            this.out.println(e.getMessage());
            this.out.print("\n\n" + errMsg);
        }
        finally {
            this.out.close();
        }
    }

    private void listCorruptFileBlocks() throws IOException {
        List<String> corrputBlocksFiles = this.namenode.getNamesystem().listCorruptFileBlocksWithSnapshot(this.path, this.snapshottableDirs, this.currentCookie);
        int numCorruptFiles = corrputBlocksFiles.size();
        String filler = numCorruptFiles > 0 ? Integer.toString(numCorruptFiles) : (this.currentCookie[0].equals("0") ? "no" : "no more");
        this.out.println("Cookie:\t" + this.currentCookie[0]);
        for (String s : corrputBlocksFiles) {
            this.out.println(s);
        }
        this.out.println("\n\nThe filesystem under path '" + this.path + "' has " + filler + " CORRUPT files");
        this.out.println();
    }

    @VisibleForTesting
    void check(String parent, HdfsFileStatus file, Result res) throws IOException {
        String path = file.getFullName(parent);
        if (file.isDir()) {
            this.checkDir(path, res);
            return;
        }
        if (file.isSymlink()) {
            if (this.showFiles) {
                this.out.println(path + " <symlink>");
            }
            ++res.totalSymlinks;
            return;
        }
        LocatedBlocks blocks = this.getBlockLocations(path, file);
        if (blocks == null) {
            return;
        }
        this.collectFileSummary(path, file, res, blocks);
        this.collectBlocksSummary(parent, file, res, blocks);
    }

    private void checkDir(String path, Result res) throws IOException {
        DirectoryListing thisListing;
        if (this.snapshottableDirs != null && this.snapshottableDirs.contains(path)) {
            String snapshotPath = (path.endsWith("/") ? path : path + "/") + ".snapshot";
            HdfsFileStatus snapshotFileInfo = this.namenode.getRpcServer().getFileInfo(snapshotPath);
            this.check(snapshotPath, snapshotFileInfo, res);
        }
        byte[] lastReturnedName = HdfsFileStatus.EMPTY_NAME;
        if (this.showFiles) {
            this.out.println(path + " <dir>");
        }
        ++res.totalDirs;
        do {
            assert (lastReturnedName != null);
            thisListing = this.namenode.getRpcServer().getListing(path, lastReturnedName, false);
            if (thisListing == null) {
                return;
            }
            HdfsFileStatus[] files = thisListing.getPartialListing();
            for (int i = 0; i < files.length; ++i) {
                this.check(path, files[i], res);
            }
            lastReturnedName = thisListing.getLastName();
        } while (thisListing.hasMore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlocks getBlockLocations(String path, HdfsFileStatus file) throws IOException {
        long fileLen = file.getLen();
        LocatedBlocks blocks = null;
        FSNamesystem fsn = this.namenode.getNamesystem();
        fsn.readLock();
        try {
            blocks = FSDirStatAndListingOp.getBlockLocations((FSDirectory)fsn.getFSDirectory(), (FSPermissionChecker)fsn.getPermissionChecker(), (String)path, (long)0L, (long)fileLen, (boolean)false).blocks;
        }
        catch (FileNotFoundException fnfe) {
            blocks = null;
        }
        finally {
            fsn.readUnlock("fsckGetBlockLocations");
        }
        return blocks;
    }

    private void collectFileSummary(String path, HdfsFileStatus file, Result res, LocatedBlocks blocks) throws IOException {
        long fileLen = file.getLen();
        boolean isOpen = blocks.isUnderConstruction();
        if (isOpen && !this.showOpenFiles) {
            res.totalOpenFilesSize += fileLen;
            res.totalOpenFilesBlocks += (long)blocks.locatedBlockCount();
            ++res.totalOpenFiles;
            return;
        }
        ++res.totalFiles;
        res.totalSize += fileLen;
        res.totalBlocks += (long)blocks.locatedBlockCount();
        if (this.showOpenFiles && isOpen) {
            this.out.print(path + " " + fileLen + " bytes, " + blocks.locatedBlockCount() + " block(s), OPENFORWRITE: ");
        } else if (this.showFiles) {
            this.out.print(path + " " + fileLen + " bytes, " + blocks.locatedBlockCount() + " block(s): ");
        } else {
            this.out.print('.');
        }
        if (res.totalFiles % 100L == 0L) {
            this.out.println();
            if (this.out.checkError()) {
                throw new IOException("fsck encountered an error in its output stream");
            }
        }
    }

    private void collectBlocksSummary(String parent, HdfsFileStatus file, Result res, LocatedBlocks blocks) throws IOException {
        String path = file.getFullName(parent);
        boolean isOpen = blocks.isUnderConstruction();
        if (isOpen && !this.showOpenFiles) {
            return;
        }
        int missing = 0;
        int corrupt = 0;
        long missize = 0L;
        int underReplicatedPerFile = 0;
        int misReplicatedPerFile = 0;
        StringBuilder report = new StringBuilder();
        int blockNumber = 0;
        LocatedBlock lastBlock = blocks.getLastLocatedBlock();
        for (LocatedBlock lBlk : blocks.getLocatedBlocks()) {
            BlockPlacementStatus blockPlacementStatus;
            boolean isCorrupt;
            ExtendedBlock block = lBlk.getBlock();
            if (!blocks.isLastBlockComplete() && lastBlock != null && lastBlock.getBlock().equals(block)) continue;
            BlockManager bm = this.namenode.getNamesystem().getBlockManager();
            BlockInfo storedBlock = bm.getStoredBlock(block.getLocalBlock());
            NumberReplicas numberReplicas = bm.countNodes(storedBlock);
            int decommissionedReplicas = numberReplicas.decommissioned();
            int decommissioningReplicas = numberReplicas.decommissioning();
            res.decommissionedReplicas += (long)decommissionedReplicas;
            res.decommissioningReplicas += (long)decommissioningReplicas;
            int liveReplicas = numberReplicas.liveReplicas();
            int totalReplicasPerBlock = liveReplicas + decommissionedReplicas + decommissioningReplicas;
            res.totalReplicas += (long)totalReplicasPerBlock;
            short targetFileReplication = file.getReplication();
            res.numExpectedReplicas += (long)targetFileReplication;
            if (totalReplicasPerBlock < res.minReplication) {
                ++res.numUnderMinReplicatedBlocks;
            }
            if (liveReplicas > targetFileReplication) {
                res.excessiveReplicas += (long)(liveReplicas - targetFileReplication);
                ++res.numOverReplicatedBlocks;
            }
            if (isCorrupt = lBlk.isCorrupt()) {
                ++corrupt;
                ++res.corruptBlocks;
                this.out.print("\n" + path + ": CORRUPT blockpool " + block.getBlockPoolId() + " block " + block.getBlockName() + "\n");
            }
            if (totalReplicasPerBlock >= res.minReplication) {
                ++res.numMinReplicatedBlocks;
            }
            if (totalReplicasPerBlock < targetFileReplication && totalReplicasPerBlock > 0) {
                res.missingReplicas += (long)(targetFileReplication - totalReplicasPerBlock);
                ++res.numUnderReplicatedBlocks;
                ++underReplicatedPerFile;
                if (!this.showFiles) {
                    this.out.print("\n" + path + ": ");
                }
                this.out.println(" Under replicated " + block + ". Target Replicas is " + targetFileReplication + " but found " + liveReplicas + " live replica(s), " + decommissionedReplicas + " decommissioned replica(s) and " + decommissioningReplicas + " decommissioning replica(s).");
            }
            if (!(blockPlacementStatus = this.bpPolicy.verifyBlockPlacement(lBlk.getLocations(), targetFileReplication)).isPlacementPolicySatisfied()) {
                ++res.numMisReplicatedBlocks;
                ++misReplicatedPerFile;
                if (!this.showFiles) {
                    if (underReplicatedPerFile == 0) {
                        this.out.println();
                    }
                    this.out.print(path + ": ");
                }
                this.out.println(" Replica placement policy is violated for " + block + ". " + blockPlacementStatus.getErrorDescription());
            }
            if (this.showStoragePolcies && lBlk.getStorageTypes() != null) {
                this.countStorageTypeSummary(file, lBlk);
            }
            String blkName = block.toString();
            report.append(blockNumber + ". " + blkName + " len=" + block.getNumBytes());
            if (totalReplicasPerBlock == 0) {
                report.append(" MISSING!");
                res.addMissing(blkName, block.getNumBytes());
                ++missing;
                missize += block.getNumBytes();
            } else {
                report.append(" Live_repl=" + liveReplicas);
                if (this.showLocations || this.showRacks || this.showReplicaDetails || this.showUpgradeDomains) {
                    StringBuilder sb = new StringBuilder("[");
                    Iterable<DatanodeStorageInfo> storages = bm.getStorages(block.getLocalBlock());
                    Iterator<DatanodeStorageInfo> iterator = storages.iterator();
                    while (iterator.hasNext()) {
                        DatanodeStorageInfo storage = iterator.next();
                        DatanodeDescriptor dnDesc = storage.getDatanodeDescriptor();
                        if (this.showRacks) {
                            sb.append(NodeBase.getPath(dnDesc));
                        } else {
                            sb.append(new DatanodeInfoWithStorage(dnDesc, storage.getStorageID(), storage.getStorageType()));
                        }
                        if (this.showUpgradeDomains) {
                            String upgradeDomain = dnDesc.getUpgradeDomain() != null ? dnDesc.getUpgradeDomain() : UNDEFINED;
                            sb.append("(ud=" + upgradeDomain + ")");
                        }
                        if (this.showReplicaDetails) {
                            LightWeightHashSet<Block> blocksExcess = bm.excessReplicateMap.get(dnDesc.getDatanodeUuid());
                            Collection<DatanodeDescriptor> corruptReplicas = bm.getCorruptReplicas(block.getLocalBlock());
                            sb.append("(");
                            if (dnDesc.isDecommissioned()) {
                                sb.append("DECOMMISSIONED)");
                            } else if (dnDesc.isDecommissionInProgress()) {
                                sb.append("DECOMMISSIONING)");
                            } else if (corruptReplicas != null && corruptReplicas.contains(dnDesc)) {
                                sb.append("CORRUPT)");
                            } else if (blocksExcess != null && blocksExcess.contains(block.getLocalBlock())) {
                                sb.append("EXCESS)");
                            } else if (dnDesc.isStale(this.staleInterval)) {
                                sb.append("STALE_NODE)");
                            } else if (storage.areBlockContentsStale()) {
                                sb.append("STALE_BLOCK_CONTENT)");
                            } else {
                                sb.append("LIVE)");
                            }
                        }
                        if (!iterator.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                    report.append(" " + sb.toString());
                }
            }
            report.append('\n');
            ++blockNumber;
        }
        if (missing > 0 || corrupt > 0) {
            if (!this.showFiles && missing > 0) {
                this.out.print("\n" + path + ": MISSING " + missing + " blocks of total size " + missize + " B.");
            }
            ++res.corruptFiles;
            if (isOpen) {
                LOG.info((Object)("Fsck: ignoring open file " + path));
            } else {
                if (this.doMove) {
                    this.copyBlocksToLostFound(parent, file, blocks);
                }
                if (this.doDelete) {
                    this.deleteCorruptedFile(path);
                }
            }
        }
        if (this.showFiles) {
            if (missing > 0) {
                this.out.print(" MISSING " + missing + " blocks of total size " + missize + " B\n");
            } else if (underReplicatedPerFile == 0 && misReplicatedPerFile == 0) {
                this.out.print(" OK\n");
            }
            if (this.showBlocks) {
                this.out.print(report + "\n");
            }
        }
    }

    private void countStorageTypeSummary(HdfsFileStatus file, LocatedBlock lBlk) {
        StorageType[] storageTypes = lBlk.getStorageTypes();
        this.storageTypeSummary.add(Arrays.copyOf(storageTypes, storageTypes.length), this.namenode.getNamesystem().getBlockManager().getStoragePolicy(file.getStoragePolicy()));
    }

    private void deleteCorruptedFile(String path) {
        try {
            this.namenode.getRpcServer().delete(path, true);
            LOG.info((Object)("Fsck: deleted corrupt file " + path));
        }
        catch (Exception e) {
            LOG.error((Object)("Fsck: error deleting corrupted file " + path), (Throwable)e);
            this.internalError = true;
        }
    }

    boolean hdfsPathExists(String path) throws AccessControlException, UnresolvedLinkException, IOException {
        try {
            HdfsFileStatus hfs = this.namenode.getRpcServer().getFileInfo(path);
            return hfs != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBlocksToLostFound(String parent, HdfsFileStatus file, LocatedBlocks blocks) throws IOException {
        DFSClient dfs = new DFSClient(DFSUtilClient.getNNAddress(this.conf), this.conf);
        String fullName = file.getFullName(parent);
        OutputStream fos = null;
        try {
            if (!this.lfInited) {
                this.lostFoundInit(dfs);
            }
            if (!this.lfInitedOk) {
                throw new IOException("failed to initialize lost+found");
            }
            String target = this.lostFound + fullName;
            if (this.hdfsPathExists(target)) {
                LOG.warn((Object)("Fsck: can't copy the remains of " + fullName + " to " + "lost+found, because " + target + " already exists."));
                return;
            }
            if (!this.namenode.getRpcServer().mkdirs(target, file.getPermission(), true)) {
                throw new IOException("failed to create directory " + target);
            }
            int chain = 0;
            boolean copyError = false;
            for (LocatedBlock lBlk : blocks.getLocatedBlocks()) {
                LocatedBlock lblock = lBlk;
                DatanodeInfo[] locs = lblock.getLocations();
                if (locs == null || locs.length == 0) {
                    if (fos == null) continue;
                    fos.flush();
                    fos.close();
                    fos = null;
                    continue;
                }
                if (fos == null) {
                    fos = dfs.create(target + "/" + chain, true);
                    ++chain;
                }
                try {
                    this.copyBlock(dfs, lblock, fos);
                }
                catch (Exception e) {
                    LOG.error((Object)("Fsck: could not copy block " + lblock.getBlock() + " to " + target), (Throwable)e);
                    fos.flush();
                    fos.close();
                    fos = null;
                    this.internalError = true;
                    copyError = true;
                }
            }
            if (copyError) {
                LOG.warn((Object)("Fsck: there were errors copying the remains of the corrupted file " + fullName + " to /lost+found"));
            } else {
                LOG.info((Object)("Fsck: copied the remains of the corrupted file " + fullName + " to /lost+found"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("copyBlocksToLostFound: error processing " + fullName), (Throwable)e);
            this.internalError = true;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            dfs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBlock(final DFSClient dfs, LocatedBlock lblock, OutputStream fos) throws Exception {
        int failures = 0;
        InetSocketAddress targetAddr = null;
        TreeSet<DatanodeInfo> deadNodes = new TreeSet<DatanodeInfo>();
        BlockReader blockReader = null;
        ExtendedBlock block = lblock.getBlock();
        while (blockReader == null) {
            DatanodeInfo chosenNode;
            try {
                chosenNode = this.bestNode(dfs, lblock.getLocations(), deadNodes);
                targetAddr = NetUtils.createSocketAddr(chosenNode.getXferAddr());
            }
            catch (IOException ie) {
                if (failures >= 3) {
                    throw new IOException("Could not obtain block " + lblock, ie);
                }
                LOG.info((Object)("Could not obtain block from any node:  " + ie));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                deadNodes.clear();
                ++failures;
                continue;
            }
            try {
                String file = BlockReaderFactory.getFileName(targetAddr, block.getBlockPoolId(), block.getBlockId());
                blockReader = new BlockReaderFactory(dfs.getConf()).setFileName(file).setBlock(block).setBlockToken(lblock.getBlockToken()).setStartOffset(0L).setLength(block.getNumBytes()).setVerifyChecksum(true).setClientName("fsck").setDatanodeInfo(chosenNode).setInetSocketAddress(targetAddr).setCachingStrategy(CachingStrategy.newDropBehind()).setClientCacheContext(dfs.getClientContext()).setConfiguration(this.namenode.conf).setTracer(this.tracer).setRemotePeerFactory(new RemotePeerFactory(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
                        Peer peer = null;
                        Socket s = NetUtils.getDefaultSocketFactory(NamenodeFsck.this.conf).createSocket();
                        try {
                            s.connect(addr, 60000);
                            s.setSoTimeout(60000);
                            peer = DFSUtilClient.peerFromSocketAndKey(dfs.getSaslDataTransferClient(), s, NamenodeFsck.this, blockToken, datanodeId, 60000);
                        }
                        finally {
                            if (peer == null) {
                                IOUtils.closeQuietly((Socket)s);
                            }
                        }
                        return peer;
                    }
                }).build();
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to connect to " + targetAddr + ":" + ex));
                deadNodes.add(chosenNode);
            }
        }
        byte[] buf = new byte[1024];
        int cnt = 0;
        boolean success = true;
        long bytesRead = 0L;
        try {
            while ((cnt = blockReader.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, cnt);
                bytesRead += (long)cnt;
            }
            if (bytesRead != block.getNumBytes()) {
                throw new IOException("Recorded block size is " + block.getNumBytes() + ", but datanode returned " + bytesRead + " bytes");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error reading block", (Throwable)e);
            success = false;
        }
        finally {
            blockReader.close();
        }
        if (!success) {
            throw new Exception("Could not copy block data for " + lblock.getBlock());
        }
    }

    @Override
    public DataEncryptionKey newDataEncryptionKey() throws IOException {
        return this.namenode.getRpcServer().getDataEncryptionKey();
    }

    private DatanodeInfo bestNode(DFSClient dfs, DatanodeInfo[] nodes, TreeSet<DatanodeInfo> deadNodes) throws IOException {
        DatanodeInfo chosenNode;
        if (nodes == null || nodes.length - deadNodes.size() < 1) {
            throw new IOException("No live nodes contain current block");
        }
        while (deadNodes.contains(chosenNode = nodes[ThreadLocalRandom.current().nextInt(nodes.length)])) {
        }
        return chosenNode;
    }

    private void lostFoundInit(DFSClient dfs) {
        this.lfInited = true;
        try {
            String lfName = "/lost+found";
            HdfsFileStatus lfStatus = dfs.getFileInfo(lfName);
            if (lfStatus == null) {
                this.lfInitedOk = dfs.mkdirs(lfName, null, true);
                this.lostFound = lfName;
            } else if (!lfStatus.isDir()) {
                LOG.warn((Object)"Cannot use /lost+found : a regular file with this name exists.");
                this.lfInitedOk = false;
            } else {
                this.lostFound = lfName;
                this.lfInitedOk = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lfInitedOk = false;
        }
        if (this.lostFound == null) {
            LOG.warn((Object)"Cannot initialize /lost+found .");
            this.lfInitedOk = false;
            this.internalError = true;
        }
    }

    @VisibleForTesting
    static class Result {
        final List<String> missingIds = new ArrayList<String>();
        long missingSize = 0L;
        long corruptFiles = 0L;
        long corruptBlocks = 0L;
        long excessiveReplicas = 0L;
        long missingReplicas = 0L;
        long decommissionedReplicas = 0L;
        long decommissioningReplicas = 0L;
        long numUnderMinReplicatedBlocks = 0L;
        long numOverReplicatedBlocks = 0L;
        long numUnderReplicatedBlocks = 0L;
        long numMisReplicatedBlocks = 0L;
        long numMinReplicatedBlocks = 0L;
        long totalBlocks = 0L;
        long numExpectedReplicas = 0L;
        long totalOpenFilesBlocks = 0L;
        long totalFiles = 0L;
        long totalOpenFiles = 0L;
        long totalDirs = 0L;
        long totalSymlinks = 0L;
        long totalSize = 0L;
        long totalOpenFilesSize = 0L;
        long totalReplicas = 0L;
        final short replication;
        final int minReplication;

        Result(Configuration conf) {
            this.replication = (short)conf.getInt("dfs.replication", 3);
            this.minReplication = (short)conf.getInt("dfs.namenode.replication.min", 1);
        }

        boolean isHealthy() {
            return this.missingIds.size() == 0 && this.corruptBlocks == 0L;
        }

        void addMissing(String id, long size) {
            this.missingIds.add(id);
            this.missingSize += size;
        }

        float getReplicationFactor() {
            if (this.totalBlocks == 0L) {
                return 0.0f;
            }
            return (float)this.totalReplicas / (float)this.totalBlocks;
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            res.append("Status: ").append(this.isHealthy() ? "HEALTHY" : "CORRUPT").append("\n Total size:\t").append(this.totalSize).append(" B");
            if (this.totalOpenFilesSize != 0L) {
                res.append(" (Total open files size: ").append(this.totalOpenFilesSize).append(" B)");
            }
            res.append("\n Total dirs:\t").append(this.totalDirs).append("\n Total files:\t").append(this.totalFiles);
            res.append("\n Total symlinks:\t\t").append(this.totalSymlinks);
            if (this.totalOpenFiles != 0L) {
                res.append(" (Files currently being written: ").append(this.totalOpenFiles).append(")");
            }
            res.append("\n Total blocks (validated):\t").append(this.totalBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (avg. block size ").append(this.totalSize / this.totalBlocks).append(" B)");
            }
            if (this.totalOpenFilesBlocks != 0L) {
                res.append(" (Total open file blocks (not validated): ").append(this.totalOpenFilesBlocks).append(")");
            }
            if (this.corruptFiles > 0L || this.numUnderMinReplicatedBlocks > 0L) {
                res.append("\n  ********************************");
                if (this.numUnderMinReplicatedBlocks > 0L) {
                    res.append("\n  UNDER MIN REPL'D BLOCKS:\t").append(this.numUnderMinReplicatedBlocks);
                    if (this.totalBlocks > 0L) {
                        res.append(" (").append((float)(this.numUnderMinReplicatedBlocks * 100L) / (float)this.totalBlocks).append(" %)");
                    }
                    res.append("\n  ").append("dfs.namenode.replication.min:\t").append(this.minReplication);
                }
                if (this.corruptFiles > 0L) {
                    res.append("\n  CORRUPT FILES:\t").append(this.corruptFiles);
                    if (this.missingSize > 0L) {
                        res.append("\n  MISSING BLOCKS:\t").append(this.missingIds.size()).append("\n  MISSING SIZE:\t\t").append(this.missingSize).append(" B");
                    }
                    if (this.corruptBlocks > 0L) {
                        res.append("\n  CORRUPT BLOCKS: \t").append(this.corruptBlocks);
                    }
                }
                res.append("\n  ********************************");
            }
            res.append("\n Minimally replicated blocks:\t").append(this.numMinReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (").append((float)(this.numMinReplicatedBlocks * 100L) / (float)this.totalBlocks).append(" %)");
            }
            res.append("\n Over-replicated blocks:\t").append(this.numOverReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (").append((float)(this.numOverReplicatedBlocks * 100L) / (float)this.totalBlocks).append(" %)");
            }
            res.append("\n Under-replicated blocks:\t").append(this.numUnderReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (").append((float)(this.numUnderReplicatedBlocks * 100L) / (float)this.totalBlocks).append(" %)");
            }
            res.append("\n Mis-replicated blocks:\t\t").append(this.numMisReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (").append((float)(this.numMisReplicatedBlocks * 100L) / (float)this.totalBlocks).append(" %)");
            }
            res.append("\n Default replication factor:\t").append(this.replication).append("\n Average block replication:\t").append(this.getReplicationFactor()).append("\n Corrupt blocks:\t\t").append(this.corruptBlocks).append("\n Missing replicas:\t\t").append(this.missingReplicas);
            if (this.totalReplicas > 0L) {
                res.append(" (").append((float)(this.missingReplicas * 100L) / (float)this.numExpectedReplicas).append(" %)");
            }
            if (this.decommissionedReplicas > 0L) {
                res.append("\n DecommissionedReplicas:\t").append(this.decommissionedReplicas);
            }
            if (this.decommissioningReplicas > 0L) {
                res.append("\n DecommissioningReplicas:\t").append(this.decommissioningReplicas);
            }
            return res.toString();
        }
    }
}

