/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.hadoop.shaded.com.google.protobuf.BlockingService;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeLifelineProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerFaultInjector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.InotifyFSEditLogOpTranslator;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshRegistry;
import org.apache.hadoop.ipc.RefreshResponse;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.ipc.proto.GenericRefreshProtocolProtos;
import org.apache.hadoop.ipc.proto.RefreshCallQueueProtocolProtos;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolServerSideTranslatorPB;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.proto.RefreshAuthorizationPolicyProtocolProtos;
import org.apache.hadoop.security.proto.RefreshUserMappingsProtocolProtos;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.proto.GetUserMappingsProtocolProtos;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminPB;
import org.apache.hadoop.tracing.TraceAdminProtocolPB;
import org.apache.hadoop.tracing.TraceAdminProtocolServerSideTranslatorPB;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.slf4j.Logger;

@InterfaceAudience.Private
@VisibleForTesting
public class NameNodeRpcServer
implements NamenodeProtocols {
    private static final Logger LOG = NameNode.LOG;
    private static final Logger stateChangeLog = NameNode.stateChangeLog;
    private static final Logger blockStateChangeLog = NameNode.blockStateChangeLog;
    protected final FSNamesystem namesystem;
    protected final NameNode nn;
    private final NameNodeMetrics metrics;
    private final RetryCache retryCache;
    private final boolean serviceAuthEnabled;
    private final RPC.Server serviceRpcServer;
    private final InetSocketAddress serviceRPCAddress;
    private final RPC.Server lifelineRpcServer;
    private final InetSocketAddress lifelineRPCAddress;
    protected final RPC.Server clientRpcServer;
    protected final InetSocketAddress clientRpcAddress;
    private final String minimumDataNodeVersion;

    public NameNodeRpcServer(Configuration conf, NameNode nn) throws IOException {
        InetSocketAddress listenAddr;
        this.nn = nn;
        this.namesystem = nn.getNamesystem();
        this.retryCache = this.namesystem.getRetryCache();
        this.metrics = NameNode.getNameNodeMetrics();
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        RPC.setProtocolEngine(conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService(clientProtocolServerTranslator);
        int maxDataLength = conf.getInt("ipc.maximum.data.length", 0x4000000);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbTranslator = new DatanodeProtocolServerSideTranslatorPB(this, maxDataLength);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService(dnProtoPbTranslator);
        DatanodeLifelineProtocolServerSideTranslatorPB lifelineProtoPbTranslator = new DatanodeLifelineProtocolServerSideTranslatorPB(this);
        BlockingService lifelineProtoPbService = DatanodeLifelineProtocolProtos.DatanodeLifelineProtocolService.newReflectiveBlockingService(lifelineProtoPbTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB(this);
        BlockingService NNPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService(namenodeProtocolXlator);
        RefreshAuthorizationPolicyProtocolServerSideTranslatorPB refreshAuthPolicyXlator = new RefreshAuthorizationPolicyProtocolServerSideTranslatorPB(this);
        BlockingService refreshAuthService = RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.newReflectiveBlockingService(refreshAuthPolicyXlator);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService(refreshUserMappingXlator);
        RefreshCallQueueProtocolServerSideTranslatorPB refreshCallQueueXlator = new RefreshCallQueueProtocolServerSideTranslatorPB(this);
        BlockingService refreshCallQueueService = RefreshCallQueueProtocolProtos.RefreshCallQueueProtocolService.newReflectiveBlockingService(refreshCallQueueXlator);
        GenericRefreshProtocolServerSideTranslatorPB genericRefreshXlator = new GenericRefreshProtocolServerSideTranslatorPB(this);
        BlockingService genericRefreshService = GenericRefreshProtocolProtos.GenericRefreshProtocolService.newReflectiveBlockingService(genericRefreshXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService(getUserMappingXlator);
        HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB(this);
        BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService(haServiceProtocolXlator);
        TraceAdminProtocolServerSideTranslatorPB traceAdminXlator = new TraceAdminProtocolServerSideTranslatorPB(this);
        BlockingService traceAdminService = TraceAdminPB.TraceAdminService.newReflectiveBlockingService(traceAdminXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress serviceRpcAddr = nn.getServiceRpcServerAddress(conf);
        if (serviceRpcAddr != null) {
            String bindHost = nn.getServiceRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = serviceRpcAddr.getHostName();
            }
            LOG.info("Service RPC server is binding to " + bindHost + ":" + serviceRpcAddr.getPort());
            int serviceHandlerCount = conf.getInt("dfs.namenode.service.handler.count", 10);
            this.serviceRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(serviceRpcAddr.getPort()).setNumHandlers(serviceHandlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.serviceRpcServer);
            InetSocketAddress listenAddr2 = this.serviceRpcServer.getListenerAddress();
            this.serviceRPCAddress = new InetSocketAddress(serviceRpcAddr.getHostName(), listenAddr2.getPort());
            nn.setRpcServiceServerAddress(conf, this.serviceRPCAddress);
        } else {
            this.serviceRpcServer = null;
            this.serviceRPCAddress = null;
        }
        InetSocketAddress lifelineRpcAddr = nn.getLifelineRpcServerAddress(conf);
        if (lifelineRpcAddr != null) {
            RPC.setProtocolEngine(conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
            String bindHost = nn.getLifelineRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = lifelineRpcAddr.getHostName();
            }
            LOG.info("Lifeline RPC server is binding to {}:{}", (Object)bindHost, (Object)lifelineRpcAddr.getPort());
            int lifelineHandlerCount = conf.getInt("dfs.namenode.lifeline.handler.count", 0);
            if (lifelineHandlerCount <= 0) {
                float lifelineHandlerRatio = conf.getFloat("dfs.namenode.lifeline.handler.ratio", 0.1f);
                lifelineHandlerCount = Math.max((int)((float)handlerCount * lifelineHandlerRatio), 1);
            }
            this.lifelineRpcServer = new RPC.Builder(conf).setProtocol(HAServiceProtocolPB.class).setInstance(haPbService).setBindAddress(bindHost).setPort(lifelineRpcAddr.getPort()).setNumHandlers(lifelineHandlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, DatanodeLifelineProtocolPB.class, lifelineProtoPbService, this.lifelineRpcServer);
            listenAddr = this.lifelineRpcServer.getListenerAddress();
            this.lifelineRPCAddress = new InetSocketAddress(lifelineRpcAddr.getHostName(), listenAddr.getPort());
            nn.setRpcLifelineServerAddress(conf, this.lifelineRPCAddress);
        } else {
            this.lifelineRpcServer = null;
            this.lifelineRPCAddress = null;
        }
        InetSocketAddress rpcAddr = nn.getRpcServerAddress(conf);
        String bindHost = nn.getRpcServerBindHost(conf);
        if (bindHost == null) {
            bindHost = rpcAddr.getHostName();
        }
        LOG.info("RPC server is binding to " + bindHost + ":" + rpcAddr.getPort());
        this.clientRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(rpcAddr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
        DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.clientRpcServer);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            this.clientRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            if (this.serviceRpcServer != null) {
                this.serviceRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            }
            if (this.lifelineRpcServer != null) {
                this.lifelineRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            }
        }
        listenAddr = this.clientRpcServer.getListenerAddress();
        this.clientRpcAddress = new InetSocketAddress(rpcAddr.getHostName(), listenAddr.getPort());
        nn.setRpcServerAddress(conf, this.clientRpcAddress);
        this.minimumDataNodeVersion = conf.get("dfs.namenode.min.supported.datanode.version", "2.1.0-beta");
        this.clientRpcServer.addTerseExceptions(SafeModeException.class, FileNotFoundException.class, HadoopIllegalArgumentException.class, FileAlreadyExistsException.class, InvalidPathException.class, ParentNotDirectoryException.class, UnresolvedLinkException.class, AlreadyBeingCreatedException.class, QuotaExceededException.class, RecoveryInProgressException.class, AccessControlException.class, SecretManager.InvalidToken.class, LeaseExpiredException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, AclException.class, FSLimitException.PathComponentTooLongException.class, FSLimitException.MaxDirectoryItemsExceededException.class);
        this.clientRpcServer.addSuppressedLoggingExceptions(StandbyException.class, UnresolvedPathException.class);
        this.clientRpcServer.setTracer(nn.tracer);
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.setTracer(nn.tracer);
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.setTracer(nn.tracer);
        }
    }

    @VisibleForTesting
    RPC.Server getLifelineRpcServer() {
        return this.lifelineRpcServer;
    }

    @VisibleForTesting
    public RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    @VisibleForTesting
    RPC.Server getServiceRpcServer() {
        return this.serviceRpcServer;
    }

    void start() {
        this.clientRpcServer.start();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.start();
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.start();
        }
    }

    void join() throws InterruptedException {
        this.clientRpcServer.join();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.join();
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.join();
        }
    }

    void stop() {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.stop();
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.stop();
        }
    }

    InetSocketAddress getLifelineRpcAddress() {
        return this.lifelineRPCAddress;
    }

    InetSocketAddress getServiceRpcAddress() {
        return this.serviceRPCAddress;
    }

    InetSocketAddress getRpcAddress() {
        return this.clientRpcAddress;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlocks(datanode, size);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlockKeys();
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        LOG.info("Error report from " + registration + ": " + msg);
        if (errorCode == 1) {
            this.namesystem.releaseBackupNode(registration);
        }
    }

    @Override
    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.verifyLayoutVersion(registration.getVersion());
        NamenodeRegistration myRegistration = this.nn.setRegistration();
        this.namesystem.registerBackupNode(registration, myRegistration);
        return myRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        if (!this.nn.isRole(HdfsServerConstants.NamenodeRole.NAMENODE)) {
            throw new IOException("Only an ACTIVE node can invoke startCheckpoint.");
        }
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (NamenodeCommand)cacheEntry.getPayload();
        }
        NamenodeCommand ret = null;
        try {
            ret = this.namesystem.startCheckpoint(registration, this.nn.setRegistration());
            RetryCache.setState(cacheEntry, ret != null, ret);
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, ret != null, ret);
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.endCheckpoint(registration, sig);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getDelegationToken(renewer);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        this.checkNNStartup();
        return this.namesystem.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.checkNNStartup();
        this.namesystem.cancelDelegationToken(token);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.checkNNStartup();
        this.metrics.incrGetBlockLocations();
        return this.namesystem.getBlockLocations(NameNodeRpcServer.getClientMachine(), src, offset, length);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getServerDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (HdfsFileStatus)cacheEntry.getPayload();
        }
        HdfsFileStatus status = null;
        try {
            PermissionStatus perm = new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked);
            status = this.namesystem.startFile(src, perm, clientName, clientMachine, flag.get(), createParent, replication, blockSize, supportedVersions, cacheEntry != null);
            RetryCache.setState(cacheEntry, status != null, status);
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, status != null, status);
            throw throwable;
        }
        this.metrics.incrFilesCreated();
        this.metrics.incrCreateFileOps();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine);
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (LastBlockWithStatus)cacheEntry.getPayload();
        }
        LastBlockWithStatus info = null;
        boolean success = false;
        try {
            info = this.namesystem.appendFile(src, clientName, clientMachine, flag.get(), cacheEntry != null);
            success = true;
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, success, info);
            throw throwable;
        }
        RetryCache.setState(cacheEntry, success, info);
        this.metrics.incrFilesAppended();
        return info;
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        return this.namesystem.recoverLease(src, clientName, clientMachine);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        this.checkNNStartup();
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void unsetStoragePolicy(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.unsetStoragePolicy(src);
    }

    @Override
    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.checkNNStartup();
        this.namesystem.setStoragePolicy(src, policyName);
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getStoragePolicy(path);
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getStoragePolicies();
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.checkNNStartup();
        this.namesystem.setPermission(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkNNStartup();
        this.namesystem.setOwner(src, username, groupname);
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> addBlockFlags) throws IOException {
        this.checkNNStartup();
        LocatedBlock locatedBlock = this.namesystem.getAdditionalBlock(src, fileId, clientName, previous, excludedNodes, favoredNodes, addBlockFlags);
        if (locatedBlock != null) {
            this.metrics.incrAddBlockOps();
        }
        return locatedBlock;
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        this.checkNNStartup();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAdditionalDatanode: src=" + src + ", fileId=" + fileId + ", blk=" + blk + ", existings=" + Arrays.asList(existings) + ", excludes=" + Arrays.asList(excludes) + ", numAdditionalNodes=" + numAdditionalNodes + ", clientName=" + clientName);
        }
        this.metrics.incrGetAdditionalDatanodeOps();
        HashSet<Node> excludeSet = null;
        if (excludes != null) {
            excludeSet = new HashSet<Node>(excludes.length);
            for (DatanodeInfo node : excludes) {
                excludeSet.add(node);
            }
        }
        return this.namesystem.getAdditionalDatanode(src, fileId, blk, existings, existingStorageIDs, excludeSet, numAdditionalNodes, clientName);
    }

    @Override
    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        this.checkNNStartup();
        this.namesystem.abandonBlock(b, fileId, src, holder);
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        this.checkNNStartup();
        return this.namesystem.completeFile(src, clientName, last, fileId);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.checkNNStartup();
        this.namesystem.reportBadBlocks(blocks);
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        this.checkNNStartup();
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes, newStorageIDs, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        this.checkNNStartup();
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets, newtargetstorages);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getPreferredBlockSize(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.namesystem.renameTo(src, dst, cacheEntry != null);
        }
        finally {
            RetryCache.setState(cacheEntry, ret);
        }
        if (ret) {
            this.metrics.incrFilesRenamed();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.concat(trg, src, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.renameTo(src, dst, cacheEntry != null, options);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
        this.metrics.incrFilesRenamed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.truncate: " + src + " to " + newLength);
        }
        String clientMachine = NameNodeRpcServer.getClientMachine();
        try {
            boolean bl = this.namesystem.truncate(src, newLength, clientName, clientMachine, Time.now());
            return bl;
        }
        finally {
            this.metrics.incrFilesTruncated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive);
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.namesystem.delete(src, recursive, cacheEntry != null);
        }
        finally {
            RetryCache.setState(cacheEntry, ret);
        }
        if (ret) {
            this.metrics.incrDeleteFileOps();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.mkdirs: " + src);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), createParent);
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.checkNNStartup();
        this.namesystem.renewLease(clientName);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkNNStartup();
        DirectoryListing files = this.namesystem.getListing(src, startAfter, needLocation);
        if (files != null) {
            this.metrics.incrGetListingOps();
            this.metrics.incrFilesInGetListingOps(files.getPartialListing().length);
        }
        return files;
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkNNStartup();
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, true);
    }

    @Override
    public boolean isFileClosed(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.isFileClosed(src);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.checkNNStartup();
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, false);
    }

    @Override
    public long[] getStats() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkNNStartup();
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        return results;
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkNNStartup();
        DatanodeStorageReport[] reports = this.namesystem.getDatanodeStorageReport(type);
        return reports;
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        this.checkNNStartup();
        NameNode.OperationCategory opCategory = NameNode.OperationCategory.UNCHECKED;
        if (isChecked) {
            opCategory = action == HdfsConstants.SafeModeAction.SAFEMODE_GET ? NameNode.OperationCategory.READ : NameNode.OperationCategory.WRITE;
        }
        this.namesystem.checkOperation(opCategory);
        return this.namesystem.setSafeMode(action);
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws IOException {
        this.checkNNStartup();
        return this.namesystem.restoreFailedStorage(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveNamespace() throws IOException {
        this.checkNNStartup();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.saveNamespace();
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public long rollEdits() throws AccessControlException, IOException {
        this.checkNNStartup();
        CheckpointSignature sig = this.namesystem.rollEditLog();
        return sig.getCurSegmentTxId();
    }

    @Override
    public void refreshNodes() throws IOException {
        this.checkNNStartup();
        this.namesystem.refreshNodes();
    }

    @Override
    public long getTransactionID() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getCorrectLastAppliedOrWrittenTxId();
    }

    @Override
    public long getMostRecentCheckpointTxId() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getMostRecentCheckpointTxId();
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.rollEditLog();
    }

    @Override
    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getEditLog().getEditLogManifest(sinceTxId);
    }

    @Override
    public boolean isUpgradeFinalized() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.isUpgradeFinalized();
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        this.checkNNStartup();
        this.namesystem.finalizeUpgrade();
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        this.checkNNStartup();
        LOG.info("rollingUpgrade " + (Object)((Object)action));
        switch (action) {
            case QUERY: {
                return this.namesystem.queryRollingUpgrade();
            }
            case PREPARE: {
                return this.namesystem.startRollingUpgrade();
            }
            case FINALIZE: {
                return this.namesystem.finalizeRollingUpgrade();
            }
        }
        throw new UnsupportedActionException((Object)((Object)action) + " is not yet supported.");
    }

    @Override
    public void metaSave(String filename) throws IOException {
        this.checkNNStartup();
        this.namesystem.metaSave(filename);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listOpenFiles(prevId);
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        this.checkNNStartup();
        String[] cookieTab = new String[]{cookie};
        Collection<FSNamesystem.CorruptFileBlockInfo> fbs = this.namesystem.listCorruptFileBlocks(path, cookieTab);
        String[] files = new String[fbs.size()];
        int i = 0;
        for (FSNamesystem.CorruptFileBlockInfo fb : fbs) {
            files[i++] = fb.path;
        }
        return new CorruptFileBlocks(files, cookieTab[0]);
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkNNStartup();
        this.namesystem.setBalancerBandwidth(bandwidth);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public QuotaUsage getQuotaUsage(String path) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getQuotaUsage(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        this.checkNNStartup();
        this.namesystem.setQuota(path, namespaceQuota, storagespaceQuota, type);
    }

    @Override
    public void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        this.checkNNStartup();
        this.namesystem.fsync(src, fileId, clientName, lastBlockLength);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkNNStartup();
        this.namesystem.setTimes(src, mtime, atime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds 8000 character limit");
        }
        UserGroupInformation ugi = NameNodeRpcServer.getRemoteUser();
        boolean success = false;
        try {
            PermissionStatus perm = new PermissionStatus(ugi.getShortUserName(), null, dirPerms);
            this.namesystem.createSymlink(target, link, perm, createParent, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        this.checkNNStartup();
        this.metrics.incrGetLinkTargetOps();
        HdfsFileStatus stat = null;
        try {
            stat = this.namesystem.getFileInfo(path, false);
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        if (stat == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!stat.isSymlink()) {
            throw new IOException("Path " + path + " is not a symbolic link");
        }
        return stat.getSymlink();
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.checkNNStartup();
        this.verifySoftwareVersion(nodeReg);
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration nodeReg, StorageReport[] report, long dnCacheCapacity, long dnCacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary, boolean requestFullBlockReportLease) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, report, dnCacheCapacity, dnCacheUsed, xceiverCount, xmitsInProgress, failedVolumes, volumeFailureSummary, requestFullBlockReportLease);
    }

    @Override
    public DatanodeCommand blockReport(final DatanodeRegistration nodeReg, String poolId, final StorageBlockReport[] reports, final BlockReportContext context) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReport: from " + nodeReg + ", reports.length=" + reports.length);
        }
        final BlockManager bm = this.namesystem.getBlockManager();
        boolean noStaleStorages = false;
        int r = 0;
        while (r < reports.length) {
            final BlockListAsLongs blocks = reports[r].getBlocks();
            final int index = r++;
            noStaleStorages = bm.runBlockOp(new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    return bm.processReport(nodeReg, reports[index].getStorage(), blocks, context);
                }
            });
            this.metrics.incrStorageBlockReportOps();
        }
        bm.removeBRLeaseIfNeeded(nodeReg, context);
        BlockManagerFaultInjector.getInstance().incomingBlockReportRpc(nodeReg, context);
        if (this.nn.getFSImage().isUpgradeFinalized() && !this.namesystem.isRollingUpgrade() && !this.nn.isStandbyState() && noStaleStorages) {
            return new FinalizeCommand(poolId);
        }
        return null;
    }

    @Override
    public DatanodeCommand cacheReport(DatanodeRegistration nodeReg, String poolId, List<Long> blockIds) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.cacheReport: from " + nodeReg + " " + blockIds.size() + " blocks");
        }
        this.namesystem.getCacheManager().processCacheReport(nodeReg, blockIds);
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(final DatanodeRegistration nodeReg, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        this.metrics.incrBlockReceivedAndDeletedOps();
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReceivedAndDeleted: from " + nodeReg + " " + receivedAndDeletedBlocks.length + " blocks.");
        }
        BlockManager bm = this.namesystem.getBlockManager();
        for (final StorageReceivedDeletedBlocks r : receivedAndDeletedBlocks) {
            bm.enqueueBlockOp(new Runnable(){

                @Override
                public void run() {
                    try {
                        NameNodeRpcServer.this.namesystem.processIncrementalBlockReport(nodeReg, r);
                    }
                    catch (Exception ex) {
                        blockStateChangeLog.error("*BLOCK* NameNode.blockReceivedAndDeleted: failed from " + nodeReg + ": " + ex.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName;
        this.checkNNStartup();
        String string = dnName = nodeReg == null ? "Unknown DataNode" : nodeReg.toString();
        if (errorCode == 0) {
            LOG.info("Error report from " + dnName + ": " + msg);
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn("Disk error on " + dnName + ": " + msg);
        } else if (errorCode == 3) {
            LOG.warn("Fatal disk error on " + dnName + ": " + msg);
            this.namesystem.getBlockManager().getDatanodeManager().removeDatanode(nodeReg);
        } else {
            LOG.info("Error report from " + dnName + ": " + msg);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getNamespaceInfo();
    }

    @Override
    public void sendLifeline(DatanodeRegistration nodeReg, StorageReport[] report, long dnCacheCapacity, long dnCacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        this.namesystem.handleLifeline(nodeReg, report, dnCacheCapacity, dnCacheUsed, xceiverCount, xmitsInProgress, failedVolumes, volumeFailureSummary);
    }

    private void verifyRequest(NodeRegistration nodeReg) throws IOException {
        String id = nodeReg.getRegistrationID();
        String expectedID = this.namesystem.getRegistrationID();
        if (!expectedID.equals(id)) {
            LOG.warn("Registration IDs mismatched: the " + nodeReg.getClass().getSimpleName() + " ID is " + id + " but the expected ID is " + expectedID);
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        this.checkNNStartup();
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.clientRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        }
    }

    @Override
    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info("Refreshing all user-to-groups mappings. Requested by user: " + NameNodeRpcServer.getRemoteUser().getShortUserName());
        Groups.getUserToGroupsMappingService().refresh();
    }

    @Override
    public void refreshSuperUserGroupsConfiguration() {
        LOG.info("Refreshing SuperUser proxy group mapping list ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    @Override
    public void refreshCallQueue() {
        LOG.info("Refreshing call queue.");
        Configuration conf = new Configuration();
        this.clientRpcServer.refreshCallQueue(conf);
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshCallQueue(conf);
        }
    }

    @Override
    public Collection<RefreshResponse> refresh(String identifier, String[] args) {
        return RefreshRegistry.defaultRegistry().dispatch(identifier, args);
    }

    @Override
    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting groups for user " + user);
        }
        return UserGroupInformation.createRemoteUser(user).getGroupNames();
    }

    @Override
    public synchronized void monitorHealth() throws HealthCheckFailedException, AccessControlException, IOException {
        this.checkNNStartup();
        this.nn.monitorHealth();
    }

    @Override
    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
        this.checkNNStartup();
        this.nn.checkHaStateChange(req);
        this.nn.transitionToActive();
    }

    @Override
    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
        this.checkNNStartup();
        this.nn.checkHaStateChange(req);
        this.nn.transitionToStandby();
    }

    @Override
    public synchronized HAServiceStatus getServiceStatus() throws AccessControlException, ServiceFailedException, IOException {
        this.checkNNStartup();
        return this.nn.getServiceStatus();
    }

    void verifyLayoutVersion(int version) throws IOException {
        if (version != HdfsServerConstants.NAMENODE_LAYOUT_VERSION) {
            throw new IncorrectVersionException(HdfsServerConstants.NAMENODE_LAYOUT_VERSION, version, "data node");
        }
    }

    private void verifySoftwareVersion(DatanodeRegistration dnReg) throws IncorrectVersionException {
        String dnVersion = dnReg.getSoftwareVersion();
        if (VersionUtil.compareVersions(dnVersion, this.minimumDataNodeVersion) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(this.minimumDataNodeVersion, dnVersion, "DataNode", "NameNode");
            LOG.warn(ive.getMessage() + " DN: " + dnReg);
            throw ive;
        }
        String nnVersion = VersionInfo.getVersion();
        if (!dnVersion.equals(nnVersion)) {
            long dnCTime;
            String messagePrefix = "Reported DataNode version '" + dnVersion + "' of DN " + dnReg + " does not match NameNode version '" + nnVersion + "'";
            long nnCTime = this.nn.getFSImage().getStorage().getCTime();
            if (nnCTime != (dnCTime = dnReg.getStorageInfo().getCTime())) {
                IncorrectVersionException ive = new IncorrectVersionException(messagePrefix + " and CTime of DN ('" + dnCTime + "') does not match CTime of NN ('" + nnCTime + "')");
                LOG.warn(ive.toString(), (Throwable)ive);
                throw ive;
            }
            LOG.info(messagePrefix + ". Note: This is normal during a rolling upgrade.");
        }
    }

    private static String getClientMachine() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getBlockManager().generateDataEncryptionKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.checkNNStartup();
        if (!this.checkPathLength(snapshotRoot)) {
            throw new IOException("createSnapshot: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (String)cacheEntry.getPayload();
        }
        this.metrics.incrCreateSnapshotOps();
        String ret = null;
        try {
            ret = this.namesystem.createSnapshot(snapshotRoot, snapshotName, cacheEntry != null);
            RetryCache.setState(cacheEntry, ret != null, ret);
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, ret != null, ret);
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.checkNNStartup();
        if (snapshotName == null || snapshotName.isEmpty()) {
            throw new IOException("The snapshot name is null or empty.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        this.metrics.incrDeleteSnapshotOps();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.deleteSnapshot(snapshotRoot, snapshotName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.checkNNStartup();
        this.metrics.incrAllowSnapshotOps();
        this.namesystem.allowSnapshot(snapshotRoot);
    }

    @Override
    public void disallowSnapshot(String snapshot) throws IOException {
        this.checkNNStartup();
        this.metrics.incrDisAllowSnapshotOps();
        this.namesystem.disallowSnapshot(snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        this.checkNNStartup();
        if (snapshotNewName == null || snapshotNewName.isEmpty()) {
            throw new IOException("The new snapshot name is null or empty.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        this.metrics.incrRenameSnapshotOps();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        this.checkNNStartup();
        SnapshottableDirectoryStatus[] status = this.namesystem.getSnapshottableDirListing();
        this.metrics.incrListSnapshottableDirOps();
        return status;
    }

    @Override
    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        this.checkNNStartup();
        SnapshotDiffReport report = this.namesystem.getSnapshotDiffReport(snapshotRoot, earlierSnapshotName, laterSnapshotName);
        this.metrics.incrSnapshotDiffReportOps();
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (Long)cacheEntry.getPayload();
        }
        boolean success = false;
        long ret = 0L;
        try {
            ret = this.namesystem.addCacheDirective(path, flags, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.modifyCacheDirective(directive, flags, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCacheDirective(long id) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.removeCacheDirective(id, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        this.checkNNStartup();
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        return this.namesystem.listCacheDirectives(prevId, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.addCachePool(info, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.modifyCachePool(info, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCachePool(String cachePoolName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.removeCachePool(cachePoolName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listCachePools(prevKey != null ? prevKey : "");
    }

    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.modifyAclEntries(src, aclSpec);
    }

    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeAclEntries(src, aclSpec);
    }

    @Override
    public void removeDefaultAcl(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeDefaultAcl(src);
    }

    @Override
    public void removeAcl(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeAcl(src);
    }

    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.setAcl(src, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getAclStatus(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.createEncryptionZone(src, keyName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public EncryptionZone getEZForPath(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getEZForPath(src);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listEncryptionZones(prevId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.setXAttr(src, xAttr, flag, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getXAttrs(src, xAttrs);
    }

    @Override
    public List<XAttr> listXAttrs(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listXAttrs(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.removeXAttr(src, xAttr, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    private void checkNNStartup() throws IOException {
        if (!this.nn.isStarted()) {
            throw new RetriableException((Object)((Object)this.nn.getRole()) + " still not started");
        }
    }

    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkAccess(path, mode);
    }

    @Override
    public long getCurrentEditLogTxid() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getEditLog().isOpenForWrite() ? this.namesystem.getEditLog().getLastWrittenTxId() : -1L;
    }

    private static FSEditLogOp readOp(EditLogInputStream elis) throws IOException {
        try {
            return elis.readOp();
        }
        catch (FileNotFoundException e) {
            LOG.debug("Tried to read from deleted or moved edit log segment", (Throwable)e);
            return null;
        }
        catch (TransferFsImage.HttpGetFailedException e) {
            LOG.debug("Tried to read from deleted edit log segment", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        int maxEventsPerRPC = this.nn.conf.getInt("dfs.namenode.inotify.max.events.per.rpc", 1000);
        FSEditLog log = this.namesystem.getFSImage().getEditLog();
        long syncTxid = log.getSyncTxId();
        boolean readInProgress = syncTxid > 0L;
        ArrayList<EventBatch> batches = Lists.newArrayList();
        int totalEvents = 0;
        long maxSeenTxid = -1L;
        long firstSeenTxid = -1L;
        if (syncTxid > 0L && txid > syncTxid) {
            return new EventBatchList(batches, firstSeenTxid, maxSeenTxid, syncTxid);
        }
        Collection<EditLogInputStream> streams = null;
        try {
            streams = log.selectInputStreams(txid, 0L, null, readInProgress);
        }
        catch (IllegalStateException e) {
            LOG.info("NN is transitioning from active to standby and FSEditLog is closed -- could not read edits");
            return new EventBatchList(batches, firstSeenTxid, maxSeenTxid, syncTxid);
        }
        boolean breakOuter = false;
        for (EditLogInputStream elis : streams) {
            try {
                FSEditLogOp op = null;
                while ((op = NameNodeRpcServer.readOp(elis)) != null) {
                    if (syncTxid > 0L && op.getTransactionId() > syncTxid) {
                        breakOuter = true;
                    } else {
                        EventBatch eventBatch = InotifyFSEditLogOpTranslator.translate(op);
                        if (eventBatch != null) {
                            batches.add(eventBatch);
                            totalEvents += eventBatch.getEvents().length;
                        }
                        if (op.getTransactionId() > maxSeenTxid) {
                            maxSeenTxid = op.getTransactionId();
                        }
                        if (firstSeenTxid == -1L) {
                            firstSeenTxid = op.getTransactionId();
                        }
                        if (totalEvents < maxEventsPerRPC && (syncTxid <= 0L || op.getTransactionId() != syncTxid)) continue;
                        breakOuter = true;
                    }
                    break;
                }
            }
            finally {
                elis.close();
            }
            if (!breakOuter) continue;
            break;
        }
        return new EventBatchList(batches, firstSeenTxid, maxSeenTxid, syncTxid);
    }

    @Override
    public SpanReceiverInfo[] listSpanReceivers() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.tracerConfigurationManager.listSpanReceivers();
    }

    @Override
    public long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.tracerConfigurationManager.addSpanReceiver(info);
    }

    @Override
    public void removeSpanReceiver(long id) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.nn.tracerConfigurationManager.removeSpanReceiver(id);
    }
}

