/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.flink.hadoop.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.flink.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.hadoop.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.HttpContent;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ExceptionHandler;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.hadoop.io.IOUtils;

class HdfsWriter
extends SimpleChannelInboundHandler<HttpContent> {
    private final DFSClient client;
    private final OutputStream out;
    private final DefaultHttpResponse response;
    private static final Log LOG = WebHdfsHandler.LOG;

    HdfsWriter(DFSClient client, OutputStream out, DefaultHttpResponse response) {
        this.client = client;
        this.out = out;
        this.response = response;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpContent chunk) throws IOException {
        chunk.content().readBytes(this.out, chunk.content().readableBytes());
        if (chunk instanceof LastHttpContent) {
            try {
                this.releaseDfsResourcesAndThrow();
                this.response.headers().set("Connection", (Object)"close");
                ctx.write(this.response).addListener(ChannelFutureListener.CLOSE);
            }
            catch (Exception cause) {
                this.exceptionCaught(ctx, cause);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.releaseDfsResources();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.releaseDfsResources();
        DefaultFullHttpResponse resp = ExceptionHandler.exceptionCaught(cause);
        resp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush(resp).addListener(ChannelFutureListener.CLOSE);
        if (LOG != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Exception in channel handler ", cause);
        }
    }

    private void releaseDfsResources() {
        IOUtils.cleanup(LOG, this.out);
        IOUtils.cleanup(LOG, this.client);
    }

    private void releaseDfsResourcesAndThrow() throws Exception {
        this.out.close();
        this.client.close();
    }
}

