/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import org.apache.commons.logging.Log;
import org.apache.flink.hadoop.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.flink.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.hadoop.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.hadoop.shaded.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.hadoop.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;

@InterfaceAudience.Private
final class RestCsrfPreventionFilterHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Log LOG = DatanodeHttpServer.LOG;
    private final RestCsrfPreventionFilter restCsrfPreventionFilter;

    public RestCsrfPreventionFilterHandler(RestCsrfPreventionFilter restCsrfPreventionFilter) {
        this.restCsrfPreventionFilter = restCsrfPreventionFilter;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        this.restCsrfPreventionFilter.handleHttpInteraction(new NettyHttpInteraction(ctx, req));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error((Object)("Exception in " + this.getClass().getSimpleName()), cause);
        RestCsrfPreventionFilterHandler.sendResponseAndClose(ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
    }

    private static void sendResponseAndClose(ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        resp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush(resp).addListener(ChannelFutureListener.CLOSE);
    }

    private static final class NettyHttpInteraction
    implements RestCsrfPreventionFilter.HttpInteraction {
        private final ChannelHandlerContext ctx;
        private final HttpRequest req;

        public NettyHttpInteraction(ChannelHandlerContext ctx, HttpRequest req) {
            this.ctx = ctx;
            this.req = req;
        }

        @Override
        public String getHeader(String header) {
            return this.req.headers().get(header);
        }

        @Override
        public String getMethod() {
            return this.req.getMethod().name();
        }

        @Override
        public void proceed() {
            ReferenceCountUtil.retain(this.req);
            this.ctx.fireChannelRead(this.req);
        }

        @Override
        public void sendError(int code, String message) {
            HttpResponseStatus status = new HttpResponseStatus(code, message);
            RestCsrfPreventionFilterHandler.sendResponseAndClose(this.ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, status));
        }
    }
}

