/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.hadoop.shaded.com.google.common.base.Function;
import org.apache.flink.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hadoop.shaded.com.google.common.collect.HashMultimap;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Iterators;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Multimap;
import org.apache.flink.hadoop.shaded.com.google.common.collect.UnmodifiableIterator;

public class HostSet
implements Iterable<InetSocketAddress> {
    private final Multimap<InetAddress, Integer> addrs = HashMultimap.create();

    boolean matchedBy(InetSocketAddress addr) {
        Collection<Integer> ports = this.addrs.get(addr.getAddress());
        return addr.getPort() == 0 ? !ports.isEmpty() : ports.contains(addr.getPort());
    }

    boolean match(InetSocketAddress addr) {
        int port = addr.getPort();
        Collection<Integer> ports = this.addrs.get(addr.getAddress());
        boolean exactMatch = ports.contains(port);
        boolean genericMatch = ports.contains(0);
        return exactMatch || genericMatch;
    }

    boolean isEmpty() {
        return this.addrs.isEmpty();
    }

    int size() {
        return this.addrs.size();
    }

    void add(InetSocketAddress addr) {
        Preconditions.checkArgument(!addr.isUnresolved());
        this.addrs.put(addr.getAddress(), addr.getPort());
    }

    @Override
    public Iterator<InetSocketAddress> iterator() {
        return new UnmodifiableIterator<InetSocketAddress>(){
            private final Iterator<Map.Entry<InetAddress, Integer>> it;
            {
                this.it = HostSet.this.addrs.entries().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public InetSocketAddress next() {
                Map.Entry<InetAddress, Integer> e = this.it.next();
                return new InetSocketAddress(e.getKey(), (int)e.getValue());
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HostSet(");
        Joiner.on(",").appendTo(sb, Iterators.transform(this.iterator(), new Function<InetSocketAddress, String>(){

            @Override
            public String apply(@Nullable InetSocketAddress addr) {
                assert (addr != null);
                return addr.getAddress().getHostAddress() + ":" + addr.getPort();
            }
        }));
        return sb.append(")").toString();
    }
}

