/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import org.apache.flink.hadoop.shaded.com.google.protobuf.RpcController;
import org.apache.flink.hadoop.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;

public class NamenodeProtocolServerSideTranslatorPB
implements NamenodeProtocolPB {
    private final NamenodeProtocol impl;
    private static final NamenodeProtocolProtos.ErrorReportResponseProto VOID_ERROR_REPORT_RESPONSE = NamenodeProtocolProtos.ErrorReportResponseProto.newBuilder().build();
    private static final NamenodeProtocolProtos.EndCheckpointResponseProto VOID_END_CHECKPOINT_RESPONSE = NamenodeProtocolProtos.EndCheckpointResponseProto.newBuilder().build();

    public NamenodeProtocolServerSideTranslatorPB(NamenodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public NamenodeProtocolProtos.GetBlocksResponseProto getBlocks(RpcController unused, NamenodeProtocolProtos.GetBlocksRequestProto request) throws ServiceException {
        BlocksWithLocations blocks;
        DatanodeInfo dnInfo = new DatanodeInfo(PBHelperClient.convert(request.getDatanode()));
        try {
            blocks = this.impl.getBlocks(dnInfo, request.getSize());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.GetBlocksResponseProto.newBuilder().setBlocks(PBHelper.convert(blocks)).build();
    }

    @Override
    public NamenodeProtocolProtos.GetBlockKeysResponseProto getBlockKeys(RpcController unused, NamenodeProtocolProtos.GetBlockKeysRequestProto request) throws ServiceException {
        ExportedBlockKeys keys;
        try {
            keys = this.impl.getBlockKeys();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        NamenodeProtocolProtos.GetBlockKeysResponseProto.Builder builder = NamenodeProtocolProtos.GetBlockKeysResponseProto.newBuilder();
        if (keys != null) {
            builder.setKeys(PBHelper.convert(keys));
        }
        return builder.build();
    }

    @Override
    public NamenodeProtocolProtos.GetTransactionIdResponseProto getTransactionId(RpcController unused, NamenodeProtocolProtos.GetTransactionIdRequestProto request) throws ServiceException {
        long txid;
        try {
            txid = this.impl.getTransactionID();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.GetTransactionIdResponseProto.newBuilder().setTxId(txid).build();
    }

    @Override
    public NamenodeProtocolProtos.GetMostRecentCheckpointTxIdResponseProto getMostRecentCheckpointTxId(RpcController unused, NamenodeProtocolProtos.GetMostRecentCheckpointTxIdRequestProto request) throws ServiceException {
        long txid;
        try {
            txid = this.impl.getMostRecentCheckpointTxId();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.GetMostRecentCheckpointTxIdResponseProto.newBuilder().setTxId(txid).build();
    }

    @Override
    public NamenodeProtocolProtos.RollEditLogResponseProto rollEditLog(RpcController unused, NamenodeProtocolProtos.RollEditLogRequestProto request) throws ServiceException {
        CheckpointSignature signature;
        try {
            signature = this.impl.rollEditLog();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.RollEditLogResponseProto.newBuilder().setSignature(PBHelper.convert(signature)).build();
    }

    @Override
    public NamenodeProtocolProtos.ErrorReportResponseProto errorReport(RpcController unused, NamenodeProtocolProtos.ErrorReportRequestProto request) throws ServiceException {
        try {
            this.impl.errorReport(PBHelper.convert(request.getRegistration()), request.getErrorCode(), request.getMsg());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return VOID_ERROR_REPORT_RESPONSE;
    }

    @Override
    public NamenodeProtocolProtos.RegisterResponseProto registerSubordinateNamenode(RpcController unused, NamenodeProtocolProtos.RegisterRequestProto request) throws ServiceException {
        NamenodeRegistration reg;
        try {
            reg = this.impl.registerSubordinateNamenode(PBHelper.convert(request.getRegistration()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.RegisterResponseProto.newBuilder().setRegistration(PBHelper.convert(reg)).build();
    }

    @Override
    public NamenodeProtocolProtos.StartCheckpointResponseProto startCheckpoint(RpcController unused, NamenodeProtocolProtos.StartCheckpointRequestProto request) throws ServiceException {
        NamenodeCommand cmd;
        try {
            cmd = this.impl.startCheckpoint(PBHelper.convert(request.getRegistration()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.StartCheckpointResponseProto.newBuilder().setCommand(PBHelper.convert(cmd)).build();
    }

    @Override
    public NamenodeProtocolProtos.EndCheckpointResponseProto endCheckpoint(RpcController unused, NamenodeProtocolProtos.EndCheckpointRequestProto request) throws ServiceException {
        try {
            this.impl.endCheckpoint(PBHelper.convert(request.getRegistration()), PBHelper.convert(request.getSignature()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return VOID_END_CHECKPOINT_RESPONSE;
    }

    @Override
    public NamenodeProtocolProtos.GetEditLogManifestResponseProto getEditLogManifest(RpcController unused, NamenodeProtocolProtos.GetEditLogManifestRequestProto request) throws ServiceException {
        RemoteEditLogManifest manifest;
        try {
            manifest = this.impl.getEditLogManifest(request.getSinceTxId());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.GetEditLogManifestResponseProto.newBuilder().setManifest(PBHelper.convert(manifest)).build();
    }

    @Override
    public HdfsServerProtos.VersionResponseProto versionRequest(RpcController controller, HdfsServerProtos.VersionRequestProto request) throws ServiceException {
        NamespaceInfo info;
        try {
            info = this.impl.versionRequest();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return HdfsServerProtos.VersionResponseProto.newBuilder().setInfo(PBHelper.convert(info)).build();
    }

    @Override
    public NamenodeProtocolProtos.IsUpgradeFinalizedResponseProto isUpgradeFinalized(RpcController controller, NamenodeProtocolProtos.IsUpgradeFinalizedRequestProto request) throws ServiceException {
        boolean isUpgradeFinalized;
        try {
            isUpgradeFinalized = this.impl.isUpgradeFinalized();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return NamenodeProtocolProtos.IsUpgradeFinalizedResponseProto.newBuilder().setIsUpgradeFinalized(isUpgradeFinalized).build();
    }
}

