/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OpenFilesIterator
extends BatchedRemoteIterator<Long, OpenFileEntry> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public OpenFilesIterator(ClientProtocol namenode, Tracer tracer) {
        super(0L);
        this.namenode = namenode;
        this.tracer = tracer;
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> makeRequest(Long prevId) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listOpenFiles");){
            BatchedRemoteIterator.BatchedEntries<OpenFileEntry> batchedEntries = this.namenode.listOpenFiles(prevId);
            return batchedEntries;
        }
    }

    @Override
    public Long elementToPrevKey(OpenFileEntry entry) {
        return entry.getId();
    }
}

