/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.WindowsBasedProcessTree;

@InterfaceAudience.Private
public class WindowsResourceCalculatorPlugin
extends ResourceCalculatorPlugin {
    static final Log LOG = LogFactory.getLog(WindowsResourceCalculatorPlugin.class);
    long vmemSize;
    long memSize;
    long vmemAvailable;
    long memAvailable;
    int numProcessors;
    long cpuFrequencyKhz;
    long cumulativeCpuTimeMs;
    float cpuUsage;
    long lastRefreshTime = 0L;
    private final int refreshIntervalMs = 1000;
    WindowsBasedProcessTree pTree = null;

    public WindowsResourceCalculatorPlugin() {
        this.reset();
    }

    void reset() {
        this.vmemSize = -1L;
        this.memSize = -1L;
        this.vmemAvailable = -1L;
        this.memAvailable = -1L;
        this.numProcessors = -1;
        this.cpuFrequencyKhz = -1L;
        this.cumulativeCpuTimeMs = -1L;
        this.cpuUsage = -1.0f;
    }

    String getSystemInfoInfoFromShell() {
        Shell.ShellCommandExecutor shellExecutor = new Shell.ShellCommandExecutor(new String[]{Shell.WINUTILS, "systeminfo"});
        try {
            shellExecutor.execute();
            return shellExecutor.getOutput();
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            return null;
        }
    }

    void refreshIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - this.lastRefreshTime > 1000L) {
            long refreshInterval = now - this.lastRefreshTime;
            this.lastRefreshTime = now;
            long lastCumCpuTimeMs = this.cumulativeCpuTimeMs;
            this.reset();
            String sysInfoStr = this.getSystemInfoInfoFromShell();
            if (sysInfoStr != null) {
                int sysInfoSplitCount = 7;
                String[] sysInfo = sysInfoStr.substring(0, sysInfoStr.indexOf("\r\n")).split(",");
                if (sysInfo.length == 7) {
                    try {
                        this.vmemSize = Long.parseLong(sysInfo[0]);
                        this.memSize = Long.parseLong(sysInfo[1]);
                        this.vmemAvailable = Long.parseLong(sysInfo[2]);
                        this.memAvailable = Long.parseLong(sysInfo[3]);
                        this.numProcessors = Integer.parseInt(sysInfo[4]);
                        this.cpuFrequencyKhz = Long.parseLong(sysInfo[5]);
                        this.cumulativeCpuTimeMs = Long.parseLong(sysInfo[6]);
                        if (lastCumCpuTimeMs != -1L) {
                            this.cpuUsage = (float)(this.cumulativeCpuTimeMs - lastCumCpuTimeMs) / ((float)refreshInterval * 1.0f);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn((Object)("Error parsing sysInfo." + nfe));
                    }
                } else {
                    LOG.warn((Object)("Expected split length of sysInfo to be 7. Got " + sysInfo.length));
                }
            }
        }
    }

    @Override
    public long getVirtualMemorySize() {
        this.refreshIfNeeded();
        return this.vmemSize;
    }

    @Override
    public long getPhysicalMemorySize() {
        this.refreshIfNeeded();
        return this.memSize;
    }

    @Override
    public long getAvailableVirtualMemorySize() {
        this.refreshIfNeeded();
        return this.vmemAvailable;
    }

    @Override
    public long getAvailablePhysicalMemorySize() {
        this.refreshIfNeeded();
        return this.memAvailable;
    }

    @Override
    public int getNumProcessors() {
        this.refreshIfNeeded();
        return this.numProcessors;
    }

    @Override
    public long getCpuFrequency() {
        this.refreshIfNeeded();
        return -1L;
    }

    @Override
    public long getCumulativeCpuTime() {
        this.refreshIfNeeded();
        return this.cumulativeCpuTimeMs;
    }

    @Override
    public float getCpuUsage() {
        this.refreshIfNeeded();
        return this.cpuUsage;
    }
}

