/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.client.NMProxy;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class ContainerManagementProtocolProxy {
    static final Log LOG = LogFactory.getLog(ContainerManagementProtocolProxy.class);
    private final int maxConnectedNMs;
    private final Map<String, ContainerManagementProtocolProxyData> cmProxy;
    private final Configuration conf;
    private final YarnRPC rpc;
    private NMTokenCache nmTokenCache;

    public ContainerManagementProtocolProxy(Configuration conf) {
        this(conf, NMTokenCache.getSingleton());
    }

    public ContainerManagementProtocolProxy(Configuration conf, NMTokenCache nmTokenCache) {
        this.conf = new Configuration(conf);
        this.nmTokenCache = nmTokenCache;
        this.maxConnectedNMs = conf.getInt("yarn.client.max-cached-nodemanagers-proxies", 0);
        if (this.maxConnectedNMs < 0) {
            throw new YarnRuntimeException("yarn.client.max-cached-nodemanagers-proxies (" + this.maxConnectedNMs + ") can not be less than 0.");
        }
        LOG.info((Object)("yarn.client.max-cached-nodemanagers-proxies : " + this.maxConnectedNMs));
        if (this.maxConnectedNMs > 0) {
            this.cmProxy = new LinkedHashMap<String, ContainerManagementProtocolProxyData>();
        } else {
            this.cmProxy = Collections.emptyMap();
            this.conf.setInt("ipc.client.connection.maxidletime", 0);
        }
        this.rpc = YarnRPC.create(conf);
    }

    public synchronized ContainerManagementProtocolProxyData getProxy(String containerManagerBindAddr, ContainerId containerId) throws SecretManager.InvalidToken {
        ContainerManagementProtocolProxyData proxy = this.cmProxy.get(containerManagerBindAddr);
        while (proxy != null && !proxy.token.getIdentifier().equals(this.nmTokenCache.getToken(containerManagerBindAddr).getIdentifier())) {
            LOG.info((Object)("Refreshing proxy as NMToken got updated for node : " + containerManagerBindAddr));
            if (!proxy.scheduledForClose) {
                this.removeProxy(proxy);
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (proxy.activeCallers >= 0) continue;
            proxy = this.cmProxy.get(containerManagerBindAddr);
        }
        if (proxy == null) {
            proxy = new ContainerManagementProtocolProxyData(this.rpc, containerManagerBindAddr, containerId, this.nmTokenCache.getToken(containerManagerBindAddr));
            if (this.maxConnectedNMs > 0) {
                this.addProxyToCache(containerManagerBindAddr, proxy);
            }
        }
        proxy.activeCallers++;
        this.updateLRUCache(containerManagerBindAddr);
        return proxy;
    }

    private void addProxyToCache(String containerManagerBindAddr, ContainerManagementProtocolProxyData proxy) {
        while (this.cmProxy.size() >= this.maxConnectedNMs) {
            ContainerManagementProtocolProxyData otherProxy;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cleaning up the proxy cache, size=" + this.cmProxy.size() + " max=" + this.maxConnectedNMs));
            }
            boolean removedProxy = false;
            Iterator<ContainerManagementProtocolProxyData> iterator = this.cmProxy.values().iterator();
            while (iterator.hasNext() && !(removedProxy = this.removeProxy(otherProxy = iterator.next()))) {
            }
            if (removedProxy) continue;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.maxConnectedNMs > 0) {
            this.cmProxy.put(containerManagerBindAddr, proxy);
        }
    }

    private void updateLRUCache(String containerManagerBindAddr) {
        if (this.maxConnectedNMs > 0) {
            ContainerManagementProtocolProxyData proxy = this.cmProxy.remove(containerManagerBindAddr);
            this.cmProxy.put(containerManagerBindAddr, proxy);
        }
    }

    public synchronized void mayBeCloseProxy(ContainerManagementProtocolProxyData proxy) {
        this.tryCloseProxy(proxy);
    }

    private boolean tryCloseProxy(ContainerManagementProtocolProxyData proxy) {
        proxy.activeCallers--;
        if (proxy.scheduledForClose && proxy.activeCallers < 0) {
            LOG.info((Object)("Closing proxy : " + proxy.containerManagerBindAddr));
            this.cmProxy.remove(proxy.containerManagerBindAddr);
            try {
                this.rpc.stopProxy(proxy.getContainerManagementProtocol(), this.conf);
            }
            finally {
                this.notifyAll();
            }
            return true;
        }
        return false;
    }

    private synchronized boolean removeProxy(ContainerManagementProtocolProxyData proxy) {
        if (!proxy.scheduledForClose) {
            proxy.scheduledForClose = true;
            return this.tryCloseProxy(proxy);
        }
        return false;
    }

    public synchronized void stopAllProxies() {
        ArrayList<String> nodeIds = new ArrayList<String>();
        nodeIds.addAll(this.cmProxy.keySet());
        for (String nodeId : nodeIds) {
            ContainerManagementProtocolProxyData proxy = this.cmProxy.get(nodeId);
            proxy.activeCallers = 0;
            try {
                this.removeProxy(proxy);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error closing connection", t);
            }
        }
        this.cmProxy.clear();
    }

    public class ContainerManagementProtocolProxyData {
        private final String containerManagerBindAddr;
        private final ContainerManagementProtocol proxy;
        private int activeCallers;
        private boolean scheduledForClose;
        private final org.apache.hadoop.yarn.api.records.Token token;

        @InterfaceAudience.Private
        @VisibleForTesting
        public ContainerManagementProtocolProxyData(YarnRPC rpc, String containerManagerBindAddr, ContainerId containerId, org.apache.hadoop.yarn.api.records.Token token) throws SecretManager.InvalidToken {
            this.containerManagerBindAddr = containerManagerBindAddr;
            this.activeCallers = 0;
            this.scheduledForClose = false;
            this.token = token;
            this.proxy = this.newProxy(rpc, containerManagerBindAddr, containerId, token);
        }

        @InterfaceAudience.Private
        @VisibleForTesting
        protected ContainerManagementProtocol newProxy(YarnRPC rpc, String containerManagerBindAddr, ContainerId containerId, org.apache.hadoop.yarn.api.records.Token token) throws SecretManager.InvalidToken {
            if (token == null) {
                throw new SecretManager.InvalidToken("No NMToken sent for " + containerManagerBindAddr);
            }
            InetSocketAddress cmAddr = NetUtils.createSocketAddr(containerManagerBindAddr);
            LOG.info((Object)("Opening proxy : " + containerManagerBindAddr));
            UserGroupInformation user = UserGroupInformation.createRemoteUser(containerId.getApplicationAttemptId().toString());
            Token nmToken = ConverterUtils.convertFromYarn(token, cmAddr);
            user.addToken(nmToken);
            return NMProxy.createNMProxy(ContainerManagementProtocolProxy.this.conf, ContainerManagementProtocol.class, user, rpc, cmAddr);
        }

        public ContainerManagementProtocol getContainerManagementProtocol() {
            return this.proxy;
        }
    }
}

