/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RMProxy<T> {
    private static final Log LOG = LogFactory.getLog(RMProxy.class);

    protected RMProxy() {
    }

    @InterfaceAudience.Private
    protected void checkAllowedProtocols(Class<?> protocol) {
    }

    @InterfaceAudience.Private
    protected InetSocketAddress getRMAddress(YarnConfiguration conf, Class<?> protocol) throws IOException {
        throw new UnsupportedOperationException("This method should be invoked from an instance of ClientRMProxy or ServerRMProxy");
    }

    @InterfaceAudience.Private
    protected static <T> T createRMProxy(Configuration configuration, Class<T> protocol, RMProxy instance) throws IOException {
        YarnConfiguration conf = configuration instanceof YarnConfiguration ? (YarnConfiguration)configuration : new YarnConfiguration(configuration);
        RetryPolicy retryPolicy = RMProxy.createRetryPolicy(conf);
        if (HAUtil.isHAEnabled(conf)) {
            RMFailoverProxyProvider<T> provider = instance.createRMFailoverProxyProvider(conf, protocol);
            return (T)RetryProxy.create(protocol, provider, retryPolicy);
        }
        InetSocketAddress rmAddress = instance.getRMAddress(conf, protocol);
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        T proxy = RMProxy.getProxy(conf, protocol, rmAddress);
        return (T)RetryProxy.create(protocol, proxy, retryPolicy);
    }

    @Deprecated
    public static <T> T createRMProxy(Configuration conf, Class<T> protocol, InetSocketAddress rmAddress) throws IOException {
        RetryPolicy retryPolicy = RMProxy.createRetryPolicy(conf);
        T proxy = RMProxy.getProxy(conf, protocol, rmAddress);
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        return (T)RetryProxy.create(protocol, proxy, retryPolicy);
    }

    @InterfaceAudience.Private
    static <T> T getProxy(final Configuration conf, final Class<T> protocol, final InetSocketAddress rmAddress) throws IOException {
        return UserGroupInformation.getCurrentUser().doAs(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return YarnRPC.create(conf).getProxy(protocol, rmAddress, conf);
            }
        });
    }

    private <T> RMFailoverProxyProvider<T> createRMFailoverProxyProvider(Configuration conf, Class<T> protocol) {
        Class<?> defaultProviderClass;
        try {
            defaultProviderClass = Class.forName("org.apache.hadoop.yarn.client.ConfiguredRMFailoverProxyProvider");
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Invalid default failover provider classorg.apache.hadoop.yarn.client.ConfiguredRMFailoverProxyProvider", e);
        }
        RMFailoverProxyProvider provider = ReflectionUtils.newInstance(conf.getClass("yarn.client.failover-proxy-provider", defaultProviderClass, RMFailoverProxyProvider.class), conf);
        provider.init(conf, this, protocol);
        return provider;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static RetryPolicy createRetryPolicy(Configuration conf) {
        boolean waitForEver;
        long rmConnectWaitMS = conf.getLong("yarn.resourcemanager.connect.max-wait.ms", 900000L);
        long rmConnectionRetryIntervalMS = conf.getLong("yarn.resourcemanager.connect.retry-interval.ms", 30000L);
        boolean bl = waitForEver = rmConnectWaitMS == -1L;
        if (!waitForEver) {
            if (rmConnectWaitMS < 0L) {
                throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.connect.max-wait.ms can be -1, but can not be other negative numbers");
            }
            if (rmConnectWaitMS < rmConnectionRetryIntervalMS) {
                LOG.warn((Object)"yarn.resourcemanager.connect.max-wait.ms is smaller than yarn.resourcemanager.connect.retry-interval.ms. Only try connect once.");
                rmConnectWaitMS = 0L;
            }
        }
        if (HAUtil.isHAEnabled(conf)) {
            long failoverSleepBaseMs = conf.getLong("yarn.client.failover-sleep-base-ms", rmConnectionRetryIntervalMS);
            long failoverSleepMaxMs = conf.getLong("yarn.client.failover-sleep-max-ms", rmConnectionRetryIntervalMS);
            int maxFailoverAttempts = conf.getInt("yarn.client.failover-max-attempts", -1);
            if (maxFailoverAttempts == -1) {
                maxFailoverAttempts = waitForEver ? Integer.MAX_VALUE : (int)(rmConnectWaitMS / failoverSleepBaseMs);
            }
            return RetryPolicies.failoverOnNetworkException(RetryPolicies.TRY_ONCE_THEN_FAIL, maxFailoverAttempts, failoverSleepBaseMs, failoverSleepMaxMs);
        }
        if (rmConnectionRetryIntervalMS < 0L) {
            throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.connect.retry-interval.ms should not be negative.");
        }
        RetryPolicy retryPolicy = null;
        retryPolicy = waitForEver ? RetryPolicies.RETRY_FOREVER : RetryPolicies.retryUpToMaximumTimeWithFixedSleep(rmConnectWaitMS, rmConnectionRetryIntervalMS, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(EOFException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectException.class, retryPolicy);
        exceptionToPolicyMap.put(NoRouteToHostException.class, retryPolicy);
        exceptionToPolicyMap.put(UnknownHostException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectTimeoutException.class, retryPolicy);
        exceptionToPolicyMap.put(RetriableException.class, retryPolicy);
        exceptionToPolicyMap.put(SocketException.class, retryPolicy);
        exceptionToPolicyMap.put(IOException.class, retryPolicy);
        return RetryPolicies.retryOtherThanRemoteException(RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
    }
}

