/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.flink.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.alias.CredentialProvider;

@InterfaceAudience.Private
public abstract class AbstractJavaKeyStoreProvider
extends CredentialProvider {
    public static final String CREDENTIAL_PASSWORD_NAME = "HADOOP_CREDSTORE_PASSWORD";
    public static final String KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.credstore.java-keystore-provider.password-file";
    public static final String KEYSTORE_PASSWORD_DEFAULT = "none";
    private Path path;
    private final URI uri;
    private final KeyStore keyStore;
    private char[] password;
    private boolean changed;
    private Lock readLock;
    private Lock writeLock;
    private final Map<String, CredentialProvider.CredentialEntry> cache;

    protected AbstractJavaKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        block33: {
            ClassLoader cl;
            URL pwdFile;
            String pwFile;
            this.password = null;
            this.changed = false;
            this.cache = new HashMap<String, CredentialProvider.CredentialEntry>();
            this.uri = uri;
            this.initFileSystem(uri, conf);
            if (System.getenv().containsKey(CREDENTIAL_PASSWORD_NAME)) {
                this.password = System.getenv(CREDENTIAL_PASSWORD_NAME).toCharArray();
            }
            if (this.password == null && (pwFile = conf.get(KEYSTORE_PASSWORD_FILE_KEY)) != null && (pwdFile = (cl = Thread.currentThread().getContextClassLoader()).getResource(pwFile)) != null) {
                try (InputStream is = pwdFile.openStream();){
                    this.password = IOUtils.toString((InputStream)is).trim().toCharArray();
                }
            }
            if (this.password == null) {
                this.password = KEYSTORE_PASSWORD_DEFAULT.toCharArray();
            }
            try {
                this.keyStore = KeyStore.getInstance("jceks");
                if (this.keystoreExists()) {
                    this.stashOriginalFilePermissions();
                    try (InputStream in = this.getInputStreamForFile();){
                        this.keyStore.load(in, this.password);
                        break block33;
                    }
                }
                this.createPermissions("700");
                this.keyStore.load(null, this.password);
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't create keystore", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Can't load keystore " + this.getPathAsString(), e);
            }
            catch (CertificateException e) {
                throw new IOException("Can't load keystore " + this.getPathAsString(), e);
            }
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path p) {
        this.path = p;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] pass) {
        this.password = pass;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean chg) {
        this.changed = chg;
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public void setReadLock(Lock rl) {
        this.readLock = rl;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    public void setWriteLock(Lock wl) {
        this.writeLock = wl;
    }

    public URI getUri() {
        return this.uri;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public Map<String, CredentialProvider.CredentialEntry> getCache() {
        return this.cache;
    }

    protected final String getPathAsString() {
        return this.getPath().toString();
    }

    protected abstract String getSchemeName();

    protected abstract OutputStream getOutputStreamForKeystore() throws IOException;

    protected abstract boolean keystoreExists() throws IOException;

    protected abstract InputStream getInputStreamForFile() throws IOException;

    protected abstract void createPermissions(String var1) throws IOException;

    protected abstract void stashOriginalFilePermissions() throws IOException;

    protected void initFileSystem(URI keystoreUri, Configuration conf) throws IOException {
        this.path = ProviderUtils.unnestUri(keystoreUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialProvider.CredentialEntry getCredentialEntry(String alias) throws IOException {
        this.readLock.lock();
        try {
            SecretKeySpec key;
            block11: {
                key = null;
                if (!this.cache.containsKey(alias)) break block11;
                CredentialProvider.CredentialEntry credentialEntry = this.cache.get(alias);
                return credentialEntry;
            }
            if (!this.keyStore.containsAlias(alias)) {
                CredentialProvider.CredentialEntry credentialEntry = null;
                return credentialEntry;
            }
            try {
                key = (SecretKeySpec)this.keyStore.getKey(alias, this.password);
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't get credential " + alias + " from " + this.getPathAsString(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Can't get algorithm for credential " + alias + " from " + this.getPathAsString(), e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IOException("Can't recover credential " + alias + " from " + this.getPathAsString(), e);
            }
            CredentialProvider.CredentialEntry credentialEntry = new CredentialProvider.CredentialEntry(alias, AbstractJavaKeyStoreProvider.bytesToChars(key.getEncoded()));
            return credentialEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static char[] bytesToChars(byte[] bytes) throws IOException {
        String pass = new String(bytes, Charsets.UTF_8);
        return pass.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAliases() throws IOException {
        this.readLock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>();
            String alias = null;
            try {
                Enumeration<String> e = this.keyStore.aliases();
                while (e.hasMoreElements()) {
                    alias = e.nextElement();
                    list.add(alias);
                }
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't get alias " + alias + " from " + this.getPathAsString(), e);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public CredentialProvider.CredentialEntry createCredentialEntry(String alias, char[] credential) throws IOException {
        this.writeLock.lock();
        try {
            if (this.keyStore.containsAlias(alias) || this.cache.containsKey(alias)) {
                throw new IOException("Credential " + alias + " already exists in " + this);
            }
            CredentialProvider.CredentialEntry credentialEntry = this.innerSetCredential(alias, credential);
            return credentialEntry;
        }
        catch (KeyStoreException e) {
            throw new IOException("Problem looking up credential " + alias + " in " + this, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void deleteCredentialEntry(String name) throws IOException {
        this.writeLock.lock();
        try {
            try {
                if (!this.keyStore.containsAlias(name)) {
                    throw new IOException("Credential " + name + " does not exist in " + this);
                }
                this.keyStore.deleteEntry(name);
            }
            catch (KeyStoreException e) {
                throw new IOException("Problem removing " + name + " from " + this, e);
            }
            this.cache.remove(name);
            this.changed = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    CredentialProvider.CredentialEntry innerSetCredential(String alias, char[] material) throws IOException {
        this.writeLock.lock();
        try {
            this.keyStore.setKeyEntry(alias, new SecretKeySpec(new String(material).getBytes("UTF-8"), "AES"), this.password, null);
        }
        catch (KeyStoreException e) {
            throw new IOException("Can't store credential " + alias + " in " + this, e);
        }
        finally {
            this.writeLock.unlock();
        }
        this.changed = true;
        return new CredentialProvider.CredentialEntry(alias, material);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.writeLock.lock();
        try {
            if (!this.changed) {
                return;
            }
            try (OutputStream out = this.getOutputStreamForKeystore();){
                this.keyStore.store(out, this.password);
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't store keystore " + this, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("No such algorithm storing keystore " + this, e);
            }
            catch (CertificateException e) {
                throw new IOException("Certificate exception storing keystore " + this, e);
            }
            this.changed = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

