/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.hdfs.web.ByteRangeInputStream;
import org.apache.hadoop.hdfs.web.TokenAspect;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ServletUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HftpFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable,
TokenAspect.TokenManagementDelegator {
    public static final String SCHEME = "hftp";
    URLConnectionFactory connectionFactory;
    public static final Text TOKEN_KIND;
    protected UserGroupInformation ugi;
    private URI hftpURI;
    protected URI nnUri;
    public static final String HFTP_TIMEZONE = "UTC";
    public static final String HFTP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    protected TokenAspect<? extends HftpFileSystem> tokenAspect;
    private Token<?> delegationToken;
    private Token<?> renewToken;
    protected Text tokenServiceName;
    protected static final ThreadLocal<SimpleDateFormat> df;

    @Override
    public URI getCanonicalUri() {
        return super.getCanonicalUri();
    }

    public static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(HFTP_DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone(HFTP_TIMEZONE));
        return df;
    }

    @Override
    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    protected InetSocketAddress getNamenodeAddr(URI uri) {
        return NetUtils.createSocketAddr(uri.getAuthority(), this.getDefaultPort());
    }

    protected URI getNamenodeUri(URI uri) {
        return DFSUtil.createUri(this.getUnderlyingProtocol(), this.getNamenodeAddr(uri));
    }

    @Override
    public String getCanonicalServiceName() {
        return SecurityUtil.buildTokenService(this.nnUri).toString();
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        return NetUtils.getCanonicalUri(uri, this.getDefaultPort());
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    protected void initTokenAspect() {
        this.tokenAspect = new TokenAspect<HftpFileSystem>(this, this.tokenServiceName, TOKEN_KIND);
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.nnUri = this.getNamenodeUri(name);
        this.tokenServiceName = SecurityUtil.buildTokenService(this.nnUri);
        try {
            this.hftpURI = new URI(name.getScheme(), name.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.initTokenAspect();
        if (UserGroupInformation.isSecurityEnabled()) {
            this.tokenAspect.initDelegationToken(this.ugi);
        }
    }

    @Override
    public Token<?> getRenewToken() {
        return this.renewToken;
    }

    protected String getUnderlyingProtocol() {
        return "http";
    }

    @Override
    public synchronized <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        this.renewToken = token;
        this.delegationToken = new Token<T>(token);
        this.delegationToken.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }

    @Override
    public synchronized Token<?> getDelegationToken(final String renewer) throws IOException {
        try {
            String proxyUser;
            UserGroupInformation connectUgi = this.ugi.getRealUser();
            String string = proxyUser = connectUgi == null ? null : this.ugi.getShortUserName();
            if (connectUgi == null) {
                connectUgi = this.ugi;
            }
            return (Token)connectUgi.doAs(new PrivilegedExceptionAction<Token<?>>(){

                @Override
                public Token<?> run() throws IOException {
                    Credentials c;
                    try {
                        c = DelegationTokenFetcher.getDTfromRemote(HftpFileSystem.this.connectionFactory, HftpFileSystem.this.nnUri, renewer, proxyUser);
                    }
                    catch (IOException e) {
                        if (e.getCause() instanceof ConnectException) {
                            FileSystem.LOG.warn((Object)("Couldn't connect to " + HftpFileSystem.this.nnUri + ", assuming security is disabled"));
                            return null;
                        }
                        if (FileSystem.LOG.isDebugEnabled()) {
                            FileSystem.LOG.debug((Object)"Exception getting delegation token", (Throwable)e);
                        }
                        throw e;
                    }
                    Iterator<Token<? extends TokenIdentifier>> iterator = c.getAllTokens().iterator();
                    if (iterator.hasNext()) {
                        Token<? extends TokenIdentifier> t = iterator.next();
                        if (FileSystem.LOG.isDebugEnabled()) {
                            FileSystem.LOG.debug((Object)("Got dt for " + HftpFileSystem.this.getUri() + ";t.service=" + t.getService()));
                        }
                        return t;
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI getUri() {
        return this.hftpURI;
    }

    protected URL getNamenodeURL(String path, String query) throws IOException {
        URL url = new URL(this.getUnderlyingProtocol(), this.nnUri.getHost(), this.nnUri.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    private String getEncodedUgiParameter() {
        StringBuilder ugiParameter = new StringBuilder(ServletUtil.encodeQueryValue(this.ugi.getShortUserName()));
        for (String g : this.ugi.getGroupNames()) {
            ugiParameter.append(",");
            ugiParameter.append(ServletUtil.encodeQueryValue(g));
        }
        return ugiParameter.toString();
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        query = this.addDelegationTokenParam(query);
        URL url = this.getNamenodeURL(path, query);
        HttpURLConnection connection = (HttpURLConnection)this.connectionFactory.openConnection(url);
        connection.setRequestMethod("GET");
        connection.connect();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDelegationTokenParam(String query) throws IOException {
        String tokenString = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            HftpFileSystem hftpFileSystem = this;
            synchronized (hftpFileSystem) {
                this.tokenAspect.ensureTokenInitialized();
                if (this.delegationToken != null) {
                    tokenString = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam(tokenString);
                }
            }
        }
        return query;
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        f = f.makeQualified(this.getUri(), this.getWorkingDirectory());
        String path = "/data" + ServletUtil.encodePath(f.toUri().getPath());
        String query = this.addDelegationTokenParam("ugi=" + this.getEncodedUgiParameter());
        URL u = this.getNamenodeURL(path, query);
        return new FSDataInputStream(new RangeHeaderInputStream(this.connectionFactory, u));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.tokenAspect.removeRenewAction();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.listStatus(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.getFileStatus(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        return new ChecksumParser().getFileChecksum(s);
    }

    @Override
    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this.getUri(), null);
    }

    @Override
    public void setWorkingDirectory(Path f) {
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    private static ContentSummary toContentSummary(Attributes attrs) throws SAXException {
        String length = attrs.getValue("length");
        String fileCount = attrs.getValue("fileCount");
        String directoryCount = attrs.getValue("directoryCount");
        String quota = attrs.getValue("quota");
        String spaceConsumed = attrs.getValue("spaceConsumed");
        String spaceQuota = attrs.getValue("spaceQuota");
        if (length == null || fileCount == null || directoryCount == null || quota == null || spaceConsumed == null || spaceQuota == null) {
            return null;
        }
        try {
            return new ContentSummary(Long.parseLong(length), Long.parseLong(fileCount), Long.parseLong(directoryCount), Long.parseLong(quota), Long.parseLong(spaceConsumed), Long.parseLong(spaceQuota));
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: length=" + length + ", fileCount=" + fileCount + ", directoryCount=" + directoryCount + ", quota=" + quota + ", spaceConsumed=" + spaceConsumed + ", spaceQuota=" + spaceQuota, e);
        }
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        ContentSummary cs = new ContentSummaryParser().getContentSummary(s);
        return cs != null ? cs : super.getContentSummary(f);
    }

    @Override
    public long renewDelegationToken(final Token<?> token) throws IOException {
        UserGroupInformation connectUgi = this.ugi.getRealUser();
        if (connectUgi == null) {
            connectUgi = this.ugi;
        }
        try {
            return connectUgi.doAs(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    InetSocketAddress serviceAddr = SecurityUtil.getTokenServiceAddr(token);
                    return DelegationTokenFetcher.renewDelegationToken(HftpFileSystem.this.connectionFactory, DFSUtil.createUri(HftpFileSystem.this.getUnderlyingProtocol(), serviceAddr), token);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void cancelDelegationToken(final Token<?> token) throws IOException {
        UserGroupInformation connectUgi = this.ugi.getRealUser();
        if (connectUgi == null) {
            connectUgi = this.ugi;
        }
        try {
            connectUgi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    InetSocketAddress serviceAddr = SecurityUtil.getTokenServiceAddr(token);
                    DelegationTokenFetcher.cancelDelegationToken(HftpFileSystem.this.connectionFactory, DFSUtil.createUri(HftpFileSystem.this.getUnderlyingProtocol(), serviceAddr), token);
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        TOKEN_KIND = new Text("HFTP delegation");
        df = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return HftpFileSystem.getDateFormat();
            }
        };
    }

    private class ContentSummaryParser
    extends DefaultHandler {
        private ContentSummary contentsummary;

        private ContentSummaryParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!ContentSummary.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.contentsummary = HftpFileSystem.toContentSummary(attrs);
        }

        private ContentSummary getContentSummary(String path) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/contentSummary" + ServletUtil.encodePath(path), "ugi=" + HftpFileSystem.this.getEncodedUgiParameter());
            InputStream in = null;
            try {
                in = connection.getInputStream();
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(in));
            }
            catch (FileNotFoundException fnfe) {
                ContentSummary contentSummary = null;
                return contentSummary;
            }
            catch (SAXException saxe) {
                Exception embedded = saxe.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("Invalid xml format", saxe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                connection.disconnect();
            }
            return this.contentsummary;
        }
    }

    private class ChecksumParser
    extends DefaultHandler {
        private FileChecksum filechecksum;

        private ChecksumParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!MD5MD5CRC32FileChecksum.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.filechecksum = MD5MD5CRC32FileChecksum.valueOf(attrs);
        }

        private FileChecksum getFileChecksum(String f) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/fileChecksum" + ServletUtil.encodePath(f), "ugi=" + HftpFileSystem.this.getEncodedUgiParameter());
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(connection.getInputStream()));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
            finally {
                connection.disconnect();
            }
            return this.filechecksum;
        }
    }

    class LsParser
    extends DefaultHandler {
        final ArrayList<FileStatus> fslist = new ArrayList();

        LsParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            long modif;
            if ("listing".equals(qname)) {
                return;
            }
            if (!"file".equals(qname) && !"directory".equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            long atime = 0L;
            try {
                SimpleDateFormat ldf = df.get();
                modif = ldf.parse(attrs.getValue("modified")).getTime();
                String astr = attrs.getValue("accesstime");
                if (astr != null) {
                    atime = ldf.parse(astr).getTime();
                }
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            FileStatus fs = "file".equals(qname) ? new FileStatus(Long.parseLong(attrs.getValue("size")), false, Short.valueOf(attrs.getValue("replication")).shortValue(), Long.parseLong(attrs.getValue("blocksize")), modif, atime, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), HftpFileSystem.this.makeQualified(new Path(HftpFileSystem.this.getUri().toString(), ServletUtil.decodePath(attrs.getValue("path"))))) : new FileStatus(0L, true, 0, 0L, modif, atime, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), HftpFileSystem.this.makeQualified(new Path(HftpFileSystem.this.getUri().toString(), ServletUtil.decodePath(attrs.getValue("path")))));
            this.fslist.add(fs);
        }

        private void fetchList(String path, boolean recur) throws IOException {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                HttpURLConnection connection = HftpFileSystem.this.openConnection("/listPaths" + ServletUtil.encodePath(path), "ugi=" + HftpFileSystem.this.getEncodedUgiParameter() + (recur ? "&recursive=yes" : ""));
                InputStream resp = connection.getInputStream();
                xr.parse(new InputSource(resp));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            this.fetchList(f.toUri().getPath(), false);
            if (this.fslist.size() == 0) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            return this.fslist.get(0);
        }

        public FileStatus[] listStatus(Path f, boolean recur) throws IOException {
            this.fetchList(f.toUri().getPath(), recur);
            if (this.fslist.size() > 0 && (this.fslist.size() != 1 || this.fslist.get(0).isDirectory())) {
                this.fslist.remove(0);
            }
            return this.fslist.toArray(new FileStatus[0]);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.listStatus(f, false);
        }
    }

    static class RangeHeaderInputStream
    extends ByteRangeInputStream {
        RangeHeaderInputStream(RangeHeaderUrlOpener o, RangeHeaderUrlOpener r) throws IOException {
            super(o, r);
        }

        RangeHeaderInputStream(URLConnectionFactory connFactory, URL url) throws IOException {
            this(new RangeHeaderUrlOpener(connFactory, url), new RangeHeaderUrlOpener(connFactory, null));
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) {
            return connection.getURL();
        }
    }

    static class RangeHeaderUrlOpener
    extends ByteRangeInputStream.URLOpener {
        private final URLConnectionFactory connFactory;

        RangeHeaderUrlOpener(URLConnectionFactory connFactory, URL url) {
            super(url);
            this.connFactory = connFactory;
        }

        protected HttpURLConnection openConnection() throws IOException {
            return (HttpURLConnection)this.connFactory.openConnection(this.url);
        }

        @Override
        protected HttpURLConnection connect(long offset, boolean resolved) throws IOException {
            HttpURLConnection conn = this.openConnection();
            conn.setRequestMethod("GET");
            if (offset != 0L) {
                conn.setRequestProperty("Range", "bytes=" + offset + "-");
            }
            conn.connect();
            int code = conn.getResponseCode();
            if (offset != 0L && code != 206) {
                throw new IOException("HTTP_PARTIAL expected, received " + code);
            }
            if (offset == 0L && code != 200) {
                throw new IOException("HTTP_OK expected, received " + code);
            }
            return conn;
        }
    }
}

