/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

@InterfaceAudience.Private
public class DirectoryWithSnapshotFeature
implements INode.Feature {
    private final DirectoryDiffList diffs;

    private static Map<INode, INode> cloneDiffList(List<INode> diffList) {
        if (diffList == null || diffList.size() == 0) {
            return null;
        }
        HashMap<INode, INode> map = new HashMap<INode, INode>(diffList.size());
        for (INode node : diffList) {
            map.put(node, node);
        }
        return map;
    }

    public static void destroyDstSubtree(BlockStoragePolicySuite bsps, INode inode, int snapshot, int prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws QuotaExceededException {
        Preconditions.checkArgument(prior != -1);
        if (inode.isReference()) {
            if (inode instanceof INodeReference.WithName && snapshot != 0x7FFFFFFE) {
                inode.cleanSubtree(bsps, snapshot, prior, collectedBlocks, removedINodes);
            } else {
                DirectoryWithSnapshotFeature.destroyDstSubtree(bsps, inode.asReference().getReferredINode(), snapshot, prior, collectedBlocks, removedINodes);
            }
        } else if (inode.isFile()) {
            inode.cleanSubtree(bsps, snapshot, prior, collectedBlocks, removedINodes);
        } else if (inode.isDirectory()) {
            Map<INode, INode> excludedNodes = null;
            INodeDirectory dir = inode.asDirectory();
            DirectoryWithSnapshotFeature sf = dir.getDirectoryWithSnapshotFeature();
            if (sf != null) {
                DirectoryDiffList diffList = sf.getDiffs();
                DirectoryDiff priorDiff = (DirectoryDiff)diffList.getDiffById(prior);
                if (priorDiff != null && priorDiff.getSnapshotId() == prior) {
                    List<INode> dList = priorDiff.diff.getList(Diff.ListType.DELETED);
                    excludedNodes = DirectoryWithSnapshotFeature.cloneDiffList(dList);
                }
                if (snapshot != 0x7FFFFFFE) {
                    diffList.deleteSnapshotDiff(bsps, snapshot, prior, dir, collectedBlocks, removedINodes);
                }
                if ((priorDiff = (DirectoryDiff)diffList.getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                    priorDiff.diff.destroyCreatedList(bsps, dir, collectedBlocks, removedINodes);
                }
            }
            for (INode child : inode.asDirectory().getChildrenList(prior)) {
                if (excludedNodes != null && excludedNodes.containsKey(child)) continue;
                DirectoryWithSnapshotFeature.destroyDstSubtree(bsps, child, snapshot, prior, collectedBlocks, removedINodes);
            }
        }
    }

    private static QuotaCounts cleanDeletedINode(BlockStoragePolicySuite bsps, INode inode, int post, int prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        QuotaCounts counts = new QuotaCounts.Builder().build();
        ArrayDeque<INode> queue = new ArrayDeque<INode>();
        queue.addLast(inode);
        while (!queue.isEmpty()) {
            DirectoryDiff priorDiff;
            INode topNode = (INode)queue.pollFirst();
            if (topNode instanceof INodeReference.WithName) {
                INodeReference.WithName wn = (INodeReference.WithName)topNode;
                if (wn.getLastSnapshotId() < post) continue;
                INodeReference.WithCount wc = (INodeReference.WithCount)wn.getReferredINode();
                if (wc.getLastWithName() == wn && wc.getParentReference() == null) {
                    queue.add(wc.getReferredINode());
                    continue;
                }
                wn.cleanSubtree(bsps, post, prior, collectedBlocks, removedINodes);
                continue;
            }
            if (topNode.isFile() && topNode.asFile().isWithSnapshot()) {
                INodeFile file = topNode.asFile();
                counts.add(file.getDiffs().deleteSnapshotDiff(bsps, post, prior, file, collectedBlocks, removedINodes));
                continue;
            }
            if (!topNode.isDirectory()) continue;
            INodeDirectory dir = topNode.asDirectory();
            ChildrenDiff priorChildrenDiff = null;
            DirectoryWithSnapshotFeature sf = dir.getDirectoryWithSnapshotFeature();
            if (sf != null && (priorDiff = (DirectoryDiff)sf.getDiffs().getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                priorChildrenDiff = priorDiff.getChildrenDiff();
                counts.add(priorChildrenDiff.destroyCreatedList(bsps, dir, collectedBlocks, removedINodes));
            }
            for (INode child : dir.getChildrenList(prior)) {
                if (priorChildrenDiff != null && priorChildrenDiff.search(Diff.ListType.DELETED, child.getLocalNameBytes()) != null) continue;
                queue.addLast(child);
            }
        }
        return counts;
    }

    public DirectoryWithSnapshotFeature(DirectoryDiffList diffs) {
        this.diffs = diffs != null ? diffs : new DirectoryDiffList();
    }

    public int getLastSnapshotId() {
        return this.diffs.getLastSnapshotId();
    }

    public DirectoryDiffList getDiffs() {
        return this.diffs;
    }

    public void getSnapshotDirectory(List<INodeDirectory> snapshotDir) {
        for (DirectoryDiff sdiff : this.diffs) {
            sdiff.getChildrenDiff().getDirsInDeleted(snapshotDir);
        }
    }

    public boolean addChild(INodeDirectory parent, INode inode, boolean setModTime, int latestSnapshotId) throws QuotaExceededException {
        ChildrenDiff diff = ((DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latestSnapshotId, parent)).diff;
        int undoInfo = diff.create(inode);
        boolean added = parent.addChild(inode, setModTime, 0x7FFFFFFE);
        if (!added) {
            diff.undoCreate(inode, undoInfo);
        }
        return added;
    }

    public boolean removeChild(INodeDirectory parent, INode child, int latestSnapshotId) {
        ChildrenDiff diff = ((DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latestSnapshotId, parent)).diff;
        Diff.UndoInfo<INode> undoInfo = diff.delete(child);
        boolean removed = parent.removeChild(child);
        if (!removed && undoInfo != null) {
            diff.undoDelete(child, undoInfo);
        }
        return removed;
    }

    public ReadOnlyList<INode> getChildrenList(INodeDirectory currentINode, int snapshotId) {
        DirectoryDiff diff = (DirectoryDiff)this.diffs.getDiffById(snapshotId);
        return diff != null ? diff.getChildrenList(currentINode) : currentINode.getChildrenList(0x7FFFFFFE);
    }

    public INode getChild(INodeDirectory currentINode, byte[] name, int snapshotId) {
        DirectoryDiff diff = (DirectoryDiff)this.diffs.getDiffById(snapshotId);
        return diff != null ? diff.getChild(name, true, currentINode) : currentINode.getChild(name, 0x7FFFFFFE);
    }

    public INode saveChild2Snapshot(INodeDirectory currentINode, INode child, int latestSnapshotId, INode snapshotCopy) {
        Preconditions.checkArgument(!child.isDirectory(), "child is a directory, child=%s", child);
        Preconditions.checkArgument(latestSnapshotId != 0x7FFFFFFE);
        DirectoryDiff diff = (DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latestSnapshotId, currentINode);
        if (diff.getChild(child.getLocalNameBytes(), false, currentINode) != null) {
            return child;
        }
        diff.diff.modify(snapshotCopy, child);
        return child;
    }

    public void clear(BlockStoragePolicySuite bsps, INodeDirectory currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        for (DirectoryDiff diff : this.diffs) {
            diff.destroyDiffAndCollectBlocks(bsps, currentINode, collectedBlocks, removedINodes);
        }
        this.diffs.clear();
    }

    public QuotaCounts computeQuotaUsage4CurrentDirectory(BlockStoragePolicySuite bsps, byte storagePolicyId, QuotaCounts counts) {
        for (DirectoryDiff d : this.diffs) {
            for (INode deleted : d.getChildrenDiff().getList(Diff.ListType.DELETED)) {
                byte childPolicyId = deleted.getStoragePolicyIDForQuota(storagePolicyId);
                deleted.computeQuotaUsage(bsps, childPolicyId, counts, false, 0x7FFFFFFE);
            }
        }
        return counts;
    }

    public void computeContentSummary4Snapshot(BlockStoragePolicySuite bsps, ContentCounts counts) {
        ContentSummaryComputationContext summary = new ContentSummaryComputationContext(bsps);
        for (DirectoryDiff d : this.diffs) {
            for (INode deleted : d.getChildrenDiff().getList(Diff.ListType.DELETED)) {
                deleted.computeContentSummary(summary);
            }
        }
        counts.addContents(summary.getCounts());
        counts.addContent(Content.DIRECTORY, this.diffs.asList().size());
    }

    boolean computeDiffBetweenSnapshots(Snapshot fromSnapshot, Snapshot toSnapshot, ChildrenDiff diff, INodeDirectory currentINode) {
        int i;
        int[] diffIndexPair = this.diffs.changedBetweenSnapshots(fromSnapshot, toSnapshot);
        if (diffIndexPair == null) {
            return false;
        }
        int earlierDiffIndex = diffIndexPair[0];
        int laterDiffIndex = diffIndexPair[1];
        boolean dirMetadataChanged = false;
        INodeDirectoryAttributes dirCopy = null;
        List difflist = this.diffs.asList();
        for (i = earlierDiffIndex; i < laterDiffIndex; ++i) {
            DirectoryDiff sdiff = (DirectoryDiff)difflist.get(i);
            diff.combinePosterior(sdiff.diff, null);
            if (dirMetadataChanged || sdiff.snapshotINode == null) continue;
            if (dirCopy == null) {
                dirCopy = (INodeDirectoryAttributes)sdiff.snapshotINode;
                continue;
            }
            if (dirCopy.metadataEquals((INodeDirectoryAttributes)sdiff.snapshotINode)) continue;
            dirMetadataChanged = true;
        }
        if (!diff.isEmpty() || dirMetadataChanged) {
            return true;
        }
        if (dirCopy != null) {
            for (i = laterDiffIndex; i < difflist.size(); ++i) {
                if (dirCopy.metadataEquals((INodeDirectoryAttributes)((DirectoryDiff)difflist.get((int)i)).snapshotINode)) continue;
                return true;
            }
            return !dirCopy.metadataEquals(currentINode);
        }
        return false;
    }

    public QuotaCounts cleanDirectory(BlockStoragePolicySuite bsps, INodeDirectory currentINode, int snapshot, int prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        QuotaCounts counts = new QuotaCounts.Builder().build();
        Map<INode, INode> priorCreated = null;
        Map<INode, INode> priorDeleted = null;
        if (snapshot == 0x7FFFFFFE) {
            currentINode.recordModification(prior);
            DirectoryDiff lastDiff = (DirectoryDiff)this.diffs.getLast();
            if (lastDiff != null) {
                counts.add(lastDiff.diff.destroyCreatedList(bsps, currentINode, collectedBlocks, removedINodes));
            }
            counts.add(currentINode.cleanSubtreeRecursively(bsps, snapshot, prior, collectedBlocks, removedINodes, priorDeleted));
        } else {
            DirectoryDiff priorDiff;
            prior = this.getDiffs().updatePrior(snapshot, prior);
            if (prior != -1 && (priorDiff = (DirectoryDiff)this.getDiffs().getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                List<INode> cList = priorDiff.diff.getList(Diff.ListType.CREATED);
                List<INode> dList = priorDiff.diff.getList(Diff.ListType.DELETED);
                priorCreated = DirectoryWithSnapshotFeature.cloneDiffList(cList);
                priorDeleted = DirectoryWithSnapshotFeature.cloneDiffList(dList);
            }
            counts.add(this.getDiffs().deleteSnapshotDiff(bsps, snapshot, prior, currentINode, collectedBlocks, removedINodes));
            counts.add(currentINode.cleanSubtreeRecursively(bsps, snapshot, prior, collectedBlocks, removedINodes, priorDeleted));
            if (prior != -1 && (priorDiff = (DirectoryDiff)this.getDiffs().getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                if (priorCreated != null) {
                    for (INode cNode : priorDiff.getChildrenDiff().getList(Diff.ListType.CREATED)) {
                        if (!priorCreated.containsKey(cNode)) continue;
                        counts.add(cNode.cleanSubtree(bsps, snapshot, -1, collectedBlocks, removedINodes));
                    }
                }
                for (INode dNode : priorDiff.getChildrenDiff().getList(Diff.ListType.DELETED)) {
                    if (priorDeleted != null && priorDeleted.containsKey(dNode)) continue;
                    counts.add(DirectoryWithSnapshotFeature.cleanDeletedINode(bsps, dNode, snapshot, prior, collectedBlocks, removedINodes));
                }
            }
        }
        if (currentINode.isQuotaSet()) {
            currentINode.getDirectoryWithQuotaFeature().addSpaceConsumed2Cache(counts.negation());
        }
        return counts;
    }

    public static class DirectoryDiffList
    extends AbstractINodeDiffList<INodeDirectory, INodeDirectoryAttributes, DirectoryDiff> {
        @Override
        DirectoryDiff createDiff(int snapshot, INodeDirectory currentDir) {
            return new DirectoryDiff(snapshot, currentDir);
        }

        @Override
        INodeDirectoryAttributes createSnapshotCopy(INodeDirectory currentDir) {
            return currentDir.isQuotaSet() ? new INodeDirectoryAttributes.CopyWithQuota(currentDir) : new INodeDirectoryAttributes.SnapshotCopy(currentDir);
        }

        public boolean replaceChild(Diff.ListType type, INode oldChild, INode newChild) {
            List diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                ChildrenDiff diff = ((DirectoryDiff)diffList.get(i)).diff;
                if (!diff.replace(type, oldChild, newChild)) continue;
                return true;
            }
            return false;
        }

        public boolean removeChild(Diff.ListType type, INode child) {
            List diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                ChildrenDiff diff = ((DirectoryDiff)diffList.get(i)).diff;
                if (!diff.removeChild(type, child)) continue;
                return true;
            }
            return false;
        }

        public int findSnapshotDeleted(INode child) {
            List diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                ChildrenDiff diff = ((DirectoryDiff)diffList.get(i)).diff;
                int d = diff.searchIndex(Diff.ListType.DELETED, child.getLocalNameBytes());
                if (d < 0 || diff.getList(Diff.ListType.DELETED).get(d) != child) continue;
                return ((DirectoryDiff)diffList.get(i)).getSnapshotId();
            }
            return -1;
        }
    }

    public static class DirectoryDiff
    extends AbstractINodeDiff<INodeDirectory, INodeDirectoryAttributes, DirectoryDiff> {
        private final int childrenSize;
        private final ChildrenDiff diff;
        private boolean isSnapshotRoot = false;

        private DirectoryDiff(int snapshotId, INodeDirectory dir) {
            super(snapshotId, null, null);
            this.childrenSize = dir.getChildrenList(0x7FFFFFFE).size();
            this.diff = new ChildrenDiff();
        }

        DirectoryDiff(int snapshotId, INodeDirectoryAttributes snapshotINode, DirectoryDiff posteriorDiff, int childrenSize, List<INode> createdList, List<INode> deletedList, boolean isSnapshotRoot) {
            super(snapshotId, snapshotINode, posteriorDiff);
            this.childrenSize = childrenSize;
            this.diff = new ChildrenDiff(createdList, deletedList);
            this.isSnapshotRoot = isSnapshotRoot;
        }

        public ChildrenDiff getChildrenDiff() {
            return this.diff;
        }

        void setSnapshotRoot(INodeDirectoryAttributes root) {
            this.snapshotINode = root;
            this.isSnapshotRoot = true;
        }

        boolean isSnapshotRoot() {
            return this.isSnapshotRoot;
        }

        @Override
        QuotaCounts combinePosteriorAndCollectBlocks(final BlockStoragePolicySuite bsps, INodeDirectory currentDir, DirectoryDiff posterior, final INode.BlocksMapUpdateInfo collectedBlocks, final List<INode> removedINodes) {
            final QuotaCounts counts = new QuotaCounts.Builder().build();
            this.diff.combinePosterior(posterior.diff, new Diff.Processor<INode>(){

                @Override
                public void process(INode inode) {
                    if (inode != null) {
                        inode.computeQuotaUsage(bsps, counts, false);
                        inode.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
                    }
                }
            });
            return counts;
        }

        private ReadOnlyList<INode> getChildrenList(final INodeDirectory currentDir) {
            return new ReadOnlyList<INode>(){
                private List<INode> children = null;

                private List<INode> initChildren() {
                    if (this.children == null) {
                        ChildrenDiff combined = new ChildrenDiff();
                        for (DirectoryDiff d = DirectoryDiff.this; d != null; d = (DirectoryDiff)d.getPosterior()) {
                            combined.combinePosterior(d.diff, null);
                        }
                        this.children = combined.apply2Current(ReadOnlyList.Util.asList(currentDir.getChildrenList(0x7FFFFFFE)));
                    }
                    return this.children;
                }

                @Override
                public Iterator<INode> iterator() {
                    return this.initChildren().iterator();
                }

                @Override
                public boolean isEmpty() {
                    return DirectoryDiff.this.childrenSize == 0;
                }

                @Override
                public int size() {
                    return DirectoryDiff.this.childrenSize;
                }

                @Override
                public INode get(int i) {
                    return this.initChildren().get(i);
                }
            };
        }

        INode getChild(byte[] name, boolean checkPosterior, INodeDirectory currentDir) {
            DirectoryDiff d = this;
            Diff.Container returned;
            while ((returned = d.diff.accessPrevious(name)) == null) {
                if (!checkPosterior) {
                    return null;
                }
                if (d.getPosterior() == null) {
                    return currentDir.getChild(name, 0x7FFFFFFE);
                }
                d = (DirectoryDiff)d.getPosterior();
            }
            return (INode)returned.getElement();
        }

        @Override
        public String toString() {
            return super.toString() + " childrenSize=" + this.childrenSize + ", " + this.diff;
        }

        int getChildrenSize() {
            return this.childrenSize;
        }

        @Override
        void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            this.writeSnapshot(out);
            out.writeInt(this.childrenSize);
            out.writeBoolean(this.isSnapshotRoot);
            if (!this.isSnapshotRoot) {
                if (this.snapshotINode != null) {
                    out.writeBoolean(true);
                    FSImageSerialization.writeINodeDirectoryAttributes((INodeDirectoryAttributes)this.snapshotINode, out);
                } else {
                    out.writeBoolean(false);
                }
            }
            this.diff.write(out, referenceMap);
        }

        @Override
        QuotaCounts destroyDiffAndCollectBlocks(BlockStoragePolicySuite bsps, INodeDirectory currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            QuotaCounts counts = new QuotaCounts.Builder().build();
            counts.add(this.diff.destroyDeletedList(bsps, collectedBlocks, removedINodes));
            INodeDirectoryAttributes snapshotINode = (INodeDirectoryAttributes)this.getSnapshotINode();
            if (snapshotINode != null && snapshotINode.getAclFeature() != null) {
                AclStorage.removeAclFeature(snapshotINode.getAclFeature());
            }
            return counts;
        }
    }

    static class ChildrenDiff
    extends Diff<byte[], INode> {
        ChildrenDiff() {
        }

        private ChildrenDiff(List<INode> created, List<INode> deleted) {
            super(created, deleted);
        }

        private boolean replace(Diff.ListType type, INode oldChild, INode newChild) {
            List<INode> list = this.getList(type);
            int i = ChildrenDiff.search(list, oldChild.getLocalNameBytes());
            if (i < 0 || ((INode)list.get(i)).getId() != oldChild.getId()) {
                return false;
            }
            INode removed = list.set(i, newChild);
            Preconditions.checkState(removed == oldChild);
            return true;
        }

        private boolean removeChild(Diff.ListType type, INode child) {
            List list = this.getList(type);
            int i = this.searchIndex(type, child.getLocalNameBytes());
            if (i >= 0 && list.get(i) == child) {
                list.remove(i);
                return true;
            }
            return false;
        }

        private QuotaCounts destroyCreatedList(BlockStoragePolicySuite bsps, INodeDirectory currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            QuotaCounts counts = new QuotaCounts.Builder().build();
            List createdList = this.getList(Diff.ListType.CREATED);
            for (INode c : createdList) {
                c.computeQuotaUsage(bsps, counts, true);
                c.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
                currentINode.removeChild(c);
            }
            createdList.clear();
            return counts;
        }

        private QuotaCounts destroyDeletedList(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            QuotaCounts counts = new QuotaCounts.Builder().build();
            List deletedList = this.getList(Diff.ListType.DELETED);
            for (INode d : deletedList) {
                d.computeQuotaUsage(bsps, counts, false);
                d.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
            }
            deletedList.clear();
            return counts;
        }

        private void writeCreated(DataOutput out) throws IOException {
            List created = this.getList(Diff.ListType.CREATED);
            out.writeInt(created.size());
            for (INode node : created) {
                byte[] name = node.getLocalNameBytes();
                out.writeShort(name.length);
                out.write(name);
            }
        }

        private void writeDeleted(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            List deleted = this.getList(Diff.ListType.DELETED);
            out.writeInt(deleted.size());
            for (INode node : deleted) {
                FSImageSerialization.saveINode2Image(node, out, true, referenceMap);
            }
        }

        private void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            this.writeCreated(out);
            this.writeDeleted(out, referenceMap);
        }

        private void getDirsInDeleted(List<INodeDirectory> dirList) {
            for (INode node : this.getList(Diff.ListType.DELETED)) {
                if (!node.isDirectory()) continue;
                dirList.add(node.asDirectory());
            }
        }
    }
}

