/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.apache.commons.codec.binary.Base64;
import org.apache.flink.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherOption;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.hdfs.net.EncryptedPeer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslParticipant;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslResponseWithNegotiatedCipherOption;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SaslDataTransferClient {
    private static final Logger LOG = LoggerFactory.getLogger(SaslDataTransferClient.class);
    private final Configuration conf;
    private final AtomicBoolean fallbackToSimpleAuth;
    private final SaslPropertiesResolver saslPropsResolver;
    private final TrustedChannelResolver trustedChannelResolver;

    public SaslDataTransferClient(Configuration conf, SaslPropertiesResolver saslPropsResolver, TrustedChannelResolver trustedChannelResolver) {
        this(conf, saslPropsResolver, trustedChannelResolver, null);
    }

    public SaslDataTransferClient(Configuration conf, SaslPropertiesResolver saslPropsResolver, TrustedChannelResolver trustedChannelResolver, AtomicBoolean fallbackToSimpleAuth) {
        this.conf = conf;
        this.fallbackToSimpleAuth = fallbackToSimpleAuth;
        this.saslPropsResolver = saslPropsResolver;
        this.trustedChannelResolver = trustedChannelResolver;
    }

    public IOStreamPair newSocketSend(Socket socket, OutputStream underlyingOut, InputStream underlyingIn, DataEncryptionKeyFactory encryptionKeyFactory, Token<BlockTokenIdentifier> accessToken, DatanodeID datanodeId) throws IOException {
        DataEncryptionKey encryptionKey = !this.trustedChannelResolver.isTrusted() ? encryptionKeyFactory.newDataEncryptionKey() : null;
        IOStreamPair ios = this.send(socket.getInetAddress(), underlyingOut, underlyingIn, encryptionKey, accessToken, datanodeId);
        return ios != null ? ios : new IOStreamPair(underlyingIn, underlyingOut);
    }

    public Peer peerSend(Peer peer, DataEncryptionKeyFactory encryptionKeyFactory, Token<BlockTokenIdentifier> accessToken, DatanodeID datanodeId) throws IOException {
        IOStreamPair ios = this.checkTrustAndSend(DataTransferSaslUtil.getPeerAddress(peer), peer.getOutputStream(), peer.getInputStream(), encryptionKeyFactory, accessToken, datanodeId);
        return ios != null ? new EncryptedPeer(peer, ios) : peer;
    }

    public IOStreamPair socketSend(Socket socket, OutputStream underlyingOut, InputStream underlyingIn, DataEncryptionKeyFactory encryptionKeyFactory, Token<BlockTokenIdentifier> accessToken, DatanodeID datanodeId) throws IOException {
        IOStreamPair ios = this.checkTrustAndSend(socket.getInetAddress(), underlyingOut, underlyingIn, encryptionKeyFactory, accessToken, datanodeId);
        return ios != null ? ios : new IOStreamPair(underlyingIn, underlyingOut);
    }

    private IOStreamPair checkTrustAndSend(InetAddress addr, OutputStream underlyingOut, InputStream underlyingIn, DataEncryptionKeyFactory encryptionKeyFactory, Token<BlockTokenIdentifier> accessToken, DatanodeID datanodeId) throws IOException {
        if (!this.trustedChannelResolver.isTrusted() && !this.trustedChannelResolver.isTrusted(addr)) {
            DataEncryptionKey encryptionKey = encryptionKeyFactory.newDataEncryptionKey();
            return this.send(addr, underlyingOut, underlyingIn, encryptionKey, accessToken, datanodeId);
        }
        LOG.debug("SASL client skipping handshake on trusted connection for addr = {}, datanodeId = {}", (Object)addr, (Object)datanodeId);
        return null;
    }

    private IOStreamPair send(InetAddress addr, OutputStream underlyingOut, InputStream underlyingIn, DataEncryptionKey encryptionKey, Token<BlockTokenIdentifier> accessToken, DatanodeID datanodeId) throws IOException {
        if (encryptionKey != null) {
            LOG.debug("SASL client doing encrypted handshake for addr = {}, datanodeId = {}", (Object)addr, (Object)datanodeId);
            return this.getEncryptedStreams(underlyingOut, underlyingIn, encryptionKey);
        }
        if (!UserGroupInformation.isSecurityEnabled()) {
            LOG.debug("SASL client skipping handshake in unsecured configuration for addr = {}, datanodeId = {}", (Object)addr, (Object)datanodeId);
            return null;
        }
        if (SecurityUtil.isPrivilegedPort(datanodeId.getXferPort())) {
            LOG.debug("SASL client skipping handshake in secured configuration with privileged port for addr = {}, datanodeId = {}", (Object)addr, (Object)datanodeId);
            return null;
        }
        if (this.fallbackToSimpleAuth != null && this.fallbackToSimpleAuth.get()) {
            LOG.debug("SASL client skipping handshake in secured configuration with unsecured cluster for addr = {}, datanodeId = {}", (Object)addr, (Object)datanodeId);
            return null;
        }
        if (this.saslPropsResolver != null) {
            LOG.debug("SASL client doing general handshake for addr = {}, datanodeId = {}", (Object)addr, (Object)datanodeId);
            return this.getSaslStreams(addr, underlyingOut, underlyingIn, accessToken, datanodeId);
        }
        LOG.debug("SASL client skipping handshake in secured configuration with no SASL protection configured for addr = {}, datanodeId = {}", (Object)addr, (Object)datanodeId);
        return null;
    }

    private IOStreamPair getEncryptedStreams(OutputStream underlyingOut, InputStream underlyingIn, DataEncryptionKey encryptionKey) throws IOException {
        Map<String, String> saslProps = DataTransferSaslUtil.createSaslPropertiesForEncryption(encryptionKey.encryptionAlgorithm);
        LOG.debug("Client using encryption algorithm {}", (Object)encryptionKey.encryptionAlgorithm);
        String userName = SaslDataTransferClient.getUserNameFromEncryptionKey(encryptionKey);
        char[] password = DataTransferSaslUtil.encryptionKeyToPassword(encryptionKey.encryptionKey);
        SaslClientCallbackHandler callbackHandler = new SaslClientCallbackHandler(userName, password);
        return this.doSaslHandshake(underlyingOut, underlyingIn, userName, saslProps, callbackHandler);
    }

    private static String getUserNameFromEncryptionKey(DataEncryptionKey encryptionKey) {
        return encryptionKey.keyId + " " + encryptionKey.blockPoolId + " " + new String(Base64.encodeBase64((byte[])encryptionKey.nonce, (boolean)false), Charsets.UTF_8);
    }

    private IOStreamPair getSaslStreams(InetAddress addr, OutputStream underlyingOut, InputStream underlyingIn, Token<BlockTokenIdentifier> accessToken, DatanodeID datanodeId) throws IOException {
        Map<String, String> saslProps = this.saslPropsResolver.getClientProperties(addr);
        String userName = SaslDataTransferClient.buildUserName(accessToken);
        char[] password = this.buildClientPassword(accessToken);
        SaslClientCallbackHandler callbackHandler = new SaslClientCallbackHandler(userName, password);
        return this.doSaslHandshake(underlyingOut, underlyingIn, userName, saslProps, callbackHandler);
    }

    private static String buildUserName(Token<BlockTokenIdentifier> blockToken) {
        return new String(Base64.encodeBase64((byte[])blockToken.getIdentifier(), (boolean)false), Charsets.UTF_8);
    }

    private char[] buildClientPassword(Token<BlockTokenIdentifier> blockToken) {
        return new String(Base64.encodeBase64((byte[])blockToken.getPassword(), (boolean)false), Charsets.UTF_8).toCharArray();
    }

    private IOStreamPair doSaslHandshake(OutputStream underlyingOut, InputStream underlyingIn, String userName, Map<String, String> saslProps, CallbackHandler callbackHandler) throws IOException {
        DataOutputStream out = new DataOutputStream(underlyingOut);
        DataInputStream in = new DataInputStream(underlyingIn);
        SaslParticipant sasl = SaslParticipant.createClientSaslParticipant(userName, saslProps, callbackHandler);
        out.writeInt(-559038737);
        out.flush();
        try {
            String cipherSuites;
            DataTransferSaslUtil.sendSaslMessage(out, new byte[0]);
            byte[] remoteResponse = DataTransferSaslUtil.readSaslMessage(in);
            byte[] localResponse = sasl.evaluateChallengeOrResponse(remoteResponse);
            ArrayList<CipherOption> cipherOptions = null;
            if (DataTransferSaslUtil.requestedQopContainsPrivacy(saslProps) && (cipherSuites = this.conf.get("dfs.encrypt.data.transfer.cipher.suites")) != null && !cipherSuites.isEmpty()) {
                if (!cipherSuites.equals(CipherSuite.AES_CTR_NOPADDING.getName())) {
                    throw new IOException(String.format("Invalid cipher suite, %s=%s", "dfs.encrypt.data.transfer.cipher.suites", cipherSuites));
                }
                CipherOption option = new CipherOption(CipherSuite.AES_CTR_NOPADDING);
                cipherOptions = Lists.newArrayListWithCapacity(1);
                cipherOptions.add(option);
            }
            DataTransferSaslUtil.sendSaslMessageAndNegotiationCipherOptions(out, localResponse, cipherOptions);
            SaslResponseWithNegotiatedCipherOption response = DataTransferSaslUtil.readSaslMessageAndNegotiatedCipherOption(in);
            localResponse = sasl.evaluateChallengeOrResponse(response.payload);
            assert (localResponse == null);
            DataTransferSaslUtil.checkSaslComplete(sasl, saslProps);
            CipherOption cipherOption = null;
            if (sasl.isNegotiatedQopPrivacy()) {
                cipherOption = DataTransferSaslUtil.unwrap(response.cipherOption, sasl);
            }
            return cipherOption != null ? DataTransferSaslUtil.createStreamPair(this.conf, cipherOption, underlyingOut, underlyingIn, false) : sasl.createStreamPair(out, in);
        }
        catch (IOException ioe) {
            DataTransferSaslUtil.sendGenericSaslErrorMessage(out, ioe.getMessage());
            throw ioe;
        }
    }

    private static final class SaslClientCallbackHandler
    implements CallbackHandler {
        private final char[] password;
        private final String userName;

        public SaslClientCallbackHandler(String userName, char[] password) {
            this.password = password;
            this.userName = userName;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                nc.setName(this.userName);
            }
            if (pc != null) {
                pc.setPassword(this.password);
            }
            if (rc != null) {
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

