/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TokenCache {
    private static final Log LOG = LogFactory.getLog(TokenCache.class);
    @InterfaceAudience.Private
    public static final String JOB_TOKEN_HDFS_FILE = "jobToken";
    @InterfaceAudience.Private
    public static final String JOB_TOKENS_FILENAME = "mapreduce.job.jobTokenFile";
    private static final Text JOB_TOKEN = new Text("JobToken");
    private static final Text SHUFFLE_TOKEN = new Text("MapReduceShuffleToken");

    public static byte[] getSecretKey(Credentials credentials, Text alias) {
        if (credentials == null) {
            return null;
        }
        return credentials.getSecretKey(alias);
    }

    public static void obtainTokensForNamenodes(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        TokenCache.obtainTokensForNamenodesInternal(credentials, ps, conf);
    }

    public static void cleanUpTokenReferral(Configuration conf) {
        conf.unset("mapreduce.job.credentials.binary");
    }

    static void obtainTokensForNamenodesInternal(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        HashSet<FileSystem> fsSet = new HashSet<FileSystem>();
        for (Path p : ps) {
            fsSet.add(p.getFileSystem(conf));
        }
        for (FileSystem fs : fsSet) {
            TokenCache.obtainTokensForNamenodesInternal(fs, credentials, conf);
        }
    }

    static void obtainTokensForNamenodesInternal(FileSystem fs, Credentials credentials, Configuration conf) throws IOException {
        String delegTokenRenewer = Master.getMasterPrincipal(conf);
        if (delegTokenRenewer == null || delegTokenRenewer.length() == 0) {
            throw new IOException("Can't get Master Kerberos principal for use as renewer");
        }
        TokenCache.mergeBinaryTokens(credentials, conf);
        Token<?>[] tokens = fs.addDelegationTokens(delegTokenRenewer, credentials);
        if (tokens != null) {
            for (Token<?> token : tokens) {
                LOG.info((Object)("Got dt for " + fs.getUri() + "; " + token));
            }
        }
    }

    private static void mergeBinaryTokens(Credentials creds, Configuration conf) {
        String binaryTokenFilename = conf.get("mapreduce.job.credentials.binary");
        if (binaryTokenFilename != null) {
            Credentials binary;
            try {
                binary = Credentials.readTokenStorageFile(new Path("file:///" + binaryTokenFilename), conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            creds.mergeAll(binary);
        }
    }

    @Deprecated
    @InterfaceAudience.Private
    public static Credentials loadTokens(String jobTokenFile, JobConf conf) throws IOException {
        Path localJobTokenFile = new Path("file:///" + jobTokenFile);
        Credentials ts = Credentials.readTokenStorageFile(localJobTokenFile, (Configuration)conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task: Loaded jobTokenFile from: " + localJobTokenFile.toUri().getPath() + "; num of sec keys  = " + ts.numberOfSecretKeys() + " Number of tokens " + ts.numberOfTokens()));
        }
        return ts;
    }

    @Deprecated
    @InterfaceAudience.Private
    public static Credentials loadTokens(String jobTokenFile, Configuration conf) throws IOException {
        return TokenCache.loadTokens(jobTokenFile, new JobConf(conf));
    }

    @InterfaceAudience.Private
    public static void setJobToken(Token<? extends TokenIdentifier> t, Credentials credentials) {
        credentials.addToken(JOB_TOKEN, t);
    }

    @InterfaceAudience.Private
    public static Token<JobTokenIdentifier> getJobToken(Credentials credentials) {
        return credentials.getToken(JOB_TOKEN);
    }

    @InterfaceAudience.Private
    public static void setShuffleSecretKey(byte[] key, Credentials credentials) {
        credentials.addSecretKey(SHUFFLE_TOKEN, key);
    }

    @InterfaceAudience.Private
    public static byte[] getShuffleSecretKey(Credentials credentials) {
        return TokenCache.getSecretKey(credentials, SHUFFLE_TOKEN);
    }

    @Deprecated
    @InterfaceAudience.Private
    public static Token<?> getDelegationToken(Credentials credentials, String namenode) {
        return credentials.getToken(new Text(namenode));
    }
}

