/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;

@InterfaceAudience.Private
public interface INodeDirectoryAttributes
extends INodeAttributes {
    public long getNsQuota();

    public long getDsQuota();

    public boolean metadataEquals(INodeDirectoryAttributes var1);

    public static class CopyWithQuota
    extends SnapshotCopy {
        private final long nsQuota;
        private final long dsQuota;

        public CopyWithQuota(byte[] name, PermissionStatus permissions, long modificationTime, long nsQuota, long dsQuota) {
            super(name, permissions, modificationTime);
            this.nsQuota = nsQuota;
            this.dsQuota = dsQuota;
        }

        public CopyWithQuota(INodeDirectory dir) {
            super(dir);
            Preconditions.checkArgument(dir.isQuotaSet());
            this.nsQuota = dir.getNsQuota();
            this.dsQuota = dir.getDsQuota();
        }

        @Override
        public final long getNsQuota() {
            return this.nsQuota;
        }

        @Override
        public final long getDsQuota() {
            return this.dsQuota;
        }
    }

    public static class SnapshotCopy
    extends INodeAttributes.SnapshotCopy
    implements INodeDirectoryAttributes {
        public SnapshotCopy(byte[] name, PermissionStatus permissions, long modificationTime) {
            super(name, permissions, modificationTime, 0L);
        }

        public SnapshotCopy(INodeDirectory dir) {
            super(dir);
        }

        @Override
        public long getNsQuota() {
            return -1L;
        }

        @Override
        public long getDsQuota() {
            return -1L;
        }

        @Override
        public boolean metadataEquals(INodeDirectoryAttributes other) {
            return other != null && this.getNsQuota() == other.getNsQuota() && this.getDsQuota() == other.getDsQuota() && this.getPermissionLong() == other.getPermissionLong();
        }
    }
}

