/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.delegation;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
public class DelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(DelegationTokenSecretManager.class);
    private final FSNamesystem namesystem;

    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, FSNamesystem namesystem) {
        this(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, false, namesystem);
    }

    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, boolean storeTokenTrackingId, FSNamesystem namesystem) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.namesystem = namesystem;
        this.storeTokenTrackingId = storeTokenTrackingId;
    }

    @Override
    public DelegationTokenIdentifier createIdentifier() {
        return new DelegationTokenIdentifier();
    }

    @Override
    public byte[] retrievePassword(DelegationTokenIdentifier identifier) throws SecretManager.InvalidToken {
        try {
            this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        }
        catch (StandbyException se) {
            SecretManager.InvalidToken wrappedStandby = new SecretManager.InvalidToken("StandbyException");
            wrappedStandby.initCause(se);
            throw wrappedStandby;
        }
        return super.retrievePassword(identifier);
    }

    @Override
    public byte[] retriableRetrievePassword(DelegationTokenIdentifier identifier) throws SecretManager.InvalidToken, StandbyException, RetriableException, IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        try {
            return super.retrievePassword(identifier);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.namesystem.inTransitionToActive()) {
                throw new RetriableException(it);
            }
            throw it;
        }
    }

    public synchronized long getTokenExpiryTime(DelegationTokenIdentifier dtId) throws IOException {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(dtId);
        if (info != null) {
            return info.getRenewDate();
        }
        throw new IOException("No delegation token found for this identifier");
    }

    public synchronized void loadSecretManagerState(DataInput in) throws IOException {
        if (this.running) {
            throw new IOException("Can't load state from image in a running SecretManager.");
        }
        this.currentId = in.readInt();
        this.loadAllKeys(in);
        this.delegationTokenSequenceNumber = in.readInt();
        this.loadCurrentTokens(in);
    }

    public synchronized void saveSecretManagerState(DataOutputStream out, String sdPath) throws IOException {
        out.writeInt(this.currentId);
        this.saveAllKeys(out, sdPath);
        out.writeInt(this.delegationTokenSequenceNumber);
        this.saveCurrentTokens(out, sdPath);
    }

    @Override
    public synchronized void addPersistedDelegationToken(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't add persisted delegation token to a running SecretManager.");
        }
        int keyId = identifier.getMasterKeyId();
        DelegationKey dKey = (DelegationKey)this.allKeys.get(keyId);
        if (dKey == null) {
            LOG.warn((Object)("No KEY found for persisted identifier " + identifier.toString()));
            return;
        }
        byte[] password = DelegationTokenSecretManager.createPassword(identifier.getBytes(), dKey.getKey());
        if (identifier.getSequenceNumber() > this.delegationTokenSequenceNumber) {
            this.delegationTokenSequenceNumber = identifier.getSequenceNumber();
        }
        if (this.currentTokens.get(identifier) != null) {
            throw new IOException("Same delegation token being added twice; invalid entry in fsimage or editlogs");
        }
        this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password, this.getTrackingIdIfEnabled(identifier)));
    }

    public synchronized void updatePersistedMasterKey(DelegationKey key) throws IOException {
        this.addKey(key);
    }

    public synchronized void updatePersistedTokenRenewal(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = null;
        info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(identifier);
        if (info != null) {
            int keyId = identifier.getMasterKeyId();
            byte[] password = DelegationTokenSecretManager.createPassword(identifier.getBytes(), ((DelegationKey)this.allKeys.get(keyId)).getKey());
            this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password, this.getTrackingIdIfEnabled(identifier)));
        }
    }

    public synchronized void updatePersistedTokenCancellation(DelegationTokenIdentifier identifier) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        this.currentTokens.remove(identifier);
    }

    public synchronized int getNumberOfKeys() {
        return this.allKeys.size();
    }

    private synchronized void saveCurrentTokens(DataOutputStream out, String sdPath) throws IOException {
        StartupProgress prog = NameNode.getStartupProgress();
        Step step = new Step(StepType.DELEGATION_TOKENS, sdPath);
        prog.beginStep(Phase.SAVING_CHECKPOINT, step);
        prog.setTotal(Phase.SAVING_CHECKPOINT, step, this.currentTokens.size());
        StartupProgress.Counter counter = prog.getCounter(Phase.SAVING_CHECKPOINT, step);
        out.writeInt(this.currentTokens.size());
        for (DelegationTokenIdentifier id : this.currentTokens.keySet()) {
            id.write(out);
            AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(id);
            out.writeLong(info.getRenewDate());
            counter.increment();
        }
        prog.endStep(Phase.SAVING_CHECKPOINT, step);
    }

    private synchronized void saveAllKeys(DataOutputStream out, String sdPath) throws IOException {
        StartupProgress prog = NameNode.getStartupProgress();
        Step step = new Step(StepType.DELEGATION_KEYS, sdPath);
        prog.beginStep(Phase.SAVING_CHECKPOINT, step);
        prog.setTotal(Phase.SAVING_CHECKPOINT, step, this.currentTokens.size());
        StartupProgress.Counter counter = prog.getCounter(Phase.SAVING_CHECKPOINT, step);
        out.writeInt(this.allKeys.size());
        for (Integer key : this.allKeys.keySet()) {
            ((DelegationKey)this.allKeys.get(key)).write(out);
            counter.increment();
        }
        prog.endStep(Phase.SAVING_CHECKPOINT, step);
    }

    private synchronized void loadCurrentTokens(DataInput in) throws IOException {
        StartupProgress prog = NameNode.getStartupProgress();
        Step step = new Step(StepType.DELEGATION_TOKENS);
        prog.beginStep(Phase.LOADING_FSIMAGE, step);
        int numberOfTokens = in.readInt();
        prog.setTotal(Phase.LOADING_FSIMAGE, step, numberOfTokens);
        StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, step);
        for (int i = 0; i < numberOfTokens; ++i) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            id.readFields(in);
            long expiryTime = in.readLong();
            this.addPersistedDelegationToken(id, expiryTime);
            counter.increment();
        }
        prog.endStep(Phase.LOADING_FSIMAGE, step);
    }

    private synchronized void loadAllKeys(DataInput in) throws IOException {
        StartupProgress prog = NameNode.getStartupProgress();
        Step step = new Step(StepType.DELEGATION_KEYS);
        prog.beginStep(Phase.LOADING_FSIMAGE, step);
        int numberOfKeys = in.readInt();
        prog.setTotal(Phase.LOADING_FSIMAGE, step, numberOfKeys);
        StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, step);
        for (int i = 0; i < numberOfKeys; ++i) {
            DelegationKey value = new DelegationKey();
            value.readFields(in);
            this.addKey(value);
            counter.increment();
        }
        prog.endStep(Phase.LOADING_FSIMAGE, step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
        Object object = this.noInterruptsLock;
        synchronized (object) {
            if (Thread.interrupted()) {
                throw new InterruptedIOException("Interrupted before updating master key");
            }
            this.namesystem.logUpdateMasterKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logExpireToken(DelegationTokenIdentifier dtId) throws IOException {
        Object object = this.noInterruptsLock;
        synchronized (object) {
            if (Thread.interrupted()) {
                throw new InterruptedIOException("Interrupted before expiring delegation token");
            }
            this.namesystem.logExpireDelegationToken(dtId);
        }
    }

    public static Credentials createCredentials(NameNode namenode, UserGroupInformation ugi, String renewer) throws IOException {
        Token<DelegationTokenIdentifier> token = namenode.getRpcServer().getDelegationToken(new Text(renewer));
        if (token == null) {
            throw new IOException("Failed to get the token for " + renewer + ", user=" + ugi.getShortUserName());
        }
        InetSocketAddress addr = namenode.getNameNodeAddress();
        SecurityUtil.setTokenService(token, addr);
        Credentials c = new Credentials();
        c.addToken(new Text(ugi.getShortUserName()), token);
        return c;
    }
}

