/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ContainerTokenSelector
implements TokenSelector<ContainerTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(ContainerTokenSelector.class);

    @Override
    public Token<ContainerTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Looking for service: " + service + ". Current token is " + token);
            }
            if (!ContainerTokenIdentifier.KIND.equals(token.getKind()) || !service.equals(token.getService())) continue;
            return token;
        }
        return null;
    }
}

