/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetContainerStatusesRequestPBImpl
extends GetContainerStatusesRequest {
    YarnServiceProtos.GetContainerStatusesRequestProto proto = YarnServiceProtos.GetContainerStatusesRequestProto.getDefaultInstance();
    YarnServiceProtos.GetContainerStatusesRequestProto.Builder builder = null;
    boolean viaProto = false;
    private List<ContainerId> containerIds = null;

    public GetContainerStatusesRequestPBImpl() {
        this.builder = YarnServiceProtos.GetContainerStatusesRequestProto.newBuilder();
    }

    public GetContainerStatusesRequestPBImpl(YarnServiceProtos.GetContainerStatusesRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetContainerStatusesRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetContainerStatusesRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.containerIds != null) {
            this.addLocalContainerIdsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetContainerStatusesRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addLocalContainerIdsToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainerId();
        if (this.containerIds == null) {
            return;
        }
        ArrayList<YarnProtos.ContainerIdProto> protoList = new ArrayList<YarnProtos.ContainerIdProto>();
        for (ContainerId id : this.containerIds) {
            protoList.add(this.convertToProtoFormat(id));
        }
        this.builder.addAllContainerId(protoList);
    }

    private void initLocalContainerIds() {
        if (this.containerIds != null) {
            return;
        }
        YarnServiceProtos.GetContainerStatusesRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerIdProto> containerIds = p.getContainerIdList();
        this.containerIds = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto id : containerIds) {
            this.containerIds.add(this.convertFromProtoFormat(id));
        }
    }

    @Override
    public List<ContainerId> getContainerIds() {
        this.initLocalContainerIds();
        return this.containerIds;
    }

    @Override
    public void setContainerIds(List<ContainerId> containerIds) {
        this.maybeInitBuilder();
        if (containerIds == null) {
            this.builder.clearContainerId();
        }
        this.containerIds = containerIds;
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }
}

