/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EventWriter {
    static final String VERSION = "Avro-Json";
    private FSDataOutputStream out;
    private DatumWriter<Event> writer = new SpecificDatumWriter<Event>(Event.class);
    private Encoder encoder;
    private static final Log LOG = LogFactory.getLog(EventWriter.class);
    private static final Schema GROUPS = Schema.createArray(JhCounterGroup.SCHEMA$);
    private static final Schema COUNTERS = Schema.createArray(JhCounter.SCHEMA$);

    @VisibleForTesting
    public EventWriter(FSDataOutputStream out) throws IOException {
        this.out = out;
        out.writeBytes(VERSION);
        out.writeBytes("\n");
        out.writeBytes(Event.SCHEMA$.toString());
        out.writeBytes("\n");
        this.encoder = EncoderFactory.get().jsonEncoder(Event.SCHEMA$, out);
    }

    synchronized void write(HistoryEvent event) throws IOException {
        Event wrapper = new Event();
        wrapper.type = event.getEventType();
        wrapper.event = event.getDatum();
        this.writer.write(wrapper, this.encoder);
        this.encoder.flush();
        this.out.writeBytes("\n");
    }

    void flush() throws IOException {
        this.encoder.flush();
        this.out.flush();
        this.out.hflush();
    }

    @VisibleForTesting
    public void close() throws IOException {
        try {
            this.encoder.flush();
            this.out.close();
            this.out = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, this.out);
            throw throwable;
        }
        IOUtils.cleanup(LOG, this.out);
    }

    static JhCounters toAvro(Counters counters) {
        return EventWriter.toAvro(counters, "COUNTERS");
    }

    static JhCounters toAvro(Counters counters, String name) {
        JhCounters result = new JhCounters();
        result.name = new Utf8(name);
        result.groups = new ArrayList<JhCounterGroup>(0);
        if (counters == null) {
            return result;
        }
        for (CounterGroup group : counters) {
            JhCounterGroup g = new JhCounterGroup();
            g.name = new Utf8(group.getName());
            g.displayName = new Utf8(group.getDisplayName());
            g.counts = new ArrayList<JhCounter>(group.size());
            for (Counter counter : group) {
                JhCounter c = new JhCounter();
                c.name = new Utf8(counter.getName());
                c.displayName = new Utf8(counter.getDisplayName());
                c.value = counter.getValue();
                g.counts.add(c);
            }
            result.groups.add(g);
        }
        return result;
    }
}

