/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.counters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Iterators;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.LimitExceededException;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.hadoop.mapreduce.util.ResourceBundles;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Private
public abstract class AbstractCounterGroup<T extends Counter>
implements CounterGroupBase<T> {
    private final String name;
    private String displayName;
    private final ConcurrentMap<String, T> counters = new ConcurrentSkipListMap<String, T>();
    private final Limits limits;

    public AbstractCounterGroup(String name, String displayName, Limits limits) {
        this.name = name;
        this.displayName = displayName;
        this.limits = limits;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized String getDisplayName() {
        return this.displayName;
    }

    @Override
    public synchronized void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public synchronized void addCounter(T counter) {
        this.counters.put(counter.getName(), counter);
        this.limits.incrCounters();
    }

    @Override
    public synchronized T addCounter(String counterName, String displayName, long value) {
        String saveName = Limits.filterCounterName(counterName);
        T counter = this.findCounterImpl(saveName, false);
        if (counter == null) {
            return this.addCounterImpl(saveName, displayName, value);
        }
        counter.setValue(value);
        return counter;
    }

    private T addCounterImpl(String name, String displayName, long value) {
        T counter = this.newCounter(name, displayName, value);
        this.addCounter(counter);
        return counter;
    }

    @Override
    public synchronized T findCounter(String counterName, String displayName) {
        String saveName = Limits.filterCounterName(counterName);
        T counter = this.findCounterImpl(saveName, false);
        if (counter == null) {
            return this.addCounterImpl(saveName, displayName, 0L);
        }
        return counter;
    }

    @Override
    public T findCounter(String counterName, boolean create) {
        return this.findCounterImpl(Limits.filterCounterName(counterName), create);
    }

    private synchronized T findCounterImpl(String counterName, boolean create) {
        Counter counter = (Counter)this.counters.get(counterName);
        if (counter == null && create) {
            String localized = ResourceBundles.getCounterName(this.getName(), counterName, counterName);
            return this.addCounterImpl(counterName, localized, 0L);
        }
        return (T)counter;
    }

    @Override
    public T findCounter(String counterName) {
        return this.findCounter(counterName, true);
    }

    protected abstract T newCounter(String var1, String var2, long var3);

    protected abstract T newCounter();

    @Override
    public Iterator<T> iterator() {
        return this.counters.values().iterator();
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        Text.writeString(out, this.displayName);
        WritableUtils.writeVInt(out, this.counters.size());
        for (Counter counter : this.counters.values()) {
            counter.write(out);
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        this.displayName = StringInterner.weakIntern(Text.readString(in));
        this.counters.clear();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            T counter = this.newCounter();
            counter.readFields(in);
            this.counters.put(counter.getName(), counter);
            this.limits.incrCounters();
        }
    }

    @Override
    public synchronized int size() {
        return this.counters.size();
    }

    public synchronized boolean equals(Object genericRight) {
        if (genericRight instanceof CounterGroupBase) {
            CounterGroupBase right = (CounterGroupBase)genericRight;
            return Iterators.elementsEqual(this.iterator(), right.iterator());
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.counters.hashCode();
    }

    @Override
    public void incrAllCounters(CounterGroupBase<T> rightGroup) {
        try {
            for (Counter right : rightGroup) {
                T left = this.findCounter(right.getName(), right.getDisplayName());
                left.increment(right.getValue());
            }
        }
        catch (LimitExceededException e) {
            this.counters.clear();
            throw e;
        }
    }
}

