/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoStreamUtils;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.Syncable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CryptoOutputStream
extends FilterOutputStream
implements Syncable,
CanSetDropBehind {
    private final byte[] oneByteBuf = new byte[1];
    private final CryptoCodec codec;
    private final Encryptor encryptor;
    private final int bufferSize;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private long streamOffset = 0L;
    private byte padding;
    private boolean closed;
    private final byte[] key;
    private final byte[] initIV;
    private byte[] iv;
    private byte[] tmpBuf;

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, int bufferSize, byte[] key, byte[] iv) throws IOException {
        this(out, codec, bufferSize, key, iv, 0L);
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, int bufferSize, byte[] key, byte[] iv, long streamOffset) throws IOException {
        super(out);
        CryptoStreamUtils.checkCodec(codec);
        this.bufferSize = CryptoStreamUtils.checkBufferSize(codec, bufferSize);
        this.codec = codec;
        this.key = (byte[])key.clone();
        this.initIV = (byte[])iv.clone();
        this.iv = (byte[])iv.clone();
        this.inBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.outBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.streamOffset = streamOffset;
        try {
            this.encryptor = codec.createEncryptor();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        this.updateEncryptor();
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, byte[] key, byte[] iv) throws IOException {
        this(out, codec, key, iv, 0L);
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, byte[] key, byte[] iv, long streamOffset) throws IOException {
        this(out, codec, CryptoStreamUtils.getBufferSize(codec.getConf()), key, iv, streamOffset);
    }

    public OutputStream getWrappedStream() {
        return this.out;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int remaining = this.inBuffer.remaining();
            if (len < remaining) {
                this.inBuffer.put(b, off, len);
                len = 0;
                continue;
            }
            this.inBuffer.put(b, off, remaining);
            off += remaining;
            len -= remaining;
            this.encrypt();
        }
    }

    private void encrypt() throws IOException {
        Preconditions.checkState(this.inBuffer.position() >= this.padding);
        if (this.inBuffer.position() == this.padding) {
            return;
        }
        this.inBuffer.flip();
        this.outBuffer.clear();
        this.encryptor.encrypt(this.inBuffer, this.outBuffer);
        this.inBuffer.clear();
        this.outBuffer.flip();
        if (this.padding > 0) {
            this.outBuffer.position(this.padding);
            this.padding = 0;
        }
        int len = this.outBuffer.remaining();
        byte[] tmp = this.getTmpBuf();
        this.outBuffer.get(tmp, 0, len);
        this.out.write(tmp, 0, len);
        this.streamOffset += (long)len;
        if (this.encryptor.isContextReset()) {
            this.updateEncryptor();
        }
    }

    private void updateEncryptor() throws IOException {
        long counter = this.streamOffset / (long)this.codec.getCipherSuite().getAlgorithmBlockSize();
        this.padding = (byte)(this.streamOffset % (long)this.codec.getCipherSuite().getAlgorithmBlockSize());
        this.inBuffer.position(this.padding);
        this.codec.calculateIV(this.initIV, counter, this.iv);
        this.encryptor.init(this.key, this.iv);
    }

    private byte[] getTmpBuf() {
        if (this.tmpBuf == null) {
            this.tmpBuf = new byte[this.bufferSize];
        }
        return this.tmpBuf;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            super.close();
            this.freeBuffers();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkStream();
        this.encrypt();
        super.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByteBuf[0] = (byte)(b & 0xFF);
        this.write(this.oneByteBuf, 0, this.oneByteBuf.length);
    }

    private void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void setDropBehind(Boolean dropCache) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetDropBehind)((Object)this.out)).setDropBehind(dropCache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support setting the drop-behind caching.");
        }
    }

    @Override
    @Deprecated
    public void sync() throws IOException {
        this.hflush();
    }

    @Override
    public void hflush() throws IOException {
        this.flush();
        if (this.out instanceof Syncable) {
            ((Syncable)((Object)this.out)).hflush();
        }
    }

    @Override
    public void hsync() throws IOException {
        this.flush();
        if (this.out instanceof Syncable) {
            ((Syncable)((Object)this.out)).hsync();
        }
    }

    private void freeBuffers() {
        CryptoStreamUtils.freeDB(this.inBuffer);
        CryptoStreamUtils.freeDB(this.outBuffer);
    }
}

