/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpCodecUtil;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.internal.CaseIgnoringComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders {
    private static final int BUCKET_SIZE = 17;
    private final HeaderEntry[] entries = new HeaderEntry[17];
    private final HeaderEntry head;

    public static boolean isKeepAlive(HttpMessage message) {
        String connection = message.getHeader("Connection");
        if ("close".equalsIgnoreCase(connection)) {
            return false;
        }
        if (message.getProtocolVersion().isKeepAliveDefault()) {
            return !"close".equalsIgnoreCase(connection);
        }
        return "keep-alive".equalsIgnoreCase(connection);
    }

    public static void setKeepAlive(HttpMessage message, boolean keepAlive) {
        if (message.getProtocolVersion().isKeepAliveDefault()) {
            if (keepAlive) {
                message.removeHeader("Connection");
            } else {
                message.setHeader("Connection", "close");
            }
        } else if (keepAlive) {
            message.setHeader("Connection", "keep-alive");
        } else {
            message.removeHeader("Connection");
        }
    }

    public static String getHeader(HttpMessage message, String name) {
        return message.getHeader(name);
    }

    public static String getHeader(HttpMessage message, String name, String defaultValue) {
        String value = message.getHeader(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void setHeader(HttpMessage message, String name, Object value) {
        message.setHeader(name, value);
    }

    public static void setHeader(HttpMessage message, String name, Iterable<?> values) {
        message.setHeader(name, values);
    }

    public static void addHeader(HttpMessage message, String name, Object value) {
        message.addHeader(name, value);
    }

    public static int getIntHeader(HttpMessage message, String name) {
        String value = HttpHeaders.getHeader(message, name);
        if (value == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(value);
    }

    public static int getIntHeader(HttpMessage message, String name, int defaultValue) {
        String value = HttpHeaders.getHeader(message, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void setIntHeader(HttpMessage message, String name, int value) {
        message.setHeader(name, value);
    }

    public static void setIntHeader(HttpMessage message, String name, Iterable<Integer> values) {
        message.setHeader(name, values);
    }

    public static void addIntHeader(HttpMessage message, String name, int value) {
        message.addHeader(name, value);
    }

    public static long getContentLength(HttpMessage message) {
        return HttpHeaders.getContentLength(message, 0L);
    }

    public static long getContentLength(HttpMessage message, long defaultValue) {
        HttpResponse res;
        String contentLength = message.getHeader("Content-Length");
        if (contentLength != null) {
            return Long.parseLong(contentLength);
        }
        if (message instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)message;
            if (HttpMethod.GET.equals(req.getMethod()) && req.containsHeader("Sec-WebSocket-Key1") && req.containsHeader("Sec-WebSocket-Key2")) {
                return 8L;
            }
        } else if (message instanceof HttpResponse && (res = (HttpResponse)message).getStatus().getCode() == 101 && res.containsHeader("Sec-WebSocket-Origin") && res.containsHeader("Sec-WebSocket-Location")) {
            return 16L;
        }
        return defaultValue;
    }

    public static void setContentLength(HttpMessage message, long length) {
        message.setHeader("Content-Length", length);
    }

    public static String getHost(HttpMessage message) {
        return message.getHeader("Host");
    }

    public static String getHost(HttpMessage message, String defaultValue) {
        return HttpHeaders.getHeader(message, "Host", defaultValue);
    }

    public static void setHost(HttpMessage message, String value) {
        message.setHeader("Host", value);
    }

    public static boolean is100ContinueExpected(HttpMessage message) {
        if (!(message instanceof HttpRequest)) {
            return false;
        }
        if (message.getProtocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return false;
        }
        String value = message.getHeader("Expect");
        if (value == null) {
            return false;
        }
        if ("100-continue".equalsIgnoreCase(value)) {
            return true;
        }
        for (String v : message.getHeaders("Expect")) {
            if (!"100-continue".equalsIgnoreCase(v)) continue;
            return true;
        }
        return false;
    }

    public static void set100ContinueExpected(HttpMessage message) {
        HttpHeaders.set100ContinueExpected(message, true);
    }

    public static void set100ContinueExpected(HttpMessage message, boolean set) {
        if (set) {
            message.setHeader("Expect", "100-continue");
        } else {
            message.removeHeader("Expect");
        }
    }

    private static int hash(String name) {
        int h = 0;
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static boolean eq(String name1, String name2) {
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i))) continue;
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    private static int index(int hash) {
        return hash % 17;
    }

    HttpHeaders() {
        this.head.before = this.head.after = (this.head = new HeaderEntry(-1, null, null));
    }

    void validateHeaderName(String name) {
        HttpCodecUtil.validateHeaderName(name);
    }

    void addHeader(String name, Object value) {
        this.validateHeaderName(name);
        String strVal = HttpHeaders.toString(value);
        HttpCodecUtil.validateHeaderValue(strVal);
        int h = HttpHeaders.hash(name);
        int i = HttpHeaders.index(h);
        this.addHeader0(h, i, name, strVal);
    }

    private void addHeader0(int h, int i, String name, String value) {
        HeaderEntry newEntry;
        HeaderEntry e = this.entries[i];
        this.entries[i] = newEntry = new HeaderEntry(h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    void removeHeader(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = HttpHeaders.hash(name);
        int i = HttpHeaders.index(h);
        this.removeHeader0(h, i, name);
    }

    private void removeHeader0(int h, int i, String name) {
        HeaderEntry next;
        HeaderEntry e = this.entries[i];
        if (e == null) {
            return;
        }
        while (e.hash == h && HttpHeaders.eq(name, e.key)) {
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[i] = next;
                e = next;
                continue;
            }
            this.entries[i] = null;
            return;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && HttpHeaders.eq(name, next.key)) {
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
    }

    void setHeader(String name, Object value) {
        this.validateHeaderName(name);
        String strVal = HttpHeaders.toString(value);
        HttpCodecUtil.validateHeaderValue(strVal);
        int h = HttpHeaders.hash(name);
        int i = HttpHeaders.index(h);
        this.removeHeader0(h, i, name);
        this.addHeader0(h, i, name, strVal);
    }

    void setHeader(String name, Iterable<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.validateHeaderName(name);
        int h = HttpHeaders.hash(name);
        int i = HttpHeaders.index(h);
        this.removeHeader0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            String strVal = HttpHeaders.toString(v);
            HttpCodecUtil.validateHeaderValue(strVal);
            this.addHeader0(h, i, name, strVal);
        }
    }

    void clearHeaders() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
    }

    String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = HttpHeaders.hash(name);
        int i = HttpHeaders.index(h);
        HeaderEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && HttpHeaders.eq(name, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    List<String> getHeaders(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        LinkedList<String> values = new LinkedList<String>();
        int h = HttpHeaders.hash(name);
        int i = HttpHeaders.index(h);
        HeaderEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && HttpHeaders.eq(name, e.key)) {
                values.addFirst(e.value);
            }
            e = e.next;
        }
        return values;
    }

    List<Map.Entry<String, String>> getHeaders() {
        LinkedList<Map.Entry<String, String>> all = new LinkedList<Map.Entry<String, String>>();
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            all.add(e);
            e = e.after;
        }
        return all;
    }

    boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    Set<String> getHeaderNames() {
        TreeSet<String> names = new TreeSet<String>(CaseIgnoringComparator.INSTANCE);
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.key);
            e = e.after;
        }
        return names;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HeaderEntry
    implements Map.Entry<String, String> {
        final int hash;
        final String key;
        String value;
        HeaderEntry next;
        HeaderEntry before;
        HeaderEntry after;

        HeaderEntry(int hash, String key, String value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(HeaderEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            HttpCodecUtil.validateHeaderValue(value);
            String oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.key + '=' + this.value;
        }
    }

    public static final class Values {
        public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String BASE64 = "base64";
        public static final String BINARY = "binary";
        public static final String BOUNDARY = "boundary";
        public static final String BYTES = "bytes";
        public static final String CHARSET = "charset";
        public static final String CHUNKED = "chunked";
        public static final String CLOSE = "close";
        public static final String COMPRESS = "compress";
        public static final String CONTINUE = "100-continue";
        public static final String DEFLATE = "deflate";
        public static final String GZIP = "gzip";
        public static final String IDENTITY = "identity";
        public static final String KEEP_ALIVE = "keep-alive";
        public static final String MAX_AGE = "max-age";
        public static final String MAX_STALE = "max-stale";
        public static final String MIN_FRESH = "min-fresh";
        public static final String MULTIPART_FORM_DATA = "multipart/form-data";
        public static final String MUST_REVALIDATE = "must-revalidate";
        public static final String NO_CACHE = "no-cache";
        public static final String NO_STORE = "no-store";
        public static final String NO_TRANSFORM = "no-transform";
        public static final String NONE = "none";
        public static final String ONLY_IF_CACHED = "only-if-cached";
        public static final String PRIVATE = "private";
        public static final String PROXY_REVALIDATE = "proxy-revalidate";
        public static final String PUBLIC = "public";
        public static final String QUOTED_PRINTABLE = "quoted-printable";
        public static final String S_MAXAGE = "s-maxage";
        public static final String TRAILERS = "trailers";
        public static final String UPGRADE = "Upgrade";
        public static final String WEBSOCKET = "WebSocket";

        private Values() {
        }
    }

    public static final class Names {
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String ACCEPT_PATCH = "Accept-Patch";
        public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
        public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
        public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
        public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
        public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
        public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
        public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
        public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
        public static final String AGE = "Age";
        public static final String ALLOW = "Allow";
        public static final String AUTHORIZATION = "Authorization";
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONNECTION = "Connection";
        public static final String CONTENT_BASE = "Content-Base";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String COOKIE = "Cookie";
        public static final String DATE = "Date";
        public static final String ETAG = "ETag";
        public static final String EXPECT = "Expect";
        public static final String EXPIRES = "Expires";
        public static final String FROM = "From";
        public static final String HOST = "Host";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_RANGE = "If-Range";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LOCATION = "Location";
        public static final String MAX_FORWARDS = "Max-Forwards";
        public static final String ORIGIN = "Origin";
        public static final String PRAGMA = "Pragma";
        public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
        public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
        public static final String RANGE = "Range";
        public static final String REFERER = "Referer";
        public static final String RETRY_AFTER = "Retry-After";
        public static final String SEC_WEBSOCKET_KEY1 = "Sec-WebSocket-Key1";
        public static final String SEC_WEBSOCKET_KEY2 = "Sec-WebSocket-Key2";
        public static final String SEC_WEBSOCKET_LOCATION = "Sec-WebSocket-Location";
        public static final String SEC_WEBSOCKET_ORIGIN = "Sec-WebSocket-Origin";
        public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
        public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
        public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
        public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
        public static final String SERVER = "Server";
        public static final String SET_COOKIE = "Set-Cookie";
        public static final String SET_COOKIE2 = "Set-Cookie2";
        public static final String TE = "TE";
        public static final String TRAILER = "Trailer";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String UPGRADE = "Upgrade";
        public static final String USER_AGENT = "User-Agent";
        public static final String VARY = "Vary";
        public static final String VIA = "Via";
        public static final String WARNING = "Warning";
        public static final String WEBSOCKET_LOCATION = "WebSocket-Location";
        public static final String WEBSOCKET_ORIGIN = "WebSocket-Origin";
        public static final String WEBSOCKET_PROTOCOL = "WebSocket-Protocol";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";

        private Names() {
        }
    }
}

