/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.apache.flink.hadoop.shaded.org.jboss.netty.handler.codec.http.HttpHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpChunkTrailer
implements HttpChunkTrailer {
    private final HttpHeaders headers = new HttpHeaders(){

        void validateHeaderName(String name) {
            super.validateHeaderName(name);
            if (name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Trailer")) {
                throw new IllegalArgumentException("prohibited trailing header: " + name);
            }
        }
    };

    @Override
    public boolean isLast() {
        return true;
    }

    @Override
    public void addHeader(String name, Object value) {
        this.headers.addHeader(name, value);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.headers.setHeader(name, value);
    }

    @Override
    public void setHeader(String name, Iterable<?> values) {
        this.headers.setHeader(name, values);
    }

    @Override
    public void removeHeader(String name) {
        this.headers.removeHeader(name);
    }

    @Override
    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    @Override
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    @Override
    public ChannelBuffer getContent() {
        return ChannelBuffers.EMPTY_BUFFER;
    }

    @Override
    public void setContent(ChannelBuffer content) {
        throw new IllegalStateException("read-only");
    }
}

