/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.apache.curator.framework.recipes.atomic;

import org.apache.flink.hadoop.shaded.org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.flink.hadoop.shaded.org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.flink.hadoop.shaded.org.apache.curator.framework.recipes.atomic.MutableAtomicValue;

public class CachedAtomicLong {
    private final DistributedAtomicLong number;
    private final long cacheFactor;
    private AtomicValue<Long> currentValue = null;
    private int currentIndex = 0;

    public CachedAtomicLong(DistributedAtomicLong number, int cacheFactor) {
        this.number = number;
        this.cacheFactor = cacheFactor;
    }

    public AtomicValue<Long> next() throws Exception {
        MutableAtomicValue<Long> result = new MutableAtomicValue<Long>(0L, 0L);
        if (this.currentValue == null) {
            this.currentValue = this.number.add(this.cacheFactor);
            if (!this.currentValue.succeeded()) {
                this.currentValue = null;
                result.succeeded = false;
                return result;
            }
            this.currentIndex = 0;
        }
        result.succeeded = true;
        result.preValue = this.currentValue.preValue() + (long)this.currentIndex;
        result.postValue = (Long)result.preValue + 1L;
        if ((long)(++this.currentIndex) >= this.cacheFactor) {
            this.currentValue = null;
        }
        return result;
    }
}

