/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.apache.curator.ensemble.exhibitor;

import java.util.Collection;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableList;

public class Exhibitors {
    private final Collection<String> hostnames;
    private final int restPort;
    private final BackupConnectionStringProvider backupConnectionStringProvider;

    public Exhibitors(Collection<String> hostnames, int restPort, BackupConnectionStringProvider backupConnectionStringProvider) {
        this.backupConnectionStringProvider = Preconditions.checkNotNull(backupConnectionStringProvider, "backupConnectionStringProvider cannot be null");
        this.hostnames = ImmutableList.copyOf(hostnames);
        this.restPort = restPort;
    }

    public Collection<String> getHostnames() {
        return this.hostnames;
    }

    public int getRestPort() {
        return this.restPort;
    }

    public String getBackupConnectionString() throws Exception {
        return this.backupConnectionStringProvider.getBackupConnectionString();
    }

    public static interface BackupConnectionStringProvider {
        public String getBackupConnectionString() throws Exception;
    }
}

