/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;

@InterfaceAudience.LimitedPrivate(value={"yarn", "mapreduce"})
public class AggregatedLogDeletionService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AggregatedLogDeletionService.class);
    private Timer timer = null;
    private long checkIntervalMsecs;
    private LogDeletionTask task;

    private static void logIOException(String comment, IOException e) {
        if (e instanceof AccessControlException) {
            String message = e.getMessage();
            message = message.split("\n")[0];
            LOG.warn((Object)(comment + " " + message));
        } else {
            LOG.error((Object)comment, (Throwable)e);
        }
    }

    public AggregatedLogDeletionService() {
        super(AggregatedLogDeletionService.class.getName());
    }

    @Override
    protected void serviceStart() throws Exception {
        this.scheduleLogDeletionTask();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.stopRMClient();
        this.stopTimer();
        super.serviceStop();
    }

    private void setLogAggCheckIntervalMsecs(long retentionSecs) {
        Configuration conf = this.getConfig();
        this.checkIntervalMsecs = 1000L * conf.getLong("yarn.log-aggregation.retain-check-interval-seconds", -1L);
        if (this.checkIntervalMsecs <= 0L) {
            this.checkIntervalMsecs = retentionSecs * 1000L / 10L;
        }
    }

    public void refreshLogRetentionSettings() throws IOException {
        if (this.getServiceState() == Service.STATE.STARTED) {
            Configuration conf = this.createConf();
            this.setConfig(conf);
            this.stopRMClient();
            this.stopTimer();
            this.scheduleLogDeletionTask();
        } else {
            LOG.warn((Object)"Failed to execute refreshLogRetentionSettings : Aggregated Log Deletion Service is not started");
        }
    }

    private void scheduleLogDeletionTask() throws IOException {
        Configuration conf = this.getConfig();
        if (!conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return;
        }
        long retentionSecs = conf.getLong("yarn.log-aggregation.retain-seconds", -1L);
        if (retentionSecs < 0L) {
            LOG.info((Object)("Log Aggregation deletion is disabled because retention is too small (" + retentionSecs + ")"));
            return;
        }
        this.setLogAggCheckIntervalMsecs(retentionSecs);
        this.task = new LogDeletionTask(conf, retentionSecs, this.creatRMClient());
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this.task, 0L, this.checkIntervalMsecs);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public long getCheckIntervalMsecs() {
        return this.checkIntervalMsecs;
    }

    protected Configuration createConf() {
        return new Configuration();
    }

    @VisibleForTesting
    protected ApplicationClientProtocol creatRMClient() throws IOException {
        return ClientRMProxy.createRMProxy(this.getConfig(), ApplicationClientProtocol.class);
    }

    @VisibleForTesting
    protected void stopRMClient() {
        if (this.task != null && this.task.getRMClient() != null) {
            RPC.stopProxy(this.task.getRMClient());
        }
    }

    static class LogDeletionTask
    extends TimerTask {
        private Configuration conf;
        private long retentionMillis;
        private String suffix = null;
        private Path remoteRootLogDir = null;
        private ApplicationClientProtocol rmClient = null;

        public LogDeletionTask(Configuration conf, long retentionSecs, ApplicationClientProtocol rmClient) {
            this.conf = conf;
            this.retentionMillis = retentionSecs * 1000L;
            this.suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(conf);
            this.remoteRootLogDir = new Path(conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
            this.rmClient = rmClient;
        }

        @Override
        public void run() {
            long cutoffMillis = System.currentTimeMillis() - this.retentionMillis;
            LOG.info((Object)"aggregated log deletion started.");
            try {
                FileSystem fs = this.remoteRootLogDir.getFileSystem(this.conf);
                for (FileStatus userDir : fs.listStatus(this.remoteRootLogDir)) {
                    if (!userDir.isDirectory()) continue;
                    Path userDirPath = new Path(userDir.getPath(), this.suffix);
                    LogDeletionTask.deleteOldLogDirsFrom(userDirPath, cutoffMillis, fs, this.rmClient);
                }
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logIOException("Error reading root log dir this deletion attempt is being aborted", e);
            }
            LOG.info((Object)"aggregated log deletion finished.");
        }

        private static void deleteOldLogDirsFrom(Path dir, long cutoffMillis, FileSystem fs, ApplicationClientProtocol rmClient) {
            try {
                for (FileStatus appDir : fs.listStatus(dir)) {
                    if (!appDir.isDirectory() || appDir.getModificationTime() >= cutoffMillis) continue;
                    boolean appTerminated = LogDeletionTask.isApplicationTerminated(ApplicationId.fromString(appDir.getPath().getName()), rmClient);
                    if (appTerminated && LogDeletionTask.shouldDeleteLogDir(appDir, cutoffMillis, fs)) {
                        try {
                            LOG.info((Object)("Deleting aggregated logs in " + appDir.getPath()));
                            fs.delete(appDir.getPath(), true);
                        }
                        catch (IOException e) {
                            AggregatedLogDeletionService.logIOException("Could not delete " + appDir.getPath(), e);
                        }
                        continue;
                    }
                    if (appTerminated) continue;
                    try {
                        for (FileStatus node : fs.listStatus(appDir.getPath())) {
                            if (node.getModificationTime() >= cutoffMillis) continue;
                            try {
                                fs.delete(node.getPath(), true);
                            }
                            catch (IOException ex) {
                                AggregatedLogDeletionService.logIOException("Could not delete " + appDir.getPath(), ex);
                            }
                        }
                    }
                    catch (IOException e) {
                        AggregatedLogDeletionService.logIOException("Error reading the contents of " + appDir.getPath(), e);
                    }
                }
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logIOException("Could not read the contents of " + dir, e);
            }
        }

        private static boolean shouldDeleteLogDir(FileStatus dir, long cutoffMillis, FileSystem fs) {
            boolean shouldDelete = true;
            try {
                for (FileStatus node : fs.listStatus(dir.getPath())) {
                    if (node.getModificationTime() < cutoffMillis) continue;
                    shouldDelete = false;
                    break;
                }
            }
            catch (IOException e) {
                AggregatedLogDeletionService.logIOException("Error reading the contents of " + dir.getPath(), e);
                shouldDelete = false;
            }
            return shouldDelete;
        }

        private static boolean isApplicationTerminated(ApplicationId appId, ApplicationClientProtocol rmClient) throws IOException {
            ApplicationReport appReport = null;
            try {
                appReport = rmClient.getApplicationReport(GetApplicationReportRequest.newInstance(appId)).getApplicationReport();
            }
            catch (ApplicationNotFoundException e) {
                return true;
            }
            catch (YarnException e) {
                throw new IOException(e);
            }
            YarnApplicationState currentState = appReport.getYarnApplicationState();
            return currentState == YarnApplicationState.FAILED || currentState == YarnApplicationState.KILLED || currentState == YarnApplicationState.FINISHED;
        }

        public ApplicationClientProtocol getRMClient() {
            return this.rmClient;
        }
    }
}

