/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Supplier;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.impl.AMRMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AMRMClientAsync<T extends AMRMClient.ContainerRequest>
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(AMRMClientAsync.class);
    protected final AMRMClient<T> client;
    protected final CallbackHandler handler;
    protected final AtomicInteger heartbeatIntervalMs = new AtomicInteger();

    public static <T extends AMRMClient.ContainerRequest> AMRMClientAsync<T> createAMRMClientAsync(int intervalMs, AbstractCallbackHandler callbackHandler) {
        return new AMRMClientAsyncImpl(intervalMs, callbackHandler);
    }

    public static <T extends AMRMClient.ContainerRequest> AMRMClientAsync<T> createAMRMClientAsync(AMRMClient<T> client, int intervalMs, AbstractCallbackHandler callbackHandler) {
        return new AMRMClientAsyncImpl<T>(client, intervalMs, callbackHandler);
    }

    protected AMRMClientAsync(int intervalMs, AbstractCallbackHandler callbackHandler) {
        this(new AMRMClientImpl(), intervalMs, callbackHandler);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected AMRMClientAsync(AMRMClient<T> client, int intervalMs, AbstractCallbackHandler callbackHandler) {
        super(AMRMClientAsync.class.getName());
        this.client = client;
        this.heartbeatIntervalMs.set(intervalMs);
        this.handler = callbackHandler;
    }

    @Deprecated
    public static <T extends AMRMClient.ContainerRequest> AMRMClientAsync<T> createAMRMClientAsync(int intervalMs, CallbackHandler callbackHandler) {
        return new AMRMClientAsyncImpl(intervalMs, callbackHandler);
    }

    @Deprecated
    public static <T extends AMRMClient.ContainerRequest> AMRMClientAsync<T> createAMRMClientAsync(AMRMClient<T> client, int intervalMs, CallbackHandler callbackHandler) {
        return new AMRMClientAsyncImpl<T>(client, intervalMs, callbackHandler);
    }

    @Deprecated
    protected AMRMClientAsync(int intervalMs, CallbackHandler callbackHandler) {
        this(new AMRMClientImpl(), intervalMs, callbackHandler);
    }

    @InterfaceAudience.Private
    @Deprecated
    @VisibleForTesting
    protected AMRMClientAsync(AMRMClient<T> client, int intervalMs, CallbackHandler callbackHandler) {
        super(AMRMClientAsync.class.getName());
        this.client = client;
        this.heartbeatIntervalMs.set(intervalMs);
        this.handler = callbackHandler;
    }

    public void setHeartbeatInterval(int interval) {
        this.heartbeatIntervalMs.set(interval);
    }

    public abstract List<? extends Collection<T>> getMatchingRequests(Priority var1, String var2, Resource var3);

    public abstract RegisterApplicationMasterResponse registerApplicationMaster(String var1, int var2, String var3) throws YarnException, IOException;

    public abstract void unregisterApplicationMaster(FinalApplicationStatus var1, String var2, String var3) throws YarnException, IOException;

    public abstract void addContainerRequest(T var1);

    public abstract void removeContainerRequest(T var1);

    public abstract void requestContainerResourceChange(Container var1, Resource var2);

    public abstract void releaseAssignedContainer(ContainerId var1);

    public abstract Resource getAvailableResources();

    public abstract int getClusterNodeCount();

    public abstract void updateBlacklist(List<String> var1, List<String> var2);

    public void waitFor(Supplier<Boolean> check) throws InterruptedException {
        this.waitFor(check, 1000);
    }

    public void waitFor(Supplier<Boolean> check, int checkEveryMillis) throws InterruptedException {
        this.waitFor(check, checkEveryMillis, 1);
    }

    public void waitFor(Supplier<Boolean> check, int checkEveryMillis, int logInterval) throws InterruptedException {
        Preconditions.checkNotNull(check, "check should not be null");
        Preconditions.checkArgument(checkEveryMillis >= 0, "checkEveryMillis should be positive value");
        Preconditions.checkArgument(logInterval >= 0, "logInterval should be positive value");
        int loggingCounter = logInterval;
        while (true) {
            boolean result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Check the condition for main loop.");
            }
            if (result = check.get().booleanValue()) {
                LOG.info((Object)"Exits the main loop.");
                return;
            }
            if (--loggingCounter <= 0) {
                LOG.info((Object)"Waiting in main loop.");
                loggingCounter = logInterval;
            }
            Thread.sleep(checkEveryMillis);
        }
    }

    @Deprecated
    public static interface CallbackHandler {
        public void onContainersCompleted(List<ContainerStatus> var1);

        public void onContainersAllocated(List<Container> var1);

        public void onShutdownRequest();

        public void onNodesUpdated(List<NodeReport> var1);

        public float getProgress();

        public void onError(Throwable var1);
    }

    public static abstract class AbstractCallbackHandler
    implements CallbackHandler {
        @Override
        public abstract void onContainersCompleted(List<ContainerStatus> var1);

        @Override
        public abstract void onContainersAllocated(List<Container> var1);

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public abstract void onContainersUpdated(List<UpdatedContainer> var1);

        @Override
        public abstract void onShutdownRequest();

        @Override
        public abstract void onNodesUpdated(List<NodeReport> var1);

        @Override
        public abstract float getProgress();

        @Override
        public abstract void onError(Throwable var1);
    }
}

