/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.util.concurrent.AbstractFuture;
import org.apache.hadoop.util.concurrent.AsyncGet;

public class AsyncGetFuture<T, E extends Throwable>
extends AbstractFuture<T> {
    public static final Log LOG = LogFactory.getLog(AsyncGetFuture.class);
    private final AtomicBoolean called = new AtomicBoolean(false);
    private final AsyncGet<T, E> asyncGet;

    public AsyncGetFuture(AsyncGet<T, E> asyncGet) {
        this.asyncGet = asyncGet;
    }

    private void callAsyncGet(long timeout, TimeUnit unit) {
        if (!this.isCancelled() && this.called.compareAndSet(false, true)) {
            try {
                this.set(this.asyncGet.get(timeout, unit));
            }
            catch (TimeoutException te) {
                LOG.trace((Object)"TRACE", (Throwable)te);
                this.called.compareAndSet(true, false);
            }
            catch (Throwable e) {
                LOG.trace((Object)"TRACE", e);
                this.setException(e);
            }
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.callAsyncGet(-1L, TimeUnit.MILLISECONDS);
        return (T)super.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        this.callAsyncGet(timeout, unit);
        return (T)super.get(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isDone() {
        this.callAsyncGet(0L, TimeUnit.MILLISECONDS);
        return super.isDone();
    }
}

