/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.Iterator;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.com.google.common.io.Files;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.Time;

class BlockPoolSlice {
    static final Log LOG = LogFactory.getLog(BlockPoolSlice.class);
    private final String bpid;
    private final FsVolumeImpl volume;
    private final File currentDir;
    private final File finalizedDir;
    private final File lazypersistDir;
    private final File rbwDir;
    private final File tmpDir;
    private final int ioFileBufferSize;
    private static final String DU_CACHE_FILE = "dfsUsed";
    private volatile boolean dfsUsedSaved = false;
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final boolean deleteDuplicateReplicas;
    private static final String REPLICA_CACHE_FILE = "replicas";
    private final long replicaCacheExpiry = 300000L;
    private AtomicLong numOfBlocks = new AtomicLong();
    private final int maxDataLength;
    private final GetSpaceUsed dfsUsage;

    BlockPoolSlice(String bpid, FsVolumeImpl volume, File bpDir, Configuration conf) throws IOException {
        this.bpid = bpid;
        this.volume = volume;
        this.currentDir = new File(bpDir, "current");
        this.finalizedDir = new File(this.currentDir, "finalized");
        this.lazypersistDir = new File(this.currentDir, "lazypersist");
        if (!this.finalizedDir.exists() && !this.finalizedDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + this.finalizedDir);
        }
        this.ioFileBufferSize = DFSUtilClient.getIoFileBufferSize(conf);
        this.deleteDuplicateReplicas = conf.getBoolean("dfs.datanode.duplicate.replica.deletion", true);
        this.maxDataLength = conf.getInt("ipc.maximum.data.length", 0x4000000);
        this.tmpDir = new File(bpDir, "tmp");
        if (this.tmpDir.exists()) {
            FileUtil.fullyDelete(this.tmpDir);
        }
        this.rbwDir = new File(this.currentDir, "rbw");
        boolean supportAppends = conf.getBoolean("dfs.support.append", true);
        if (this.rbwDir.exists() && !supportAppends) {
            FileUtil.fullyDelete(this.rbwDir);
        }
        if (!this.rbwDir.mkdirs() && !this.rbwDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.rbwDir.toString());
        }
        if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
        }
        this.dfsUsage = new GetSpaceUsed.Builder().setPath(bpDir).setConf(conf).setInitialUsed(this.loadDfsUsed()).build();
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                if (!BlockPoolSlice.this.dfsUsedSaved) {
                    BlockPoolSlice.this.saveDfsUsed();
                }
            }
        }, 30);
    }

    File getDirectory() {
        return this.currentDir.getParentFile();
    }

    File getFinalizedDir() {
        return this.finalizedDir;
    }

    File getLazypersistDir() {
        return this.lazypersistDir;
    }

    File getRbwDir() {
        return this.rbwDir;
    }

    File getTmpDir() {
        return this.tmpDir;
    }

    void decDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(-value);
        }
    }

    long getDfsUsed() throws IOException {
        return this.dfsUsage.getUsed();
    }

    void incDfsUsed(long value) {
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadDfsUsed() {
        Scanner sc;
        try {
            sc = new Scanner(new File(this.currentDir, DU_CACHE_FILE), "UTF-8");
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        try {
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long cachedDfsUsed = sc.nextLong();
            if (!sc.hasNextLong()) {
                long l = -1L;
                return l;
            }
            long mtime = sc.nextLong();
            if (mtime > 0L && Time.now() - mtime < 600000L) {
                FsDatasetImpl.LOG.info((Object)("Cached dfsUsed found for " + this.currentDir + ": " + cachedDfsUsed));
                long l = cachedDfsUsed;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            sc.close();
        }
    }

    void saveDfsUsed() {
        File outFile = new File(this.currentDir, DU_CACHE_FILE);
        if (outFile.exists() && !outFile.delete()) {
            FsDatasetImpl.LOG.warn((Object)("Failed to delete old dfsUsed file in " + outFile.getParent()));
        }
        try {
            long used = this.getDfsUsed();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");){
                out.write(Long.toString(used) + " " + Long.toString(Time.now()));
                ((Writer)out).flush();
            }
        }
        catch (IOException ioe) {
            FsDatasetImpl.LOG.warn((Object)("Failed to write dfsUsed to " + outFile), (Throwable)ioe);
        }
    }

    File createTmpFile(Block b) throws IOException {
        File f = new File(this.tmpDir, b.getBlockName());
        File tmpFile = DatanodeUtil.createTmpFile(b, f);
        this.incrNumBlocks();
        return tmpFile;
    }

    File createRbwFile(Block b) throws IOException {
        File f = new File(this.rbwDir, b.getBlockName());
        File rbwFile = DatanodeUtil.createTmpFile(b, f);
        this.incrNumBlocks();
        return rbwFile;
    }

    File addBlock(Block b, File f) throws IOException {
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, b.getBlockId());
        if (!blockDir.exists() && !blockDir.mkdirs()) {
            throw new IOException("Failed to mkdirs " + blockDir);
        }
        File blockFile = FsDatasetImpl.moveBlockFiles(b, f, blockDir);
        File metaFile = FsDatasetUtil.getMetaFile(blockFile, b.getGenerationStamp());
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            ((CachingGetSpaceUsed)this.dfsUsage).incDfsUsed(b.getNumBytes() + metaFile.length());
        }
        return blockFile;
    }

    File activateSavedReplica(Block b, File metaFile, File blockFile) throws IOException {
        File blockDir = DatanodeUtil.idToBlockDir(this.finalizedDir, b.getBlockId());
        File targetBlockFile = new File(blockDir, blockFile.getName());
        File targetMetaFile = new File(blockDir, metaFile.getName());
        FileUtils.moveFile((File)blockFile, (File)targetBlockFile);
        FsDatasetImpl.LOG.info((Object)("Moved " + blockFile + " to " + targetBlockFile));
        FileUtils.moveFile((File)metaFile, (File)targetMetaFile);
        FsDatasetImpl.LOG.info((Object)("Moved " + metaFile + " to " + targetMetaFile));
        return targetBlockFile;
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        DiskChecker.checkDir(this.finalizedDir);
        DiskChecker.checkDir(this.tmpDir);
        DiskChecker.checkDir(this.rbwDir);
    }

    void getVolumeMap(ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap) throws IOException {
        boolean success;
        if (this.lazypersistDir.exists()) {
            int numRecovered = this.moveLazyPersistReplicasToFinalized(this.lazypersistDir);
            FsDatasetImpl.LOG.info((Object)("Recovered " + numRecovered + " replicas from " + this.lazypersistDir));
        }
        if (!(success = this.readReplicasFromCache(volumeMap, lazyWriteReplicaMap))) {
            this.addToReplicasMap(volumeMap, this.finalizedDir, lazyWriteReplicaMap, true);
            this.addToReplicasMap(volumeMap, this.rbwDir, lazyWriteReplicaMap, false);
        }
    }

    File recoverTempUnlinkedBlock(File unlinkedTmp) throws IOException {
        File blockFile = FsDatasetUtil.getOrigFile(unlinkedTmp);
        if (blockFile.exists()) {
            if (!unlinkedTmp.delete()) {
                throw new IOException("Unable to cleanup unlinked tmp file " + unlinkedTmp);
            }
            return null;
        }
        if (!unlinkedTmp.renameTo(blockFile)) {
            throw new IOException("Unable to rename unlinked tmp file " + unlinkedTmp);
        }
        return blockFile;
    }

    private int moveLazyPersistReplicasToFinalized(File source) throws IOException {
        File[] files = FileUtil.listFiles(source);
        int numRecovered = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                numRecovered += this.moveLazyPersistReplicasToFinalized(file);
            }
            if (!Block.isMetaFilename(file.getName())) continue;
            File metaFile = file;
            File blockFile = Block.metaToBlockFile(metaFile);
            long blockId = Block.filename2id(blockFile.getName());
            File targetDir = DatanodeUtil.idToBlockDir(this.finalizedDir, blockId);
            if (!blockFile.exists()) continue;
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                LOG.warn((Object)("Failed to mkdirs " + targetDir));
                continue;
            }
            File targetMetaFile = new File(targetDir, metaFile.getName());
            try {
                NativeIO.renameTo(metaFile, targetMetaFile);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to move meta file from " + metaFile + " to " + targetMetaFile), (Throwable)e);
                continue;
            }
            File targetBlockFile = new File(targetDir, blockFile.getName());
            try {
                NativeIO.renameTo(blockFile, targetBlockFile);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to move block file from " + blockFile + " to " + targetBlockFile), (Throwable)e);
                continue;
            }
            if (targetBlockFile.exists() && targetMetaFile.exists()) {
                ++numRecovered;
                continue;
            }
            LOG.warn((Object)("Failed to move " + blockFile + " to " + targetDir));
        }
        FileUtil.fullyDelete(source);
        return numRecovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplicaToReplicasMap(Block block, ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap, boolean isFinalized) throws IOException {
        ReplicaInfo newReplica = null;
        long blockId = block.getBlockId();
        long genStamp = block.getGenerationStamp();
        if (isFinalized) {
            newReplica = new FinalizedReplica(blockId, block.getNumBytes(), genStamp, this.volume, DatanodeUtil.idToBlockDir(this.finalizedDir, blockId));
        } else {
            File file = new File(this.rbwDir, block.getBlockName());
            boolean loadRwr = true;
            File restartMeta = new File(file.getParent() + File.pathSeparator + "." + file.getName() + ".restart");
            try (Scanner sc = null;){
                sc = new Scanner(restartMeta, "UTF-8");
                if (sc.hasNextLong() && sc.nextLong() > Time.now()) {
                    newReplica = new ReplicaBeingWritten(blockId, this.validateIntegrityAndSetLength(file, genStamp), genStamp, this.volume, file.getParentFile(), null, 0L);
                    loadRwr = false;
                }
                sc.close();
                if (!restartMeta.delete()) {
                    FsDatasetImpl.LOG.warn((Object)("Failed to delete restart meta file: " + restartMeta.getPath()));
                }
            }
            if (loadRwr) {
                newReplica = new ReplicaWaitingToBeRecovered(blockId, this.validateIntegrityAndSetLength(file, genStamp), genStamp, this.volume, file.getParentFile());
            }
        }
        ReplicaInfo oldReplica = volumeMap.get(this.bpid, newReplica.getBlockId());
        if (oldReplica == null) {
            volumeMap.add(this.bpid, newReplica);
        } else {
            newReplica = this.resolveDuplicateReplicas(newReplica, oldReplica, volumeMap);
        }
        if (newReplica.getVolume().isTransientStorage()) {
            lazyWriteReplicaMap.addReplica(this.bpid, blockId, (FsVolumeImpl)newReplica.getVolume(), 0L);
        } else {
            lazyWriteReplicaMap.discardReplica(this.bpid, blockId, false);
        }
        if (oldReplica == null) {
            this.incrNumBlocks();
        }
    }

    void addToReplicasMap(ReplicaMap volumeMap, File dir, RamDiskReplicaTracker lazyWriteReplicaMap, boolean isFinalized) throws IOException {
        File[] files;
        for (File file : files = FileUtil.listFiles(dir)) {
            if (file.isDirectory()) {
                this.addToReplicasMap(volumeMap, file, lazyWriteReplicaMap, isFinalized);
            }
            if (isFinalized && FsDatasetUtil.isUnlinkTmpFile(file) && (file = this.recoverTempUnlinkedBlock(file)) == null || !Block.isBlockFilename(file)) continue;
            long genStamp = FsDatasetUtil.getGenerationStampFromFile(files, file);
            long blockId = Block.filename2id(file.getName());
            Block block = new Block(blockId, file.length(), genStamp);
            this.addReplicaToReplicasMap(block, volumeMap, lazyWriteReplicaMap, isFinalized);
        }
    }

    ReplicaInfo resolveDuplicateReplicas(ReplicaInfo replica1, ReplicaInfo replica2, ReplicaMap volumeMap) throws IOException {
        if (!this.deleteDuplicateReplicas) {
            return replica1;
        }
        ReplicaInfo replicaToDelete = BlockPoolSlice.selectReplicaToDelete(replica1, replica2);
        ReplicaInfo replicaToKeep = replicaToDelete != replica1 ? replica1 : replica2;
        volumeMap.add(this.bpid, replicaToKeep);
        if (replicaToDelete != null) {
            this.deleteReplica(replicaToDelete);
        }
        return replicaToKeep;
    }

    @VisibleForTesting
    static ReplicaInfo selectReplicaToDelete(ReplicaInfo replica1, ReplicaInfo replica2) {
        ReplicaInfo replicaToDelete;
        if (replica1.getBlockFile().equals(replica2.getBlockFile())) {
            return null;
        }
        ReplicaInfo replicaToKeep = replica1.getGenerationStamp() != replica2.getGenerationStamp() ? (replica1.getGenerationStamp() > replica2.getGenerationStamp() ? replica1 : replica2) : (replica1.getNumBytes() != replica2.getNumBytes() ? (replica1.getNumBytes() > replica2.getNumBytes() ? replica1 : replica2) : (replica1.getVolume().isTransientStorage() && !replica2.getVolume().isTransientStorage() ? replica2 : replica1));
        ReplicaInfo replicaInfo = replicaToDelete = replicaToKeep == replica1 ? replica2 : replica1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resolveDuplicateReplicas decide to keep " + replicaToKeep + ".  Will try to delete " + replicaToDelete));
        }
        return replicaToDelete;
    }

    private void deleteReplica(ReplicaInfo replicaToDelete) {
        File metaFile;
        File blockFile = replicaToDelete.getBlockFile();
        if (!blockFile.delete()) {
            LOG.warn((Object)("Failed to delete block file " + blockFile));
        }
        if (!(metaFile = replicaToDelete.getMetaFile()).delete()) {
            LOG.warn((Object)("Failed to delete meta file " + metaFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long validateIntegrityAndSetLength(File blockFile, long genStamp) {
        long l;
        FileInputStream blockIn;
        DataInputStream checksumIn;
        block15: {
            long l2;
            block13: {
                checksumIn = null;
                blockIn = null;
                try {
                    int checksumSize;
                    File metaFile = FsDatasetUtil.getMetaFile(blockFile, genStamp);
                    long blockFileLen = blockFile.length();
                    long metaFileLen = metaFile.length();
                    int crcHeaderLen = DataChecksum.getChecksumHeaderSize();
                    if (!blockFile.exists() || blockFileLen == 0L || !metaFile.exists() || metaFileLen < (long)crcHeaderLen) {
                        long l3 = 0L;
                        return l3;
                    }
                    checksumIn = new DataInputStream(new BufferedInputStream(new FileInputStream(metaFile), this.ioFileBufferSize));
                    DataChecksum checksum = BlockMetadataHeader.readDataChecksum(checksumIn, metaFile);
                    int bytesPerChecksum = checksum.getBytesPerChecksum();
                    long numChunks = Math.min((blockFileLen + (long)bytesPerChecksum - 1L) / (long)bytesPerChecksum, (metaFileLen - (long)crcHeaderLen) / (long)(checksumSize = checksum.getChecksumSize()));
                    if (numChunks == 0L) {
                        l2 = 0L;
                        IOUtils.closeStream(checksumIn);
                        break block13;
                    }
                    IOUtils.skipFully(checksumIn, (numChunks - 1L) * (long)checksumSize);
                    blockIn = new FileInputStream(blockFile);
                    long lastChunkStartPos = (numChunks - 1L) * (long)bytesPerChecksum;
                    IOUtils.skipFully(blockIn, lastChunkStartPos);
                    int lastChunkSize = (int)Math.min((long)bytesPerChecksum, blockFileLen - lastChunkStartPos);
                    byte[] buf = new byte[lastChunkSize + checksumSize];
                    checksumIn.readFully(buf, lastChunkSize, checksumSize);
                    IOUtils.readFully(blockIn, buf, 0, lastChunkSize);
                    checksum.update(buf, 0, lastChunkSize);
                    long validFileLength = checksum.compare(buf, lastChunkSize) ? lastChunkStartPos + (long)lastChunkSize : lastChunkStartPos;
                    if (blockFile.length() > validFileLength) {
                        try (RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");){
                            blockRAF.setLength(validFileLength);
                        }
                    }
                    l = validFileLength;
                    IOUtils.closeStream(checksumIn);
                    break block15;
                }
                catch (IOException e) {
                    FsDatasetImpl.LOG.warn((Object)e);
                    long l4 = 0L;
                    return l4;
                }
            }
            IOUtils.closeStream(blockIn);
            return l2;
        }
        IOUtils.closeStream(blockIn);
        return l;
        finally {
            IOUtils.closeStream(checksumIn);
            IOUtils.closeStream(blockIn);
        }
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown(BlockListAsLongs blocksListToPersist) {
        this.saveReplicas(blocksListToPersist);
        this.saveDfsUsed();
        this.dfsUsedSaved = true;
        if (this.dfsUsage instanceof CachingGetSpaceUsed) {
            IOUtils.cleanup(LOG, (CachingGetSpaceUsed)this.dfsUsage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readReplicasFromCache(ReplicaMap volumeMap, RamDiskReplicaTracker lazyWriteReplicaMap) {
        ReplicaMap tmpReplicaMap = new ReplicaMap(new AutoCloseableLock());
        File replicaFile = new File(this.currentDir, REPLICA_CACHE_FILE);
        if (!replicaFile.exists()) {
            LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " doesn't exist "));
            return false;
        }
        long fileLastModifiedTime = replicaFile.lastModified();
        if (System.currentTimeMillis() > fileLastModifiedTime + 300000L) {
            LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " has gone stale"));
            if (!replicaFile.delete()) {
                LOG.info((Object)("Replica Cache file: " + replicaFile.getPath() + " cannot be deleted"));
            }
            return false;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(replicaFile);
            BlockListAsLongs blocksList = BlockListAsLongs.readFrom(inputStream, this.maxDataLength);
            for (BlockListAsLongs.BlockReportReplica replica : blocksList) {
                switch (replica.getState()) {
                    case FINALIZED: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, lazyWriteReplicaMap, true);
                        break;
                    }
                    case RUR: 
                    case RBW: 
                    case RWR: {
                        this.addReplicaToReplicasMap(replica, tmpReplicaMap, lazyWriteReplicaMap, false);
                        break;
                    }
                }
            }
            inputStream.close();
            Iterator<ReplicaInfo> iter = tmpReplicaMap.replicas(this.bpid).iterator();
            while (iter.hasNext()) {
                ReplicaInfo info = iter.next();
                iter.remove();
                volumeMap.add(this.bpid, info);
            }
            LOG.info((Object)("Successfully read replica from cache file : " + replicaFile.getPath()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.info((Object)("Exception occured while reading the replicas cache file: " + replicaFile.getPath()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!replicaFile.delete()) {
                LOG.info((Object)("Failed to delete replica cache file: " + replicaFile.getPath()));
            }
            IOUtils.closeStream(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReplicas(BlockListAsLongs blocksListToPersist) {
        if (blocksListToPersist == null || blocksListToPersist.getNumberOfBlocks() == 0) {
            return;
        }
        File tmpFile = new File(this.currentDir, "replicas.tmp");
        if (tmpFile.exists() && !tmpFile.delete()) {
            LOG.warn((Object)("Failed to delete tmp replicas file in " + tmpFile.getPath()));
            return;
        }
        File replicaCacheFile = new File(this.currentDir, REPLICA_CACHE_FILE);
        if (replicaCacheFile.exists() && !replicaCacheFile.delete()) {
            LOG.warn((Object)("Failed to delete replicas file in " + replicaCacheFile.getPath()));
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tmpFile);
            blocksListToPersist.writeTo(out);
            out.close();
            Files.move(tmpFile, replicaCacheFile);
        }
        catch (Exception e) {
            block10: {
                try {
                    LOG.warn((Object)"Failed to write replicas to cache ", (Throwable)e);
                    if (!replicaCacheFile.exists() || replicaCacheFile.delete()) break block10;
                    LOG.warn((Object)("Failed to delete replicas file: " + replicaCacheFile.getPath()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    if (tmpFile.exists() && !tmpFile.delete()) {
                        LOG.warn((Object)("Failed to delete tmp file in " + tmpFile.getPath()));
                    }
                    throw throwable;
                }
            }
            IOUtils.closeStream(out);
            if (tmpFile.exists() && !tmpFile.delete()) {
                LOG.warn((Object)("Failed to delete tmp file in " + tmpFile.getPath()));
            }
        }
        IOUtils.closeStream(out);
        if (tmpFile.exists() && !tmpFile.delete()) {
            LOG.warn((Object)("Failed to delete tmp file in " + tmpFile.getPath()));
        }
    }

    void incrNumBlocks() {
        this.numOfBlocks.incrementAndGet();
    }

    void decrNumBlocks() {
        this.numOfBlocks.decrementAndGet();
    }

    public long getNumOfBlocks() {
        return this.numOfBlocks.get();
    }
}

