/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.apache.curator.retry;

import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.org.apache.curator.retry.ExponentialBackoffRetry;

public class BoundedExponentialBackoffRetry
extends ExponentialBackoffRetry {
    private final int maxSleepTimeMs;

    public BoundedExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepTimeMs, int maxRetries) {
        super(baseSleepTimeMs, maxRetries);
        this.maxSleepTimeMs = maxSleepTimeMs;
    }

    @VisibleForTesting
    public int getMaxSleepTimeMs() {
        return this.maxSleepTimeMs;
    }

    @Override
    protected int getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return Math.min(this.maxSleepTimeMs, super.getSleepTimeMs(retryCount, elapsedTimeMs));
    }
}

