/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Ticker;
import org.apache.flink.shaded.hadoop2.com.google.common.cache.Cache;
import org.apache.flink.shaded.hadoop2.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.hadoop2.com.google.common.cache.CacheLoader;
import org.apache.flink.shaded.hadoop2.com.google.common.cache.LoadingCache;
import org.apache.flink.shaded.hadoop2.com.google.common.util.concurrent.FutureCallback;
import org.apache.flink.shaded.hadoop2.com.google.common.util.concurrent.Futures;
import org.apache.flink.shaded.hadoop2.com.google.common.util.concurrent.ListenableFuture;
import org.apache.flink.shaded.hadoop2.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.flink.shaded.hadoop2.com.google.common.util.concurrent.MoreExecutors;
import org.apache.flink.shaded.hadoop2.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Timer;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class Groups {
    private static final Log LOG = LogFactory.getLog(Groups.class);
    private final GroupMappingServiceProvider impl;
    private final LoadingCache<String, List<String>> cache;
    private final AtomicReference<Map<String, List<String>>> staticMapRef = new AtomicReference();
    private final long cacheTimeout;
    private final long negativeCacheTimeout;
    private final long warningDeltaMs;
    private final Timer timer;
    private Set<String> negativeCache;
    private final boolean reloadGroupsInBackground;
    private final int reloadGroupsThreadCount;
    private final AtomicLong backgroundRefreshSuccess = new AtomicLong(0L);
    private final AtomicLong backgroundRefreshException = new AtomicLong(0L);
    private final AtomicLong backgroundRefreshQueued = new AtomicLong(0L);
    private final AtomicLong backgroundRefreshRunning = new AtomicLong(0L);
    private static Groups GROUPS = null;

    public Groups(Configuration conf) {
        this(conf, new Timer());
    }

    public Groups(Configuration conf, Timer timer) {
        this.impl = ReflectionUtils.newInstance(conf.getClass("hadoop.security.group.mapping", ShellBasedUnixGroupsMapping.class, GroupMappingServiceProvider.class), conf);
        this.cacheTimeout = conf.getLong("hadoop.security.groups.cache.secs", 300L) * 1000L;
        this.negativeCacheTimeout = conf.getLong("hadoop.security.groups.negative-cache.secs", 30L) * 1000L;
        this.warningDeltaMs = conf.getLong("hadoop.security.groups.cache.warn.after.ms", 5000L);
        this.reloadGroupsInBackground = conf.getBoolean("hadoop.security.groups.cache.background.reload", false);
        this.reloadGroupsThreadCount = conf.getInt("hadoop.security.groups.cache.background.reload.threads", 3);
        this.parseStaticMapping(conf);
        this.timer = timer;
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite(this.cacheTimeout, TimeUnit.MILLISECONDS).ticker(new TimerToTickerAdapter(timer)).expireAfterWrite(10L * this.cacheTimeout, TimeUnit.MILLISECONDS).build(new GroupCacheLoader());
        if (this.negativeCacheTimeout > 0L) {
            Cache tempMap = CacheBuilder.newBuilder().expireAfterWrite(this.negativeCacheTimeout, TimeUnit.MILLISECONDS).ticker(new TimerToTickerAdapter(timer)).build();
            this.negativeCache = Collections.newSetFromMap(tempMap.asMap());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Group mapping impl=" + this.impl.getClass().getName() + "; cacheTimeout=" + this.cacheTimeout + "; warningDeltaMs=" + this.warningDeltaMs));
        }
    }

    @VisibleForTesting
    Set<String> getNegativeCache() {
        return this.negativeCache;
    }

    private void parseStaticMapping(Configuration conf) {
        String staticMapping = conf.get("hadoop.user.group.static.mapping.overrides", "dr.who=;");
        Collection<String> mappings = StringUtils.getStringCollection(staticMapping, ";");
        HashMap<String, List> staticUserToGroupsMap = new HashMap<String, List>();
        for (String users : mappings) {
            Collection<String> userToGroups = StringUtils.getStringCollection(users, "=");
            if (userToGroups.size() < 1 || userToGroups.size() > 2) {
                throw new HadoopIllegalArgumentException("Configuration hadoop.user.group.static.mapping.overrides is invalid");
            }
            String[] userToGroupsArray = userToGroups.toArray(new String[userToGroups.size()]);
            String user = userToGroupsArray[0];
            List groups = Collections.emptyList();
            if (userToGroupsArray.length == 2) {
                groups = (List)StringUtils.getStringCollection(userToGroupsArray[1]);
            }
            staticUserToGroupsMap.put(user, groups);
        }
        this.staticMapRef.set(staticUserToGroupsMap.isEmpty() ? null : staticUserToGroupsMap);
    }

    private boolean isNegativeCacheEnabled() {
        return this.negativeCacheTimeout > 0L;
    }

    private IOException noGroupsForUser(String user) {
        return new IOException("No groups found for user " + user);
    }

    public List<String> getGroups(String user) throws IOException {
        List<String> staticMapping;
        Map<String, List<String>> staticUserToGroupsMap = this.staticMapRef.get();
        if (staticUserToGroupsMap != null && (staticMapping = staticUserToGroupsMap.get(user)) != null) {
            return staticMapping;
        }
        if (this.isNegativeCacheEnabled() && this.negativeCache.contains(user)) {
            throw this.noGroupsForUser(user);
        }
        try {
            return this.cache.get(user);
        }
        catch (ExecutionException e) {
            throw (IOException)e.getCause();
        }
    }

    public long getBackgroundRefreshSuccess() {
        return this.backgroundRefreshSuccess.get();
    }

    public long getBackgroundRefreshException() {
        return this.backgroundRefreshException.get();
    }

    public long getBackgroundRefreshQueued() {
        return this.backgroundRefreshQueued.get();
    }

    public long getBackgroundRefreshRunning() {
        return this.backgroundRefreshRunning.get();
    }

    public void refresh() {
        LOG.info((Object)"clearing userToGroupsMap cache");
        try {
            this.impl.cacheGroupsRefresh();
        }
        catch (IOException e) {
            LOG.warn((Object)"Error refreshing groups cache", (Throwable)e);
        }
        this.cache.invalidateAll();
        if (this.isNegativeCacheEnabled()) {
            this.negativeCache.clear();
        }
    }

    public void cacheGroupsAdd(List<String> groups) {
        try {
            this.impl.cacheGroupsAdd(groups);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error caching groups", (Throwable)e);
        }
    }

    public static Groups getUserToGroupsMappingService() {
        return Groups.getUserToGroupsMappingService(new Configuration());
    }

    public static synchronized Groups getUserToGroupsMappingService(Configuration conf) {
        if (GROUPS == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" Creating new Groups object");
            }
            GROUPS = new Groups(conf);
        }
        return GROUPS;
    }

    @InterfaceAudience.Private
    public static synchronized Groups getUserToGroupsMappingServiceWithLoadedConfiguration(Configuration conf) {
        GROUPS = new Groups(conf);
        return GROUPS;
    }

    private class GroupCacheLoader
    extends CacheLoader<String, List<String>> {
        private ListeningExecutorService executorService;

        GroupCacheLoader() {
            if (Groups.this.reloadGroupsInBackground) {
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Group-Cache-Reload").setDaemon(true).build();
                ThreadPoolExecutor parentExecutor = new ThreadPoolExecutor(Groups.this.reloadGroupsThreadCount, Groups.this.reloadGroupsThreadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
                parentExecutor.allowCoreThreadTimeOut(true);
                this.executorService = MoreExecutors.listeningDecorator(parentExecutor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> load(String user) throws Exception {
            TraceScope scope = null;
            Tracer tracer = Tracer.curThreadTracer();
            if (tracer != null) {
                scope = tracer.newScope("Groups#fetchGroupList");
                scope.addKVAnnotation("user", user);
            }
            List<String> groups = null;
            try {
                groups = this.fetchGroupList(user);
            }
            finally {
                if (scope != null) {
                    scope.close();
                }
            }
            if (groups.isEmpty()) {
                if (Groups.this.isNegativeCacheEnabled()) {
                    Groups.this.negativeCache.add(user);
                }
                throw Groups.this.noGroupsForUser(user);
            }
            return Collections.unmodifiableList(new ArrayList<String>(new LinkedHashSet<String>(groups)));
        }

        @Override
        public ListenableFuture<List<String>> reload(final String key, List<String> oldValue) throws Exception {
            if (!Groups.this.reloadGroupsInBackground) {
                return super.reload(key, oldValue);
            }
            Groups.this.backgroundRefreshQueued.incrementAndGet();
            ListenableFuture<List<String>> listenableFuture = this.executorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    Groups.this.backgroundRefreshQueued.decrementAndGet();
                    Groups.this.backgroundRefreshRunning.incrementAndGet();
                    List<String> results = GroupCacheLoader.this.load(key);
                    return results;
                }
            });
            Futures.addCallback(listenableFuture, new FutureCallback<List<String>>(){

                @Override
                public void onSuccess(List<String> result) {
                    Groups.this.backgroundRefreshSuccess.incrementAndGet();
                    Groups.this.backgroundRefreshRunning.decrementAndGet();
                }

                @Override
                public void onFailure(Throwable t) {
                    Groups.this.backgroundRefreshException.incrementAndGet();
                    Groups.this.backgroundRefreshRunning.decrementAndGet();
                }
            });
            return listenableFuture;
        }

        private List<String> fetchGroupList(String user) throws IOException {
            long startMs = Groups.this.timer.monotonicNow();
            List<String> groupList = Groups.this.impl.getGroups(user);
            long endMs = Groups.this.timer.monotonicNow();
            long deltaMs = endMs - startMs;
            UserGroupInformation.metrics.addGetGroups(deltaMs);
            if (deltaMs > Groups.this.warningDeltaMs) {
                LOG.warn((Object)("Potential performance problem: getGroups(user=" + user + ") " + "took " + deltaMs + " milliseconds."));
            }
            return groupList;
        }
    }

    private static class TimerToTickerAdapter
    extends Ticker {
        private Timer timer;

        public TimerToTickerAdapter(Timer timer) {
            this.timer = timer;
        }

        @Override
        public long read() {
            long NANOSECONDS_PER_MS = 1000000L;
            return this.timer.monotonicNow() * 1000000L;
        }
    }
}

