/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import com.sun.jersey.api.ParamException;
import com.sun.jersey.api.container.ContainerException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Charsets;
import org.apache.flink.shaded.hadoop2.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.HttpVersion;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.SecretManager;

class ExceptionHandler {
    static Log LOG = WebHdfsHandler.LOG;

    ExceptionHandler() {
    }

    static DefaultFullHttpResponse exceptionCaught(Throwable cause) {
        HttpResponseStatus s;
        Exception e;
        Exception exception = e = cause instanceof Exception ? (Exception)cause : new Exception(cause);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"GOT EXCEPTION", (Throwable)e);
        }
        if (e instanceof ParamException) {
            ParamException paramexception = (ParamException)e;
            e = new IllegalArgumentException("Invalid value for webhdfs parameter \"" + paramexception.getParameterName() + "\": " + e.getCause().getMessage(), e);
        } else if (e instanceof ContainerException || e instanceof SecurityException) {
            e = ExceptionHandler.toCause(e);
        } else if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        if (e instanceof SecurityException) {
            s = HttpResponseStatus.FORBIDDEN;
        } else if (e instanceof AuthorizationException) {
            s = HttpResponseStatus.FORBIDDEN;
        } else if (e instanceof FileNotFoundException) {
            s = HttpResponseStatus.NOT_FOUND;
        } else if (e instanceof IOException) {
            s = HttpResponseStatus.FORBIDDEN;
        } else if (e instanceof UnsupportedOperationException) {
            s = HttpResponseStatus.BAD_REQUEST;
        } else if (e instanceof IllegalArgumentException) {
            s = HttpResponseStatus.BAD_REQUEST;
        } else {
            LOG.warn((Object)"INTERNAL_SERVER_ERROR", (Throwable)e);
            s = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        }
        byte[] js = JsonUtil.toJsonString(e).getBytes(Charsets.UTF_8);
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, s, Unpooled.wrappedBuffer(js));
        resp.headers().set("Content-Type", (Object)"application/json; charset=utf-8");
        resp.headers().set("Content-Length", (Object)js.length);
        return resp;
    }

    private static Exception toCause(Exception e) {
        Throwable t = e.getCause();
        if (e instanceof SecurityException) {
            Throwable t1;
            if (t != null && t instanceof SecretManager.InvalidToken && (t1 = t.getCause()) != null && t1 instanceof StandbyException) {
                e = (StandbyException)t1;
            }
        } else if (t != null && t instanceof Exception) {
            e = (Exception)t;
        }
        return e;
    }
}

