/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.socks;

import org.apache.flink.shaded.hadoop2.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.Channel;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.socks.SocksCmdRequest;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.socks.SocksCommonUtils;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.socks.SocksMessage;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.socks.SocksRequest;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksCmdRequestDecoder
extends ReplayingDecoder<State> {
    private static final String name = "SOCKS_CMD_REQUEST_DECODER";
    private SocksMessage.ProtocolVersion version;
    private int fieldLength;
    private SocksMessage.CmdType cmdType;
    private SocksMessage.AddressType addressType;
    private byte reserved;
    private String host;
    private int port;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    public static String getName() {
        return name;
    }

    public SocksCmdRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        block0 : switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdType = SocksMessage.CmdType.fromByte(buffer.readByte());
                this.reserved = buffer.readByte();
                this.addressType = SocksMessage.AddressType.fromByte(buffer.readByte());
                this.checkpoint(State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        this.host = SocksCommonUtils.intToIp(buffer.readInt());
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdRequest(this.cmdType, this.addressType, this.host, this.port);
                        break block0;
                    }
                    case DOMAIN: {
                        this.fieldLength = buffer.readByte();
                        this.host = buffer.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdRequest(this.cmdType, this.addressType, this.host, this.port);
                        break block0;
                    }
                    case IPv6: {
                        this.host = SocksCommonUtils.ipv6toStr(buffer.readBytes(16).array());
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdRequest(this.cmdType, this.addressType, this.host, this.port);
                        break block0;
                    }
                }
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_CMD_HEADER,
        READ_CMD_ADDRESS;

    }
}

