/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Function;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Predicate;
import org.apache.flink.shaded.hadoop2.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.hadoop2.com.google.common.collect.Maps;
import org.apache.flink.shaded.hadoop2.com.google.common.collect.Sets;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.CuratorEvent;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.Pathable;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.WatchPathable;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.listen.ListenerContainer;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.EventOperation;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.GetDataOperation;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.Operation;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.PathChildrenCacheMode;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.recipes.cache.RefreshOperation;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.flink.shaded.hadoop2.org.apache.curator.utils.CloseableExecutorService;
import org.apache.flink.shaded.hadoop2.org.apache.curator.utils.EnsurePath;
import org.apache.flink.shaded.hadoop2.org.apache.curator.utils.PathUtils;
import org.apache.flink.shaded.hadoop2.org.apache.curator.utils.ThreadUtils;
import org.apache.flink.shaded.hadoop2.org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathChildrenCache
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String path;
    private final CloseableExecutorService executorService;
    private final boolean cacheData;
    private final boolean dataIsCompressed;
    private final EnsurePath ensurePath;
    private final ListenerContainer<PathChildrenCacheListener> listeners = new ListenerContainer();
    private final ConcurrentMap<String, ChildData> currentData = Maps.newConcurrentMap();
    private final AtomicReference<Map<String, ChildData>> initialSet = new AtomicReference();
    private final Set<Operation> operationsQuantizer = Sets.newSetFromMap(Maps.newConcurrentMap());
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private static final ChildData NULL_CHILD_DATA = new ChildData("/", null, null);
    private static final boolean USE_EXISTS = Boolean.getBoolean("curator-path-children-cache-use-exists");
    private volatile Watcher childrenWatcher = new Watcher(){

        public void process(WatchedEvent event) {
            PathChildrenCache.this.offerOperation(new RefreshOperation(PathChildrenCache.this, RefreshMode.STANDARD));
        }
    };
    private volatile Watcher dataWatcher = new Watcher(){

        public void process(WatchedEvent event) {
            try {
                if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                    PathChildrenCache.this.remove(event.getPath());
                } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    PathChildrenCache.this.offerOperation(new GetDataOperation(PathChildrenCache.this, event.getPath()));
                }
            }
            catch (Exception e) {
                PathChildrenCache.this.handleException(e);
            }
        }
    };
    @VisibleForTesting
    volatile Exchanger<Object> rebuildTestExchanger;
    private volatile ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            PathChildrenCache.this.handleStateChange(newState);
        }
    };
    private static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory("PathChildrenCache");

    public PathChildrenCache(CuratorFramework client, String path, PathChildrenCacheMode mode) {
        this(client, path, mode != PathChildrenCacheMode.CACHE_PATHS_ONLY, false, new CloseableExecutorService(Executors.newSingleThreadExecutor(defaultThreadFactory), true));
    }

    public PathChildrenCache(CuratorFramework client, String path, PathChildrenCacheMode mode, ThreadFactory threadFactory) {
        this(client, path, mode != PathChildrenCacheMode.CACHE_PATHS_ONLY, false, new CloseableExecutorService(Executors.newSingleThreadExecutor(threadFactory), true));
    }

    public PathChildrenCache(CuratorFramework client, String path, boolean cacheData) {
        this(client, path, cacheData, false, new CloseableExecutorService(Executors.newSingleThreadExecutor(defaultThreadFactory), true));
    }

    public PathChildrenCache(CuratorFramework client, String path, boolean cacheData, ThreadFactory threadFactory) {
        this(client, path, cacheData, false, new CloseableExecutorService(Executors.newSingleThreadExecutor(threadFactory), true));
    }

    public PathChildrenCache(CuratorFramework client, String path, boolean cacheData, boolean dataIsCompressed, ThreadFactory threadFactory) {
        this(client, path, cacheData, dataIsCompressed, new CloseableExecutorService(Executors.newSingleThreadExecutor(threadFactory), true));
    }

    public PathChildrenCache(CuratorFramework client, String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        this(client, path, cacheData, dataIsCompressed, new CloseableExecutorService(executorService));
    }

    public PathChildrenCache(CuratorFramework client, String path, boolean cacheData, boolean dataIsCompressed, CloseableExecutorService executorService) {
        this.client = client;
        this.path = PathUtils.validatePath(path);
        this.cacheData = cacheData;
        this.dataIsCompressed = dataIsCompressed;
        this.executorService = executorService;
        this.ensurePath = client.newNamespaceAwareEnsurePath(path);
    }

    public void start() throws Exception {
        this.start(StartMode.NORMAL);
    }

    public void start(boolean buildInitial) throws Exception {
        this.start(buildInitial ? StartMode.BUILD_INITIAL_CACHE : StartMode.NORMAL);
    }

    public void start(StartMode mode) throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "already started");
        mode = Preconditions.checkNotNull(mode, "mode cannot be null");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        switch (mode) {
            case NORMAL: {
                this.offerOperation(new RefreshOperation(this, RefreshMode.STANDARD));
                break;
            }
            case BUILD_INITIAL_CACHE: {
                this.rebuild();
                break;
            }
            case POST_INITIALIZED_EVENT: {
                this.initialSet.set(Maps.newConcurrentMap());
                this.offerOperation(new RefreshOperation(this, RefreshMode.POST_INITIALIZED));
            }
        }
    }

    public void rebuild() throws Exception {
        Preconditions.checkState(!this.executorService.isShutdown(), "cache has been closed");
        this.ensurePath.ensure(this.client.getZookeeperClient());
        this.clear();
        List children = (List)this.client.getChildren().forPath(this.path);
        for (String child : children) {
            String fullPath = ZKPaths.makePath(this.path, child);
            this.internalRebuildNode(fullPath);
            if (this.rebuildTestExchanger == null) continue;
            this.rebuildTestExchanger.exchange(new Object());
        }
        this.offerOperation(new RefreshOperation(this, RefreshMode.FORCE_GET_DATA_AND_STAT));
    }

    public void rebuildNode(String fullPath) throws Exception {
        Preconditions.checkArgument(ZKPaths.getPathAndNode(fullPath).getPath().equals(this.path), "Node is not part of this cache: " + fullPath);
        Preconditions.checkState(!this.executorService.isShutdown(), "cache has been closed");
        this.ensurePath.ensure(this.client.getZookeeperClient());
        this.internalRebuildNode(fullPath);
        this.offerOperation(new RefreshOperation(this, RefreshMode.FORCE_GET_DATA_AND_STAT));
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
            this.listeners.clear();
            this.executorService.close();
            this.client.clearWatcherReferences(this.childrenWatcher);
            this.client.clearWatcherReferences(this.dataWatcher);
            this.connectionStateListener = null;
            this.childrenWatcher = null;
            this.dataWatcher = null;
        }
    }

    public ListenerContainer<PathChildrenCacheListener> getListenable() {
        return this.listeners;
    }

    public List<ChildData> getCurrentData() {
        return ImmutableList.copyOf(Sets.newTreeSet(this.currentData.values()));
    }

    public ChildData getCurrentData(String fullPath) {
        return (ChildData)this.currentData.get(fullPath);
    }

    public void clearDataBytes(String fullPath) {
        this.clearDataBytes(fullPath, -1);
    }

    public boolean clearDataBytes(String fullPath, int ifVersion) {
        ChildData data = (ChildData)this.currentData.get(fullPath);
        if (data != null && (ifVersion < 0 || ifVersion == data.getStat().getVersion())) {
            data.clearData();
            return true;
        }
        return false;
    }

    public void clearAndRefresh() throws Exception {
        this.currentData.clear();
        this.offerOperation(new RefreshOperation(this, RefreshMode.STANDARD));
    }

    public void clear() {
        this.currentData.clear();
    }

    void refresh(final RefreshMode mode) throws Exception {
        this.ensurePath.ensure(this.client.getZookeeperClient());
        BackgroundCallback callback = new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                if (((State)((Object)PathChildrenCache.this.state.get())).equals((Object)State.CLOSED)) {
                    return;
                }
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    PathChildrenCache.this.processChildren(event.getChildren(), mode);
                }
            }
        };
        ((Pathable)((BackgroundPathable)this.client.getChildren().usingWatcher(this.childrenWatcher)).inBackground(callback)).forPath(this.path);
    }

    void callListeners(final PathChildrenCacheEvent event) {
        this.listeners.forEach(new Function<PathChildrenCacheListener, Void>(){

            @Override
            public Void apply(PathChildrenCacheListener listener) {
                try {
                    listener.childEvent(PathChildrenCache.this.client, event);
                }
                catch (Exception e) {
                    PathChildrenCache.this.handleException(e);
                }
                return null;
            }
        });
    }

    void getDataAndStat(final String fullPath) throws Exception {
        BackgroundCallback callback = new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                PathChildrenCache.this.applyNewData(fullPath, event.getResultCode(), event.getStat(), PathChildrenCache.this.cacheData ? event.getData() : null);
            }
        };
        if (USE_EXISTS && !this.cacheData) {
            ((Pathable)((BackgroundPathable)this.client.checkExists().usingWatcher(this.dataWatcher)).inBackground(callback)).forPath(fullPath);
        } else if (this.dataIsCompressed && this.cacheData) {
            ((Pathable)((BackgroundPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).usingWatcher(this.dataWatcher)).inBackground(callback)).forPath(fullPath);
        } else {
            ((Pathable)((BackgroundPathable)this.client.getData().usingWatcher(this.dataWatcher)).inBackground(callback)).forPath(fullPath);
        }
    }

    protected void handleException(Throwable e) {
        this.log.error("", e);
    }

    @VisibleForTesting
    protected void remove(String fullPath) {
        Map<String, ChildData> localInitialSet;
        ChildData data = (ChildData)this.currentData.remove(fullPath);
        if (data != null) {
            this.offerOperation(new EventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CHILD_REMOVED, data)));
        }
        if ((localInitialSet = this.initialSet.get()) != null) {
            localInitialSet.remove(fullPath);
            this.maybeOfferInitializedEvent(localInitialSet);
        }
    }

    private void internalRebuildNode(String fullPath) throws Exception {
        if (this.cacheData) {
            try {
                Stat stat = new Stat();
                byte[] bytes = this.dataIsCompressed ? (byte[])((WatchPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).storingStatIn(stat)).forPath(fullPath) : (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(fullPath);
                this.currentData.put(fullPath, new ChildData(fullPath, stat, bytes));
            }
            catch (KeeperException.NoNodeException ignore) {
                this.currentData.remove(fullPath);
            }
        } else {
            Stat stat = (Stat)this.client.checkExists().forPath(fullPath);
            if (stat != null) {
                this.currentData.put(fullPath, new ChildData(fullPath, stat, null));
            } else {
                this.currentData.remove(fullPath);
            }
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case SUSPENDED: {
                this.offerOperation(new EventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CONNECTION_SUSPENDED, null)));
                break;
            }
            case LOST: {
                this.offerOperation(new EventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CONNECTION_LOST, null)));
                break;
            }
            case RECONNECTED: {
                try {
                    this.offerOperation(new RefreshOperation(this, RefreshMode.FORCE_GET_DATA_AND_STAT));
                    this.offerOperation(new EventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CONNECTION_RECONNECTED, null)));
                    break;
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }

    private void processChildren(List<String> children, RefreshMode mode) throws Exception {
        HashSet<String> removedNodes = Sets.newHashSet(this.currentData.keySet());
        for (String child : children) {
            removedNodes.remove(ZKPaths.makePath(this.path, child));
        }
        for (String fullPath : removedNodes) {
            this.remove(fullPath);
        }
        for (String name : children) {
            String fullPath = ZKPaths.makePath(this.path, name);
            if (mode == RefreshMode.FORCE_GET_DATA_AND_STAT || !this.currentData.containsKey(fullPath)) {
                this.getDataAndStat(fullPath);
            }
            this.updateInitialSet(name, NULL_CHILD_DATA);
        }
        this.maybeOfferInitializedEvent(this.initialSet.get());
    }

    private void applyNewData(String fullPath, int resultCode, Stat stat, byte[] bytes) {
        if (resultCode == KeeperException.Code.OK.intValue()) {
            ChildData data = new ChildData(fullPath, stat, bytes);
            ChildData previousData = this.currentData.put(fullPath, data);
            if (previousData == null) {
                this.offerOperation(new EventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CHILD_ADDED, data)));
            } else if (previousData.getStat().getVersion() != stat.getVersion()) {
                this.offerOperation(new EventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CHILD_UPDATED, data)));
            }
            this.updateInitialSet(ZKPaths.getNodeFromPath(fullPath), data);
        }
    }

    private void updateInitialSet(String name, ChildData data) {
        Map<String, ChildData> localInitialSet = this.initialSet.get();
        if (localInitialSet != null) {
            localInitialSet.put(name, data);
            this.maybeOfferInitializedEvent(localInitialSet);
        }
    }

    private void maybeOfferInitializedEvent(Map<String, ChildData> localInitialSet) {
        if (!this.hasUninitialized(localInitialSet) && this.initialSet.getAndSet(null) != null) {
            final ImmutableList<ChildData> children = ImmutableList.copyOf(localInitialSet.values());
            PathChildrenCacheEvent event = new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.INITIALIZED, null){

                @Override
                public List<ChildData> getInitialData() {
                    return children;
                }
            };
            this.offerOperation(new EventOperation(this, event));
        }
    }

    private boolean hasUninitialized(Map<String, ChildData> localInitialSet) {
        if (localInitialSet == null) {
            return false;
        }
        Map<String, ChildData> uninitializedChildren = Maps.filterValues(localInitialSet, new Predicate<ChildData>(){

            @Override
            public boolean apply(ChildData input) {
                return input == NULL_CHILD_DATA;
            }
        });
        return uninitializedChildren.size() != 0;
    }

    void offerOperation(final Operation operation) {
        if (this.operationsQuantizer.add(operation)) {
            this.submitToExecutor(new Runnable(){

                @Override
                public void run() {
                    try {
                        PathChildrenCache.this.operationsQuantizer.remove(operation);
                        operation.invoke();
                    }
                    catch (InterruptedException e) {
                        if (PathChildrenCache.this.state.get() != State.CLOSED) {
                            PathChildrenCache.this.handleException(e);
                        }
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        PathChildrenCache.this.handleException(e);
                    }
                }
            });
        }
    }

    private synchronized void submitToExecutor(Runnable command) {
        if (this.state.get() == State.STARTED) {
            this.executorService.submit(command);
        }
    }

    static enum RefreshMode {
        STANDARD,
        FORCE_GET_DATA_AND_STAT,
        POST_INITIALIZED;

    }

    public static enum StartMode {
        NORMAL,
        BUILD_INITIAL_CACHE,
        POST_INITIALIZED_EVENT;

    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

