/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Charsets;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.hdfs.web.HsftpFileSystem;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String WEBSERVICE = "webservice";
    private static final String RENEWER = "renewer";
    private static final String CANCEL = "cancel";
    private static final String RENEW = "renew";
    private static final String PRINT = "print";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";

    private static void printUsage(PrintStream err) {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err.println("  --print             Print the delegation token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage(err);
        ExitUtil.terminate(1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile(file, conf);
        return creds.getAllTokens();
    }

    public static void main(String[] args) throws Exception {
        final HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at");
        fetcherOptions.addOption(RENEWER, true, "Name of the delegation token renewer");
        fetcherOptions.addOption(CANCEL, false, "cancel the token");
        fetcherOptions.addOption(RENEW, false, "renew the token");
        fetcherOptions.addOption(PRINT, false, "print the token");
        fetcherOptions.addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser(conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        final String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        final String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        final boolean cancel = cmd.hasOption(CANCEL);
        final boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        boolean help = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help) {
            DelegationTokenFetcher.printUsage(System.out);
            System.exit(0);
        }
        if (cancel && renew || cancel && print || renew && print || cancel && renew && print) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exacltly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal(conf);
        final Path tokenFile = new Path(((FileSystem)local).getWorkingDirectory(), remaining[0]);
        final URLConnectionFactory connectionFactory = URLConnectionFactory.DEFAULT_SYSTEM_CONNECTION_FACTORY;
        UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
                        id.readFields(in);
                        System.out.println("Token (" + id + ") for " + token.getService());
                    }
                    return null;
                }
                if (renew) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token.isManaged()) continue;
                        long result = token.renew(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Renewed token for " + token.getService() + " until: " + new Date(result)));
                    }
                } else if (cancel) {
                    for (Token token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                        if (!token.isManaged()) continue;
                        token.cancel(conf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Cancelled token for " + token.getService()));
                    }
                } else if (webUrl != null) {
                    Credentials creds = DelegationTokenFetcher.getDTfromRemote(connectionFactory, new URI(webUrl), renewer, null);
                    creds.writeTokenStorageFile(tokenFile, conf);
                    for (Token<? extends TokenIdentifier> token : creds.getAllTokens()) {
                        System.out.println("Fetched token via " + webUrl + " for " + token.getService() + " into " + tokenFile);
                    }
                } else {
                    FileSystem fs = FileSystem.get(conf);
                    Credentials cred = new Credentials();
                    Token<?>[] tokens = fs.addDelegationTokens(renewer, cred);
                    cred.writeTokenStorageFile(tokenFile, conf);
                    for (Token<?> token : tokens) {
                        System.out.println("Fetched token for " + token.getService() + " into " + tokenFile);
                    }
                }
                return null;
            }
        });
    }

    public static Credentials getDTfromRemote(URLConnectionFactory factory, URI nnUri, String renewer, String proxyUser) throws IOException {
        Credentials credentials;
        StringBuilder buf = new StringBuilder(nnUri.toString()).append("/getDelegationToken");
        String separator = "?";
        if (renewer != null) {
            buf.append("?").append(RENEWER).append("=").append(renewer);
            separator = "&";
        }
        if (proxyUser != null) {
            buf.append(separator).append("doas=").append(proxyUser);
        }
        boolean isHttps = nnUri.getScheme().equals("https");
        HttpURLConnection conn = null;
        DataInputStream dis = null;
        InetSocketAddress serviceAddr = NetUtils.createSocketAddr(nnUri.getAuthority());
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Retrieving token from: " + buf));
            }
            conn = DelegationTokenFetcher.run(factory, new URL(buf.toString()));
            InputStream in = conn.getInputStream();
            Credentials ts = new Credentials();
            dis = new DataInputStream(in);
            ts.readFields(dis);
            for (Token<? extends TokenIdentifier> token : ts.getAllTokens()) {
                token.setKind(isHttps ? HsftpFileSystem.TOKEN_KIND : HftpFileSystem.TOKEN_KIND);
                SecurityUtil.setTokenService(token, serviceAddr);
            }
            credentials = ts;
        }
        catch (Exception e) {
            try {
                throw new IOException("Unable to obtain remote token", e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, dis);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, dis);
        if (conn != null) {
            conn.disconnect();
        }
        return credentials;
    }

    public static void cancelDelegationToken(URLConnectionFactory factory, URI nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException, AuthenticationException {
        StringBuilder buf = new StringBuilder(nnAddr.toString()).append("/cancelDelegationToken").append("?").append("token").append("=").append(tok.encodeToUrlString());
        HttpURLConnection conn = DelegationTokenFetcher.run(factory, new URL(buf.toString()));
        conn.disconnect();
    }

    public static long renewDelegationToken(URLConnectionFactory factory, URI nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException, AuthenticationException {
        long l;
        StringBuilder buf = new StringBuilder(nnAddr.toString()).append("/renewDelegationToken").append("?").append("token").append("=").append(tok.encodeToUrlString());
        HttpURLConnection connection = null;
        BufferedReader in = null;
        try {
            long result;
            connection = DelegationTokenFetcher.run(factory, new URL(buf.toString()));
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            l = result = Long.parseLong(in.readLine());
        }
        catch (IOException ie) {
            try {
                LOG.info((Object)"error in renew over HTTP", (Throwable)ie);
                IOException e = DelegationTokenFetcher.getExceptionFromResponse(connection);
                if (e != null) {
                    LOG.info((Object)("rethrowing exception from HTTP request: " + e.getLocalizedMessage()));
                    throw e;
                }
                throw ie;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, in);
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, in);
        if (connection != null) {
            connection.disconnect();
        }
        return l;
    }

    private static IOException getExceptionFromResponse(HttpURLConnection con) {
        String resp;
        Throwable e = null;
        if (con == null) {
            return null;
        }
        try {
            resp = con.getResponseMessage();
        }
        catch (IOException ie) {
            return null;
        }
        if (resp == null || resp.isEmpty()) {
            return null;
        }
        String exceptionClass = "";
        String exceptionMsg = "";
        String[] rs = resp.split(";");
        if (rs.length < 2) {
            return null;
        }
        exceptionClass = rs[0];
        exceptionMsg = rs[1];
        LOG.info((Object)("Error response from HTTP request=" + resp + ";ec=" + exceptionClass + ";em=" + exceptionMsg));
        if (exceptionClass == null || exceptionClass.isEmpty()) {
            return null;
        }
        try {
            Class<Exception> ec = Class.forName(exceptionClass).asSubclass(Exception.class);
            Constructor<Exception> constructor = ec.getConstructor(String.class);
            e = (IOException)constructor.newInstance(exceptionMsg);
        }
        catch (Exception ee) {
            LOG.warn((Object)"failed to create object of this class", (Throwable)ee);
        }
        if (e == null) {
            return null;
        }
        e.setStackTrace(new StackTraceElement[0]);
        LOG.info((Object)("Exception from HTTP response=" + e.getLocalizedMessage()));
        return e;
    }

    private static HttpURLConnection run(URLConnectionFactory factory, URL url) throws IOException, AuthenticationException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)factory.openConnection(url, true);
            if (conn.getResponseCode() != 200) {
                String msg = conn.getResponseMessage();
                throw new IOException("Error when dealing remote token: " + msg);
            }
        }
        catch (IOException ie) {
            LOG.info((Object)"Error when dealing remote token:", (Throwable)ie);
            IOException e = DelegationTokenFetcher.getExceptionFromResponse(conn);
            if (e != null) {
                LOG.info((Object)("rethrowing exception from HTTP request: " + e.getLocalizedMessage()));
                throw e;
            }
            throw ie;
        }
        return conn;
    }
}

