/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;

class HeartbeatManager
implements DatanodeStatistics {
    static final Log LOG = LogFactory.getLog(HeartbeatManager.class);
    private final List<DatanodeDescriptor> datanodes = new ArrayList<DatanodeDescriptor>();
    private final Stats stats = new Stats();
    private final long heartbeatRecheckInterval;
    private final Daemon heartbeatThread = new Daemon(new Monitor());
    final Namesystem namesystem;
    final BlockManager blockManager;

    HeartbeatManager(Namesystem namesystem, BlockManager blockManager, Configuration conf) {
        this.namesystem = namesystem;
        this.blockManager = blockManager;
        boolean avoidStaleDataNodesForWrite = conf.getBoolean("dfs.namenode.avoid.write.stale.datanode", false);
        long recheckInterval = conf.getInt("dfs.namenode.heartbeat.recheck-interval", 300000);
        long staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
        if (avoidStaleDataNodesForWrite && staleInterval < recheckInterval) {
            this.heartbeatRecheckInterval = staleInterval;
            LOG.info((Object)("Setting heartbeat recheck interval to " + staleInterval + " since " + "dfs.namenode.stale.datanode.interval" + " is less than " + "dfs.namenode.heartbeat.recheck-interval"));
        } else {
            this.heartbeatRecheckInterval = recheckInterval;
        }
    }

    void activate(Configuration conf) {
        this.heartbeatThread.start();
    }

    void close() {
        this.heartbeatThread.interrupt();
        try {
            this.heartbeatThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized int getLiveDatanodeCount() {
        return this.datanodes.size();
    }

    @Override
    public synchronized long getCapacityTotal() {
        return this.stats.capacityTotal;
    }

    @Override
    public synchronized long getCapacityUsed() {
        return this.stats.capacityUsed;
    }

    @Override
    public synchronized float getCapacityUsedPercent() {
        return DFSUtil.getPercentUsed(this.stats.capacityUsed, this.stats.capacityTotal);
    }

    @Override
    public synchronized long getCapacityRemaining() {
        return this.stats.capacityRemaining;
    }

    @Override
    public synchronized float getCapacityRemainingPercent() {
        return DFSUtil.getPercentRemaining(this.stats.capacityRemaining, this.stats.capacityTotal);
    }

    @Override
    public synchronized long getBlockPoolUsed() {
        return this.stats.blockPoolUsed;
    }

    @Override
    public synchronized float getPercentBlockPoolUsed() {
        return DFSUtil.getPercentUsed(this.stats.blockPoolUsed, this.stats.capacityTotal);
    }

    @Override
    public synchronized long getCapacityUsedNonDFS() {
        long nonDFSUsed = this.stats.capacityTotal - this.stats.capacityRemaining - this.stats.capacityUsed;
        return nonDFSUsed < 0L ? 0L : nonDFSUsed;
    }

    @Override
    public synchronized int getXceiverCount() {
        return this.stats.xceiverCount;
    }

    @Override
    public synchronized long getCacheCapacity() {
        return this.stats.cacheCapacity;
    }

    @Override
    public synchronized long getCacheUsed() {
        return this.stats.cacheUsed;
    }

    @Override
    public synchronized long[] getStats() {
        return new long[]{this.getCapacityTotal(), this.getCapacityUsed(), this.getCapacityRemaining(), -1L, -1L, -1L, this.getBlockPoolUsed()};
    }

    @Override
    public synchronized int getExpiredHeartbeats() {
        return this.stats.expiredHeartbeats;
    }

    synchronized void register(DatanodeDescriptor d) {
        if (!this.datanodes.contains(d)) {
            this.addDatanode(d);
            d.updateHeartbeat(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0);
        }
    }

    synchronized DatanodeDescriptor[] getDatanodes() {
        return this.datanodes.toArray(new DatanodeDescriptor[this.datanodes.size()]);
    }

    synchronized void addDatanode(DatanodeDescriptor d) {
        this.datanodes.add(d);
        d.isAlive = true;
    }

    synchronized void removeDatanode(DatanodeDescriptor node) {
        if (node.isAlive) {
            this.stats.subtract(node);
            this.datanodes.remove(node);
            node.isAlive = false;
        }
    }

    synchronized void updateHeartbeat(DatanodeDescriptor node, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int failedVolumes) {
        this.stats.subtract(node);
        node.updateHeartbeat(reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes);
        this.stats.add(node);
    }

    synchronized void startDecommission(DatanodeDescriptor node) {
        this.stats.subtract(node);
        node.startDecommission();
        this.stats.add(node);
    }

    synchronized void stopDecommission(DatanodeDescriptor node) {
        this.stats.subtract(node);
        node.stopDecommission();
        this.stats.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heartbeatCheck() {
        DatanodeManager dm = this.blockManager.getDatanodeManager();
        if (this.namesystem.isInStartupSafeMode()) {
            return;
        }
        boolean allAlive = false;
        while (!allAlive) {
            DatanodeDescriptor dead = null;
            int numOfStaleNodes = 0;
            HeartbeatManager heartbeatManager = this;
            synchronized (heartbeatManager) {
                for (DatanodeDescriptor d : this.datanodes) {
                    if (dead == null && dm.isDatanodeDead(d)) {
                        this.stats.incrExpiredHeartbeats();
                        dead = d;
                    }
                    if (!d.isStale(dm.getStaleInterval())) continue;
                    ++numOfStaleNodes;
                }
                dm.setNumStaleNodes(numOfStaleNodes);
            }
            allAlive = dead == null;
            if (allAlive) continue;
            this.namesystem.writeLock();
            try {
                if (this.namesystem.isInStartupSafeMode()) {
                    return;
                }
                heartbeatManager = this;
                synchronized (heartbeatManager) {
                    dm.removeDeadDatanode(dead);
                }
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }

    private static class Stats {
        private long capacityTotal = 0L;
        private long capacityUsed = 0L;
        private long capacityRemaining = 0L;
        private long blockPoolUsed = 0L;
        private int xceiverCount = 0;
        private long cacheCapacity = 0L;
        private long cacheUsed = 0L;
        private int expiredHeartbeats = 0;

        private Stats() {
        }

        private void add(DatanodeDescriptor node) {
            this.capacityUsed += node.getDfsUsed();
            this.blockPoolUsed += node.getBlockPoolUsed();
            this.xceiverCount += node.getXceiverCount();
            if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
                this.capacityTotal += node.getCapacity();
                this.capacityRemaining += node.getRemaining();
            } else {
                this.capacityTotal += node.getDfsUsed();
            }
            this.cacheCapacity += node.getCacheCapacity();
            this.cacheUsed += node.getCacheUsed();
        }

        private void subtract(DatanodeDescriptor node) {
            this.capacityUsed -= node.getDfsUsed();
            this.blockPoolUsed -= node.getBlockPoolUsed();
            this.xceiverCount -= node.getXceiverCount();
            if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
                this.capacityTotal -= node.getCapacity();
                this.capacityRemaining -= node.getRemaining();
            } else {
                this.capacityTotal -= node.getDfsUsed();
            }
            this.cacheCapacity -= node.getCacheCapacity();
            this.cacheUsed -= node.getCacheUsed();
        }

        private void incrExpiredHeartbeats() {
            ++this.expiredHeartbeats;
        }
    }

    private class Monitor
    implements Runnable {
        private long lastHeartbeatCheck;
        private long lastBlockKeyUpdate;

        private Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (HeartbeatManager.this.namesystem.isRunning()) {
                block10: {
                    try {
                        long now = Time.now();
                        if (this.lastHeartbeatCheck + HeartbeatManager.this.heartbeatRecheckInterval < now) {
                            HeartbeatManager.this.heartbeatCheck();
                            this.lastHeartbeatCheck = now;
                        }
                        if (!HeartbeatManager.this.blockManager.shouldUpdateBlockKey(now - this.lastBlockKeyUpdate)) break block10;
                        HeartbeatManager heartbeatManager = HeartbeatManager.this;
                        synchronized (heartbeatManager) {
                            for (DatanodeDescriptor d : HeartbeatManager.this.datanodes) {
                                d.needKeyUpdate = true;
                            }
                        }
                        this.lastBlockKeyUpdate = now;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception while checking heartbeat", (Throwable)e);
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

