/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.protocolPB;

import java.io.IOException;
import java.net.URL;
import org.apache.flink.shaded.hadoop2.com.google.protobuf.RpcController;
import org.apache.flink.shaded.hadoop2.com.google.protobuf.ServiceException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocol;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.protocol.RequestInfo;
import org.apache.hadoop.hdfs.qjournal.protocolPB.QJournalProtocolPB;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;

@InterfaceAudience.Private
public class QJournalProtocolServerSideTranslatorPB
implements QJournalProtocolPB {
    private final QJournalProtocol impl;
    private static final QJournalProtocolProtos.JournalResponseProto VOID_JOURNAL_RESPONSE = QJournalProtocolProtos.JournalResponseProto.newBuilder().build();
    private static final QJournalProtocolProtos.StartLogSegmentResponseProto VOID_START_LOG_SEGMENT_RESPONSE = QJournalProtocolProtos.StartLogSegmentResponseProto.newBuilder().build();

    public QJournalProtocolServerSideTranslatorPB(QJournalProtocol impl) {
        this.impl = impl;
    }

    @Override
    public QJournalProtocolProtos.IsFormattedResponseProto isFormatted(RpcController controller, QJournalProtocolProtos.IsFormattedRequestProto request) throws ServiceException {
        try {
            boolean ret = this.impl.isFormatted(this.convert(request.getJid()));
            return QJournalProtocolProtos.IsFormattedResponseProto.newBuilder().setIsFormatted(ret).build();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public QJournalProtocolProtos.GetJournalStateResponseProto getJournalState(RpcController controller, QJournalProtocolProtos.GetJournalStateRequestProto request) throws ServiceException {
        try {
            return this.impl.getJournalState(this.convert(request.getJid()));
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    private String convert(QJournalProtocolProtos.JournalIdProto jid) {
        return jid.getIdentifier();
    }

    @Override
    public QJournalProtocolProtos.NewEpochResponseProto newEpoch(RpcController controller, QJournalProtocolProtos.NewEpochRequestProto request) throws ServiceException {
        try {
            return this.impl.newEpoch(request.getJid().getIdentifier(), PBHelper.convert(request.getNsInfo()), request.getEpoch());
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public QJournalProtocolProtos.FormatResponseProto format(RpcController controller, QJournalProtocolProtos.FormatRequestProto request) throws ServiceException {
        try {
            this.impl.format(request.getJid().getIdentifier(), PBHelper.convert(request.getNsInfo()));
            return QJournalProtocolProtos.FormatResponseProto.getDefaultInstance();
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
    }

    @Override
    public QJournalProtocolProtos.JournalResponseProto journal(RpcController unused, QJournalProtocolProtos.JournalRequestProto req) throws ServiceException {
        try {
            this.impl.journal(this.convert(req.getReqInfo()), req.getSegmentTxnId(), req.getFirstTxnId(), req.getNumTxns(), req.getRecords().toByteArray());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return VOID_JOURNAL_RESPONSE;
    }

    @Override
    public QJournalProtocolProtos.HeartbeatResponseProto heartbeat(RpcController controller, QJournalProtocolProtos.HeartbeatRequestProto req) throws ServiceException {
        try {
            this.impl.heartbeat(this.convert(req.getReqInfo()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return QJournalProtocolProtos.HeartbeatResponseProto.getDefaultInstance();
    }

    @Override
    public QJournalProtocolProtos.StartLogSegmentResponseProto startLogSegment(RpcController controller, QJournalProtocolProtos.StartLogSegmentRequestProto req) throws ServiceException {
        try {
            int layoutVersion = req.hasLayoutVersion() ? req.getLayoutVersion() : NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION;
            this.impl.startLogSegment(this.convert(req.getReqInfo()), req.getTxid(), layoutVersion);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return VOID_START_LOG_SEGMENT_RESPONSE;
    }

    @Override
    public QJournalProtocolProtos.FinalizeLogSegmentResponseProto finalizeLogSegment(RpcController controller, QJournalProtocolProtos.FinalizeLogSegmentRequestProto req) throws ServiceException {
        try {
            this.impl.finalizeLogSegment(this.convert(req.getReqInfo()), req.getStartTxId(), req.getEndTxId());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return QJournalProtocolProtos.FinalizeLogSegmentResponseProto.newBuilder().build();
    }

    @Override
    public QJournalProtocolProtos.PurgeLogsResponseProto purgeLogs(RpcController controller, QJournalProtocolProtos.PurgeLogsRequestProto req) throws ServiceException {
        try {
            this.impl.purgeLogsOlderThan(this.convert(req.getReqInfo()), req.getMinTxIdToKeep());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return QJournalProtocolProtos.PurgeLogsResponseProto.getDefaultInstance();
    }

    @Override
    public QJournalProtocolProtos.GetEditLogManifestResponseProto getEditLogManifest(RpcController controller, QJournalProtocolProtos.GetEditLogManifestRequestProto request) throws ServiceException {
        try {
            return this.impl.getEditLogManifest(request.getJid().getIdentifier(), request.getSinceTxId(), request.getInProgressOk());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.PrepareRecoveryResponseProto prepareRecovery(RpcController controller, QJournalProtocolProtos.PrepareRecoveryRequestProto request) throws ServiceException {
        try {
            return this.impl.prepareRecovery(this.convert(request.getReqInfo()), request.getSegmentTxId());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.AcceptRecoveryResponseProto acceptRecovery(RpcController controller, QJournalProtocolProtos.AcceptRecoveryRequestProto request) throws ServiceException {
        try {
            this.impl.acceptRecovery(this.convert(request.getReqInfo()), request.getStateToAccept(), new URL(request.getFromURL()));
            return QJournalProtocolProtos.AcceptRecoveryResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    private RequestInfo convert(QJournalProtocolProtos.RequestInfoProto reqInfo) {
        return new RequestInfo(reqInfo.getJournalId().getIdentifier(), reqInfo.getEpoch(), reqInfo.getIpcSerialNumber(), reqInfo.hasCommittedTxId() ? reqInfo.getCommittedTxId() : -12345L);
    }

    @Override
    public QJournalProtocolProtos.DiscardSegmentsResponseProto discardSegments(RpcController controller, QJournalProtocolProtos.DiscardSegmentsRequestProto request) throws ServiceException {
        try {
            this.impl.discardSegments(this.convert(request.getJid()), request.getStartTxId());
            return QJournalProtocolProtos.DiscardSegmentsResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.DoPreUpgradeResponseProto doPreUpgrade(RpcController controller, QJournalProtocolProtos.DoPreUpgradeRequestProto request) throws ServiceException {
        try {
            this.impl.doPreUpgrade(this.convert(request.getJid()));
            return QJournalProtocolProtos.DoPreUpgradeResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.DoUpgradeResponseProto doUpgrade(RpcController controller, QJournalProtocolProtos.DoUpgradeRequestProto request) throws ServiceException {
        StorageInfo si = PBHelper.convert(request.getSInfo(), HdfsServerConstants.NodeType.JOURNAL_NODE);
        try {
            this.impl.doUpgrade(this.convert(request.getJid()), si);
            return QJournalProtocolProtos.DoUpgradeResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.DoFinalizeResponseProto doFinalize(RpcController controller, QJournalProtocolProtos.DoFinalizeRequestProto request) throws ServiceException {
        try {
            this.impl.doFinalize(this.convert(request.getJid()));
            return QJournalProtocolProtos.DoFinalizeResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.CanRollBackResponseProto canRollBack(RpcController controller, QJournalProtocolProtos.CanRollBackRequestProto request) throws ServiceException {
        try {
            StorageInfo si = PBHelper.convert(request.getStorage(), HdfsServerConstants.NodeType.JOURNAL_NODE);
            Boolean result = this.impl.canRollBack(this.convert(request.getJid()), si, PBHelper.convert(request.getPrevStorage(), HdfsServerConstants.NodeType.JOURNAL_NODE), request.getTargetLayoutVersion());
            return QJournalProtocolProtos.CanRollBackResponseProto.newBuilder().setCanRollBack(result).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.DoRollbackResponseProto doRollback(RpcController controller, QJournalProtocolProtos.DoRollbackRequestProto request) throws ServiceException {
        try {
            this.impl.doRollback(this.convert(request.getJid()));
            return QJournalProtocolProtos.DoRollbackResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public QJournalProtocolProtos.GetJournalCTimeResponseProto getJournalCTime(RpcController controller, QJournalProtocolProtos.GetJournalCTimeRequestProto request) throws ServiceException {
        try {
            Long resultCTime = this.impl.getJournalCTime(this.convert(request.getJid()));
            return QJournalProtocolProtos.GetJournalCTimeResponseProto.newBuilder().setResultCTime(resultCTime).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }
}

