/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.Quota;

@InterfaceAudience.Private
public interface INodeDirectoryAttributes
extends INodeAttributes {
    public Quota.Counts getQuotaCounts();

    public boolean metadataEquals(INodeDirectoryAttributes var1);

    public static class CopyWithQuota
    extends SnapshotCopy {
        private final long nsQuota;
        private final long dsQuota;

        public CopyWithQuota(byte[] name, PermissionStatus permissions, AclFeature aclFeature, long modificationTime, long nsQuota, long dsQuota) {
            super(name, permissions, aclFeature, modificationTime);
            this.nsQuota = nsQuota;
            this.dsQuota = dsQuota;
        }

        public CopyWithQuota(INodeDirectory dir) {
            super(dir);
            Preconditions.checkArgument(dir.isQuotaSet());
            Quota.Counts q = dir.getQuotaCounts();
            this.nsQuota = q.get(Quota.NAMESPACE);
            this.dsQuota = q.get(Quota.DISKSPACE);
        }

        @Override
        public Quota.Counts getQuotaCounts() {
            return Quota.Counts.newInstance(this.nsQuota, this.dsQuota);
        }
    }

    public static class SnapshotCopy
    extends INodeAttributes.SnapshotCopy
    implements INodeDirectoryAttributes {
        public SnapshotCopy(byte[] name, PermissionStatus permissions, AclFeature aclFeature, long modificationTime) {
            super(name, permissions, aclFeature, modificationTime, 0L);
        }

        public SnapshotCopy(INodeDirectory dir) {
            super(dir);
        }

        @Override
        public Quota.Counts getQuotaCounts() {
            return Quota.Counts.newInstance(-1L, -1L);
        }

        @Override
        public boolean metadataEquals(INodeDirectoryAttributes other) {
            return other != null && this.getQuotaCounts().equals(other.getQuotaCounts()) && this.getPermissionLong() == other.getPermissionLong();
        }
    }
}

