/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class EditsDoubleBuffer {
    private TxnBuffer bufCurrent;
    private TxnBuffer bufReady;
    private final int initBufferSize;

    public EditsDoubleBuffer(int defaultBufferSize) {
        this.initBufferSize = defaultBufferSize;
        this.bufCurrent = new TxnBuffer(this.initBufferSize);
        this.bufReady = new TxnBuffer(this.initBufferSize);
    }

    public void writeOp(FSEditLogOp op) throws IOException {
        this.bufCurrent.writeOp(op);
    }

    public void writeRaw(byte[] bytes, int offset, int length) throws IOException {
        this.bufCurrent.write(bytes, offset, length);
    }

    public void close() throws IOException {
        Preconditions.checkNotNull(this.bufCurrent);
        Preconditions.checkNotNull(this.bufReady);
        int bufSize = this.bufCurrent.size();
        if (bufSize != 0) {
            throw new IOException("FSEditStream has " + bufSize + " bytes still to be flushed and cannot be closed.");
        }
        IOUtils.cleanup(null, this.bufCurrent, this.bufReady);
        this.bufReady = null;
        this.bufCurrent = null;
    }

    public void setReadyToFlush() {
        assert (this.isFlushed()) : "previous data not flushed yet";
        TxnBuffer tmp = this.bufReady;
        this.bufReady = this.bufCurrent;
        this.bufCurrent = tmp;
    }

    public void flushTo(OutputStream out) throws IOException {
        this.bufReady.writeTo(out);
        this.bufReady.reset();
    }

    public boolean shouldForceSync() {
        return this.bufCurrent.size() >= this.initBufferSize;
    }

    DataOutputBuffer getReadyBuf() {
        return this.bufReady;
    }

    DataOutputBuffer getCurrentBuf() {
        return this.bufCurrent;
    }

    public boolean isFlushed() {
        return this.bufReady.size() == 0;
    }

    public int countBufferedBytes() {
        return this.bufReady.size() + this.bufCurrent.size();
    }

    public long getFirstReadyTxId() {
        assert (this.bufReady.firstTxId > 0L);
        return this.bufReady.firstTxId;
    }

    public int countReadyTxns() {
        return this.bufReady.numTxns;
    }

    public int countReadyBytes() {
        return this.bufReady.size();
    }

    private static class TxnBuffer
    extends DataOutputBuffer {
        long firstTxId;
        int numTxns;
        private final FSEditLogOp.Writer writer = new FSEditLogOp.Writer(this);

        public TxnBuffer(int initBufferSize) {
            super(initBufferSize);
            this.reset();
        }

        public void writeOp(FSEditLogOp op) throws IOException {
            if (this.firstTxId == -12345L) {
                this.firstTxId = op.txid;
            } else assert (op.txid > this.firstTxId);
            this.writer.writeOp(op);
            ++this.numTxns;
        }

        @Override
        public DataOutputBuffer reset() {
            super.reset();
            this.firstTxId = -12345L;
            this.numTxns = 0;
            return this;
        }
    }
}

