/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Charsets;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.JsonNode;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.map.ObjectMapper;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.type.TypeReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.util.StringUtils;
import org.znerd.xmlenc.XMLOutputter;

@InterfaceAudience.Private
class ClusterJspHelper {
    private static final Log LOG = LogFactory.getLog(ClusterJspHelper.class);
    public static final String OVERALL_STATUS = "overall-status";
    public static final String DEAD = "Dead";
    private static final String JMX_QRY = "/jmx?qry=Hadoop:service=NameNode,name=NameNodeInfo";

    ClusterJspHelper() {
    }

    ClusterStatus generateClusterHealthReport() {
        ClusterStatus cs = new ClusterStatus();
        Configuration conf = new Configuration();
        List<DFSUtil.ConfiguredNNAddress> nns = null;
        try {
            nns = DFSUtil.flattenAddressMap(DFSUtil.getNNServiceRpcAddresses(conf));
        }
        catch (Exception e) {
            cs.setError(e);
            return cs;
        }
        for (DFSUtil.ConfiguredNNAddress cnn : nns) {
            InetSocketAddress isa = cnn.getAddress();
            NamenodeMXBeanHelper nnHelper = null;
            try {
                nnHelper = new NamenodeMXBeanHelper(isa, conf);
                String mbeanProps = ClusterJspHelper.queryMbean(nnHelper.httpAddress, conf);
                NamenodeStatus nn = nnHelper.getNamenodeStatus(mbeanProps);
                if (cs.clusterid.isEmpty() || cs.clusterid.equals("")) {
                    cs.clusterid = nnHelper.getClusterId(mbeanProps);
                }
                cs.addNamenodeStatus(nn);
            }
            catch (Exception e) {
                cs.addException(isa.getHostName(), e);
            }
        }
        return cs;
    }

    DecommissionStatus generateDecommissioningReport() {
        String clusterid = "";
        Configuration conf = new Configuration();
        List<DFSUtil.ConfiguredNNAddress> cnns = null;
        try {
            cnns = DFSUtil.flattenAddressMap(DFSUtil.getNNServiceRpcAddresses(conf));
        }
        catch (Exception e) {
            DecommissionStatus dInfo = new DecommissionStatus(clusterid, e);
            return dInfo;
        }
        HashMap<String, Map<String, String>> statusMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Exception> decommissionExceptions = new HashMap<String, Exception>();
        ArrayList<String> unreportedNamenode = new ArrayList<String>();
        for (DFSUtil.ConfiguredNNAddress cnn : cnns) {
            InetSocketAddress isa = cnn.getAddress();
            NamenodeMXBeanHelper nnHelper = null;
            try {
                nnHelper = new NamenodeMXBeanHelper(isa, conf);
                String mbeanProps = ClusterJspHelper.queryMbean(nnHelper.httpAddress, conf);
                if (clusterid.equals("")) {
                    clusterid = nnHelper.getClusterId(mbeanProps);
                }
                nnHelper.getDecomNodeInfoForReport(statusMap, mbeanProps);
            }
            catch (Exception e) {
                String nnHost = isa.getHostName();
                decommissionExceptions.put(nnHost, e);
                unreportedNamenode.add(nnHost);
            }
        }
        this.updateUnknownStatus(statusMap, unreportedNamenode);
        this.getDecommissionNodeClusterState(statusMap);
        return new DecommissionStatus(statusMap, clusterid, this.getDatanodeHttpPort(conf), decommissionExceptions);
    }

    private void getDecommissionNodeClusterState(Map<String, Map<String, String>> statusMap) {
        if (statusMap == null || statusMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, Map<String, String>>> it = statusMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = it.next();
            Map<String, String> nnStatus = entry.getValue();
            if (nnStatus == null || nnStatus.isEmpty()) continue;
            boolean isUnknown = false;
            int unknown = 0;
            int decommissioned = 0;
            int decomInProg = 0;
            int inservice = 0;
            int dead = 0;
            DecommissionStates overallState = DecommissionStates.UNKNOWN;
            for (Map.Entry<String, String> m : nnStatus.entrySet()) {
                String status = m.getValue();
                if (status.equals(DecommissionStates.UNKNOWN.toString())) {
                    isUnknown = true;
                    ++unknown;
                    continue;
                }
                if (status.equals(DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS.toString())) {
                    ++decomInProg;
                    continue;
                }
                if (status.equals(DatanodeInfo.AdminStates.DECOMMISSIONED.toString())) {
                    ++decommissioned;
                    continue;
                }
                if (status.equals(DatanodeInfo.AdminStates.NORMAL.toString())) {
                    ++inservice;
                    continue;
                }
                if (!status.equals(DEAD)) continue;
                ++dead;
            }
            int nns = nnStatus.keySet().size();
            if (inservice + dead + unknown == nns) {
                it.remove();
            } else if (isUnknown) {
                overallState = DecommissionStates.UNKNOWN;
            } else if (decommissioned == nns) {
                overallState = DecommissionStates.DECOMMISSIONED;
            } else if (decommissioned + decomInProg == nns) {
                overallState = DecommissionStates.DECOMMISSION_INPROGRESS;
            } else if (decommissioned + decomInProg < nns && decommissioned + decomInProg > 0) {
                overallState = DecommissionStates.PARTIALLY_DECOMMISSIONED;
            } else {
                LOG.warn("Cluster console encounters a not handled situtation.");
            }
            nnStatus.put(OVERALL_STATUS, overallState.toString());
        }
    }

    private void updateUnknownStatus(Map<String, Map<String, String>> statusMap, List<String> unreportedNn) {
        if (unreportedNn == null || unreportedNn.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> entry : statusMap.entrySet()) {
            String dn = entry.getKey();
            Map<String, String> nnStatus = entry.getValue();
            for (String nn : unreportedNn) {
                nnStatus.put(nn, DecommissionStates.UNKNOWN.toString());
            }
            statusMap.put(dn, nnStatus);
        }
    }

    private int getDatanodeHttpPort(Configuration conf) {
        String address = conf.get("dfs.datanode.http.address", "");
        if (address.equals("")) {
            return -1;
        }
        return Integer.parseInt(address.split(":")[1]);
    }

    private static void toXmlItemBlock(XMLOutputter doc, String key, String value) throws IOException {
        doc.startTag("item");
        doc.attribute("label", key);
        doc.attribute("value", value);
        doc.endTag();
    }

    private static void toXmlItemBlockWithLink(XMLOutputter doc, String value, URL url, String label) throws IOException {
        doc.startTag("item");
        doc.attribute("label", label);
        doc.attribute("value", value);
        doc.attribute("link", url.toString());
        doc.endTag();
    }

    private static void createNamenodeExceptionMsg(XMLOutputter doc, Map<String, Exception> exceptionMsg) throws IOException {
        if (exceptionMsg.size() > 0) {
            doc.startTag("unreportedNamenodes");
            for (Map.Entry<String, Exception> m : exceptionMsg.entrySet()) {
                doc.startTag("node");
                doc.attribute("name", m.getKey());
                doc.attribute("exception", StringUtils.stringifyException(m.getValue()));
                doc.endTag();
            }
            doc.endTag();
        }
    }

    private static void createGeneralException(XMLOutputter doc, String clusterid, String eMsg) throws IOException {
        doc.startTag("cluster");
        doc.attribute("clusterId", clusterid);
        doc.startTag("message");
        doc.startTag("item");
        doc.attribute("msg", eMsg);
        doc.endTag();
        doc.endTag();
        doc.endTag();
    }

    private static String readOutput(URL url) throws IOException {
        String inputLine;
        StringBuilder out = new StringBuilder();
        URLConnection connection = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
        while ((inputLine = in.readLine()) != null) {
            out.append(inputLine);
        }
        in.close();
        return out.toString();
    }

    private static String queryMbean(URI httpAddress, Configuration conf) throws IOException {
        URL url = new URL(httpAddress.toURL(), JMX_QRY);
        return ClusterJspHelper.readOutput(url);
    }

    private static JsonNode getProperty(String props, String propertyname) throws IOException {
        if (props == null || props.equals("") || propertyname == null || propertyname.equals("")) {
            return null;
        }
        ObjectMapper m = new ObjectMapper();
        JsonNode rootNode = m.readValue(props, JsonNode.class);
        JsonNode jn = rootNode.get("beans").get(0).get(propertyname);
        return jn;
    }

    static class DecommissionStatus {
        final Exception error;
        final Map<String, Map<String, String>> statusMap;
        final String clusterid;
        final int httpPort;
        int decommissioned = 0;
        int decommissioning = 0;
        int partial = 0;
        Map<String, Exception> exceptions = new HashMap<String, Exception>();

        private DecommissionStatus(Map<String, Map<String, String>> statusMap, String cid, int httpPort, Map<String, Exception> exceptions) {
            this(statusMap, cid, httpPort, exceptions, null);
        }

        public DecommissionStatus(String cid, Exception e) {
            this(null, cid, -1, null, e);
        }

        private DecommissionStatus(Map<String, Map<String, String>> statusMap, String cid, int httpPort, Map<String, Exception> exceptions, Exception error) {
            this.statusMap = statusMap;
            this.clusterid = cid;
            this.httpPort = httpPort;
            this.exceptions = exceptions;
            this.error = error;
        }

        public void toXML(XMLOutputter doc) throws IOException {
            if (this.error != null) {
                ClusterJspHelper.createGeneralException(doc, this.clusterid, StringUtils.stringifyException(this.error));
                doc.getWriter().flush();
                return;
            }
            if (this.statusMap == null || this.statusMap.isEmpty()) {
                doc.startTag("cluster");
                ClusterJspHelper.createNamenodeExceptionMsg(doc, this.exceptions);
                doc.endTag();
                doc.getWriter().flush();
                return;
            }
            doc.startTag("cluster");
            doc.attribute("clusterId", this.clusterid);
            doc.startTag("decommissioningReport");
            this.countDecommissionDatanodes();
            ClusterJspHelper.toXmlItemBlock(doc, DecommissionStates.DECOMMISSIONED.toString(), Integer.toString(this.decommissioned));
            ClusterJspHelper.toXmlItemBlock(doc, DecommissionStates.DECOMMISSION_INPROGRESS.toString(), Integer.toString(this.decommissioning));
            ClusterJspHelper.toXmlItemBlock(doc, DecommissionStates.PARTIALLY_DECOMMISSIONED.toString(), Integer.toString(this.partial));
            doc.endTag();
            doc.startTag("datanodes");
            Set<String> dnSet = this.statusMap.keySet();
            for (String dnhost : dnSet) {
                String overallStatus;
                Map<String, String> nnStatus = this.statusMap.get(dnhost);
                if (nnStatus == null || nnStatus.isEmpty() || (overallStatus = nnStatus.get(ClusterJspHelper.OVERALL_STATUS)) == null || !overallStatus.equals(DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS.toString()) && !overallStatus.equals(DatanodeInfo.AdminStates.DECOMMISSIONED.toString()) && !overallStatus.equals(DecommissionStates.PARTIALLY_DECOMMISSIONED.toString()) && !overallStatus.equals(DecommissionStates.UNKNOWN.toString())) continue;
                doc.startTag("node");
                ClusterJspHelper.toXmlItemBlockWithLink(doc, dnhost, new URL("http", dnhost, this.httpPort, ""), "DataNode");
                ClusterJspHelper.toXmlItemBlock(doc, ClusterJspHelper.OVERALL_STATUS, overallStatus);
                for (Map.Entry<String, String> m : nnStatus.entrySet()) {
                    String nn = m.getKey();
                    if (nn.equals(ClusterJspHelper.OVERALL_STATUS)) continue;
                    ClusterJspHelper.toXmlItemBlock(doc, nn, nnStatus.get(nn));
                }
                doc.endTag();
            }
            doc.endTag();
            ClusterJspHelper.createNamenodeExceptionMsg(doc, this.exceptions);
            doc.endTag();
        }

        private void countDecommissionDatanodes() {
            for (String dn : this.statusMap.keySet()) {
                Map<String, String> nnStatus = this.statusMap.get(dn);
                String status = nnStatus.get(ClusterJspHelper.OVERALL_STATUS);
                if (status.equals(DecommissionStates.DECOMMISSIONED.toString())) {
                    ++this.decommissioned;
                    continue;
                }
                if (status.equals(DecommissionStates.DECOMMISSION_INPROGRESS.toString())) {
                    ++this.decommissioning;
                    continue;
                }
                if (!status.equals(DecommissionStates.PARTIALLY_DECOMMISSIONED.toString())) continue;
                ++this.partial;
            }
        }
    }

    public static enum DecommissionStates {
        DECOMMISSION_INPROGRESS("Decommission In Progress"),
        DECOMMISSIONED("Decommissioned"),
        PARTIALLY_DECOMMISSIONED("Partially Decommissioning"),
        UNKNOWN("Unknown");

        final String value;

        private DecommissionStates(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }
    }

    static class NamenodeStatus {
        String host = "";
        long capacity = 0L;
        long free = 0L;
        long bpUsed = 0L;
        long nonDfsUsed = 0L;
        long filesAndDirectories = 0L;
        long blocksCount = 0L;
        long missingBlocksCount = 0L;
        int liveDatanodeCount = 0;
        int liveDecomCount = 0;
        int deadDatanodeCount = 0;
        int deadDecomCount = 0;
        URL httpAddress = null;
        String softwareVersion = "";

        NamenodeStatus() {
        }
    }

    static class ClusterStatus {
        Exception error = null;
        String clusterid = "";
        long total_sum = 0L;
        long free_sum = 0L;
        long clusterDfsUsed = 0L;
        long nonDfsUsed_sum = 0L;
        long totalFilesAndDirectories = 0L;
        final List<NamenodeStatus> nnList = new ArrayList<NamenodeStatus>();
        final Map<String, Exception> nnExceptions = new HashMap<String, Exception>();

        ClusterStatus() {
        }

        public void setError(Exception e) {
            this.error = e;
        }

        public void addNamenodeStatus(NamenodeStatus nn) {
            this.nnList.add(nn);
            this.totalFilesAndDirectories += nn.filesAndDirectories;
            this.total_sum += nn.capacity;
            this.free_sum += nn.free;
            this.clusterDfsUsed += nn.bpUsed;
            this.nonDfsUsed_sum += nn.nonDfsUsed;
        }

        public void addException(String host, Exception e) {
            this.nnExceptions.put(host, e);
        }

        public void toXML(XMLOutputter doc) throws IOException {
            if (this.error != null) {
                ClusterJspHelper.createGeneralException(doc, this.clusterid, StringUtils.stringifyException(this.error));
                doc.getWriter().flush();
                return;
            }
            int size = this.nnList.size();
            long total = 0L;
            long free = 0L;
            long nonDfsUsed = 0L;
            float dfsUsedPercent = 0.0f;
            float dfsRemainingPercent = 0.0f;
            if (size > 0) {
                total = this.total_sum / (long)size;
                free = this.free_sum / (long)size;
                nonDfsUsed = this.nonDfsUsed_sum / (long)size;
                dfsUsedPercent = DFSUtil.getPercentUsed(this.clusterDfsUsed, total);
                dfsRemainingPercent = DFSUtil.getPercentRemaining(free, total);
            }
            doc.startTag("cluster");
            doc.attribute("clusterId", this.clusterid);
            doc.startTag("storage");
            ClusterJspHelper.toXmlItemBlock(doc, "Total Files And Directories", Long.toString(this.totalFilesAndDirectories));
            ClusterJspHelper.toXmlItemBlock(doc, "Configured Capacity", StringUtils.byteDesc(total));
            ClusterJspHelper.toXmlItemBlock(doc, "DFS Used", StringUtils.byteDesc(this.clusterDfsUsed));
            ClusterJspHelper.toXmlItemBlock(doc, "Non DFS Used", StringUtils.byteDesc(nonDfsUsed));
            ClusterJspHelper.toXmlItemBlock(doc, "DFS Remaining", StringUtils.byteDesc(free));
            ClusterJspHelper.toXmlItemBlock(doc, "DFS Used%", DFSUtil.percent2String(dfsUsedPercent));
            ClusterJspHelper.toXmlItemBlock(doc, "DFS Remaining%", DFSUtil.percent2String(dfsRemainingPercent));
            doc.endTag();
            doc.startTag("namenodes");
            ClusterJspHelper.toXmlItemBlock(doc, "NamenodesCount", Integer.toString(size));
            for (NamenodeStatus nn : this.nnList) {
                doc.startTag("node");
                ClusterJspHelper.toXmlItemBlockWithLink(doc, nn.host, nn.httpAddress, "NameNode");
                ClusterJspHelper.toXmlItemBlock(doc, "Blockpool Used", StringUtils.byteDesc(nn.bpUsed));
                ClusterJspHelper.toXmlItemBlock(doc, "Blockpool Used%", DFSUtil.percent2String(DFSUtil.getPercentUsed(nn.bpUsed, total)));
                ClusterJspHelper.toXmlItemBlock(doc, "Files And Directories", Long.toString(nn.filesAndDirectories));
                ClusterJspHelper.toXmlItemBlock(doc, "Blocks", Long.toString(nn.blocksCount));
                ClusterJspHelper.toXmlItemBlock(doc, "Missing Blocks", Long.toString(nn.missingBlocksCount));
                ClusterJspHelper.toXmlItemBlockWithLink(doc, nn.liveDatanodeCount + " (" + nn.liveDecomCount + ")", new URL(nn.httpAddress, "/dfsnodelist.jsp?whatNodes=LIVE"), "Live Datanode (Decommissioned)");
                ClusterJspHelper.toXmlItemBlockWithLink(doc, nn.deadDatanodeCount + " (" + nn.deadDecomCount + ")", new URL(nn.httpAddress, "/dfsnodelist.jsp?whatNodes=DEAD"), "Dead Datanode (Decommissioned)");
                ClusterJspHelper.toXmlItemBlock(doc, "Software Version", nn.softwareVersion);
                doc.endTag();
            }
            doc.endTag();
            ClusterJspHelper.createNamenodeExceptionMsg(doc, this.nnExceptions);
            doc.endTag();
            doc.getWriter().flush();
        }
    }

    static class NamenodeMXBeanHelper {
        private static final ObjectMapper mapper = new ObjectMapper();
        private final String host;
        private final URI httpAddress;

        NamenodeMXBeanHelper(InetSocketAddress addr, Configuration conf) throws IOException, MalformedObjectNameException {
            this.host = addr.getHostName();
            this.httpAddress = DFSUtil.getInfoServer(addr, conf, DFSUtil.getHttpClientScheme(conf));
        }

        private static Map<String, Map<String, Object>> getNodeMap(String json) throws IOException {
            TypeReference<Map<String, Map<String, Object>>> type = new TypeReference<Map<String, Map<String, Object>>>(){};
            return (Map)mapper.readValue(json, (TypeReference)type);
        }

        private static void getLiveNodeCount(String json, NamenodeStatus nn) throws IOException {
            Map<String, Map<String, Object>> nodeMap = NamenodeMXBeanHelper.getNodeMap(json);
            if (nodeMap == null || nodeMap.isEmpty()) {
                return;
            }
            nn.liveDatanodeCount = nodeMap.size();
            for (Map.Entry<String, Map<String, Object>> entry : nodeMap.entrySet()) {
                Map<String, Object> innerMap = entry.getValue();
                if (innerMap == null || !((String)innerMap.get("adminState")).equals(DatanodeInfo.AdminStates.DECOMMISSIONED.toString())) continue;
                ++nn.liveDecomCount;
            }
        }

        private static void getDeadNodeCount(String json, NamenodeStatus nn) throws IOException {
            Map<String, Map<String, Object>> nodeMap = NamenodeMXBeanHelper.getNodeMap(json);
            if (nodeMap == null || nodeMap.isEmpty()) {
                return;
            }
            nn.deadDatanodeCount = nodeMap.size();
            for (Map.Entry<String, Map<String, Object>> entry : nodeMap.entrySet()) {
                Map<String, Object> innerMap = entry.getValue();
                if (innerMap == null || innerMap.isEmpty() || !((Boolean)innerMap.get("decommissioned")).booleanValue()) continue;
                ++nn.deadDecomCount;
            }
        }

        public String getClusterId(String props) throws IOException {
            return ClusterJspHelper.getProperty(props, "ClusterId").getTextValue();
        }

        public NamenodeStatus getNamenodeStatus(String props) throws IOException, MalformedObjectNameException, NumberFormatException {
            NamenodeStatus nn = new NamenodeStatus();
            nn.host = this.host;
            nn.filesAndDirectories = ClusterJspHelper.getProperty(props, "TotalFiles").getLongValue();
            nn.capacity = ClusterJspHelper.getProperty(props, "Total").getLongValue();
            nn.free = ClusterJspHelper.getProperty(props, "Free").getLongValue();
            nn.bpUsed = ClusterJspHelper.getProperty(props, "BlockPoolUsedSpace").getLongValue();
            nn.nonDfsUsed = ClusterJspHelper.getProperty(props, "NonDfsUsedSpace").getLongValue();
            nn.blocksCount = ClusterJspHelper.getProperty(props, "TotalBlocks").getLongValue();
            nn.missingBlocksCount = ClusterJspHelper.getProperty(props, "NumberOfMissingBlocks").getLongValue();
            nn.httpAddress = this.httpAddress.toURL();
            NamenodeMXBeanHelper.getLiveNodeCount(ClusterJspHelper.getProperty(props, "LiveNodes").getValueAsText(), nn);
            NamenodeMXBeanHelper.getDeadNodeCount(ClusterJspHelper.getProperty(props, "DeadNodes").getValueAsText(), nn);
            nn.softwareVersion = ClusterJspHelper.getProperty(props, "SoftwareVersion").getTextValue();
            return nn;
        }

        private void getDecomNodeInfoForReport(Map<String, Map<String, String>> statusMap, String props) throws IOException, MalformedObjectNameException {
            NamenodeMXBeanHelper.getLiveNodeStatus(statusMap, this.host, ClusterJspHelper.getProperty(props, "LiveNodes").getValueAsText());
            NamenodeMXBeanHelper.getDeadNodeStatus(statusMap, this.host, ClusterJspHelper.getProperty(props, "DeadNodes").getValueAsText());
            NamenodeMXBeanHelper.getDecommissionNodeStatus(statusMap, this.host, ClusterJspHelper.getProperty(props, "DecomNodes").getValueAsText());
        }

        private static void getLiveNodeStatus(Map<String, Map<String, String>> statusMap, String namenodeHost, String json) throws IOException {
            Map<String, Map<String, Object>> nodeMap = NamenodeMXBeanHelper.getNodeMap(json);
            if (nodeMap != null && !nodeMap.isEmpty()) {
                ArrayList<String> liveDecommed = new ArrayList<String>();
                for (Map.Entry<String, Map<String, Object>> entry : nodeMap.entrySet()) {
                    Map<String, String> nnStatus;
                    Map<String, Object> innerMap = entry.getValue();
                    String dn = entry.getKey();
                    if (innerMap == null) continue;
                    if (innerMap.get("adminState").equals(DatanodeInfo.AdminStates.DECOMMISSIONED.toString())) {
                        liveDecommed.add(dn);
                    }
                    if ((nnStatus = statusMap.get(dn)) == null) {
                        nnStatus = new HashMap<String, String>();
                    }
                    nnStatus.put(namenodeHost, (String)innerMap.get("adminState"));
                    statusMap.put(dn, nnStatus);
                }
            }
        }

        private static void getDeadNodeStatus(Map<String, Map<String, String>> statusMap, String host, String json) throws IOException {
            Map<String, Map<String, Object>> nodeMap = NamenodeMXBeanHelper.getNodeMap(json);
            if (nodeMap == null || nodeMap.isEmpty()) {
                return;
            }
            ArrayList<String> deadDn = new ArrayList<String>();
            ArrayList<String> deadDecommed = new ArrayList<String>();
            for (Map.Entry<String, Map<String, Object>> entry : nodeMap.entrySet()) {
                deadDn.add(entry.getKey());
                Map<String, Object> deadNodeDetailMap = entry.getValue();
                String dn = entry.getKey();
                if (deadNodeDetailMap == null || deadNodeDetailMap.isEmpty()) continue;
                Map<String, String> nnStatus = statusMap.get(dn);
                if (nnStatus == null) {
                    nnStatus = new HashMap<String, String>();
                }
                if (((Boolean)deadNodeDetailMap.get("decommissioned")).booleanValue()) {
                    deadDecommed.add(dn);
                    nnStatus.put(host, DatanodeInfo.AdminStates.DECOMMISSIONED.toString());
                } else {
                    nnStatus.put(host, ClusterJspHelper.DEAD);
                }
                statusMap.put(dn, nnStatus);
            }
        }

        private static void getDecommissionNodeStatus(Map<String, Map<String, String>> dataNodeStatusMap, String host, String json) throws IOException {
            Map<String, Map<String, Object>> nodeMap = NamenodeMXBeanHelper.getNodeMap(json);
            if (nodeMap == null || nodeMap.isEmpty()) {
                return;
            }
            ArrayList<String> decomming = new ArrayList<String>();
            for (Map.Entry<String, Map<String, Object>> entry : nodeMap.entrySet()) {
                String dn = entry.getKey();
                decomming.add(dn);
                Map<String, String> nnStatus = new HashMap<String, String>();
                if (dataNodeStatusMap.containsKey(dn)) {
                    nnStatus = dataNodeStatusMap.get(dn);
                }
                nnStatus.put(host, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS.toString());
                dataNodeStatusMap.put(dn, nnStatus);
            }
        }
    }
}

