/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.UserGroupInformation;
import org.mortbay.jetty.Connector;

public class SecureDataNodeStarter
implements Daemon {
    private String[] args;
    private SecureResources resources;

    @Override
    public void init(DaemonContext context) throws Exception {
        System.err.println("Initializing secure datanode resources");
        HdfsConfiguration conf = new HdfsConfiguration();
        this.args = context.getArguments();
        this.resources = SecureDataNodeStarter.getSecureResources(conf);
    }

    @Override
    public void start() throws Exception {
        System.err.println("Starting regular datanode initialization");
        DataNode.secureMain(this.args, this.resources);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void stop() throws Exception {
    }

    @VisibleForTesting
    public static SecureResources getSecureResources(Configuration conf) throws Exception {
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        boolean isSecure = UserGroupInformation.isSecurityEnabled();
        InetSocketAddress streamingAddr = DataNode.getStreamingAddr(conf);
        int socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        ServerSocket ss = socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        ss.bind(streamingAddr, 0);
        if (ss.getLocalPort() != streamingAddr.getPort()) {
            throw new RuntimeException("Unable to bind on specified streaming port in secure context. Needed " + streamingAddr.getPort() + ", got " + ss.getLocalPort());
        }
        if (ss.getLocalPort() > 1023 && isSecure) {
            throw new RuntimeException("Cannot start secure datanode with unprivileged RPC ports");
        }
        System.err.println("Opened streaming server at " + streamingAddr);
        Connector listener = null;
        if (policy.isHttpEnabled()) {
            listener = HttpServer2.createDefaultChannelConnector();
            InetSocketAddress infoSocAddr = DataNode.getInfoAddr(conf);
            listener.setHost(infoSocAddr.getHostName());
            listener.setPort(infoSocAddr.getPort());
            listener.open();
            if (listener.getPort() != infoSocAddr.getPort()) {
                throw new RuntimeException("Unable to bind on specified info port in secure context. Needed " + streamingAddr.getPort() + ", got " + ss.getLocalPort());
            }
            System.err.println("Successfully obtained privileged resources (streaming port = " + ss + " ) (http listener port = " + listener.getConnection() + ")");
            if (listener.getPort() > 1023 && isSecure) {
                throw new RuntimeException("Cannot start secure datanode with unprivileged HTTP ports");
            }
            System.err.println("Opened info server at " + infoSocAddr);
        }
        return new SecureResources(ss, listener);
    }

    public static class SecureResources {
        private final ServerSocket streamingSocket;
        private final Connector listener;

        public SecureResources(ServerSocket streamingSocket, Connector listener) {
            this.streamingSocket = streamingSocket;
            this.listener = listener;
        }

        public ServerSocket getStreamingSocket() {
            return this.streamingSocket;
        }

        public Connector getListener() {
            return this.listener;
        }
    }
}

