/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;

@InterfaceAudience.Private
public class DataBlockScanner
implements Runnable {
    public static final Log LOG = LogFactory.getLog(DataBlockScanner.class);
    private final DataNode datanode;
    private final FsDatasetSpi<? extends FsVolumeSpi> dataset;
    private final Configuration conf;
    static final int SLEEP_PERIOD_MS = 5000;
    private final TreeMap<String, BlockPoolSliceScanner> blockPoolScannerMap = new TreeMap();
    Thread blockScannerThread = null;

    DataBlockScanner(DataNode datanode, FsDatasetSpi<? extends FsVolumeSpi> dataset, Configuration conf) {
        this.datanode = datanode;
        this.dataset = dataset;
        this.conf = conf;
    }

    @Override
    public void run() {
        String currentBpId = "";
        boolean firstRun = true;
        while (this.datanode.shouldRun && !Thread.interrupted()) {
            BlockPoolSliceScanner bpScanner;
            block6: {
                if (!firstRun) {
                    try {
                        Thread.sleep(5000L);
                        break block6;
                    }
                    catch (InterruptedException ex) {
                        this.blockScannerThread.interrupt();
                        continue;
                    }
                }
                firstRun = false;
            }
            if ((bpScanner = this.getNextBPScanner(currentBpId)) == null) continue;
            currentBpId = bpScanner.getBlockPoolId();
            if (!this.datanode.isBPServiceAlive(currentBpId)) {
                LOG.warn("Block Pool " + currentBpId + " is not alive");
                this.removeBlockPool(currentBpId);
                continue;
            }
            bpScanner.scanBlockPoolSlice();
        }
        for (BlockPoolSliceScanner bpss : this.blockPoolScannerMap.values()) {
            bpss.shutdown();
        }
    }

    private void waitForInit() {
        while (this.getBlockPoolSetSize() < this.datanode.getAllBpOs().length || this.getBlockPoolSetSize() < 1) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                this.blockScannerThread.interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockPoolSliceScanner getNextBPScanner(String currentBpId) {
        String nextBpId = null;
        while (nextBpId == null && this.datanode.shouldRun && !this.blockScannerThread.isInterrupted()) {
            this.waitForInit();
            DataBlockScanner dataBlockScanner = this;
            synchronized (dataBlockScanner) {
                if (this.getBlockPoolSetSize() > 0) {
                    long lastScanTime = 0L;
                    for (String bpid : this.blockPoolScannerMap.keySet()) {
                        long t = this.getBPScanner(bpid).getLastScanTime();
                        if (t == 0L || bpid != null && t >= lastScanTime) continue;
                        lastScanTime = t;
                        nextBpId = bpid;
                    }
                    if (nextBpId == null && (nextBpId = this.blockPoolScannerMap.higherKey(currentBpId)) == null) {
                        nextBpId = this.blockPoolScannerMap.firstKey();
                    }
                    if (nextBpId != null) {
                        return this.getBPScanner(nextBpId);
                    }
                }
            }
            LOG.warn("No block pool is up, going to wait");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                LOG.warn("Received exception: " + ex);
                this.blockScannerThread.interrupt();
                return null;
            }
        }
        return null;
    }

    private synchronized int getBlockPoolSetSize() {
        return this.blockPoolScannerMap.size();
    }

    @VisibleForTesting
    synchronized BlockPoolSliceScanner getBPScanner(String bpid) {
        return this.blockPoolScannerMap.get(bpid);
    }

    private synchronized String[] getBpIdList() {
        return this.blockPoolScannerMap.keySet().toArray(new String[this.blockPoolScannerMap.keySet().size()]);
    }

    public void addBlock(ExtendedBlock block) {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(block.getBlockPoolId());
        if (bpScanner != null) {
            bpScanner.addBlock(block);
        } else {
            LOG.warn("No block pool scanner found for block pool id: " + block.getBlockPoolId());
        }
    }

    boolean isInitialized(String bpid) {
        return this.getBPScanner(bpid) != null;
    }

    public synchronized void printBlockReport(StringBuilder buffer, boolean summary) {
        String[] bpIdList = this.getBpIdList();
        if (bpIdList == null || bpIdList.length == 0) {
            buffer.append("Periodic block scanner is not yet initialized. Please check back again after some time.");
            return;
        }
        for (String bpid : bpIdList) {
            BlockPoolSliceScanner bpScanner = this.getBPScanner(bpid);
            buffer.append("\n\nBlock report for block pool: " + bpid + "\n");
            bpScanner.printBlockReport(buffer, summary);
            buffer.append("\n");
        }
    }

    public void deleteBlock(String poolId, Block toDelete) {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(poolId);
        if (bpScanner != null) {
            bpScanner.deleteBlock(toDelete);
        } else {
            LOG.warn("No block pool scanner found for block pool id: " + poolId);
        }
    }

    public void deleteBlocks(String poolId, Block[] toDelete) {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(poolId);
        if (bpScanner != null) {
            bpScanner.deleteBlocks(toDelete);
        } else {
            LOG.warn("No block pool scanner found for block pool id: " + poolId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DataBlockScanner dataBlockScanner = this;
        synchronized (dataBlockScanner) {
            if (this.blockScannerThread != null) {
                this.blockScannerThread.interrupt();
            }
        }
        if (this.blockScannerThread != null) {
            try {
                this.blockScannerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void addBlockPool(String blockPoolId) {
        if (this.blockPoolScannerMap.get(blockPoolId) != null) {
            return;
        }
        BlockPoolSliceScanner bpScanner = new BlockPoolSliceScanner(blockPoolId, this.datanode, this.dataset, this.conf);
        this.blockPoolScannerMap.put(blockPoolId, bpScanner);
        LOG.info("Added bpid=" + blockPoolId + " to blockPoolScannerMap, new size=" + this.blockPoolScannerMap.size());
    }

    public synchronized void removeBlockPool(String blockPoolId) {
        BlockPoolSliceScanner bpss = this.blockPoolScannerMap.remove(blockPoolId);
        if (bpss != null) {
            bpss.shutdown();
        }
        LOG.info("Removed bpid=" + blockPoolId + " from blockPoolScannerMap");
    }

    @VisibleForTesting
    long getBlocksScannedInLastRun(String bpid) throws IOException {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(bpid);
        if (bpScanner == null) {
            throw new IOException("Block Pool: " + bpid + " is not running");
        }
        return bpScanner.getBlocksScannedInLastRun();
    }

    @VisibleForTesting
    long getTotalScans(String bpid) throws IOException {
        BlockPoolSliceScanner bpScanner = this.getBPScanner(bpid);
        if (bpScanner == null) {
            throw new IOException("Block Pool: " + bpid + " is not running");
        }
        return bpScanner.getTotalScans();
    }

    public void start() {
        this.blockScannerThread = new Thread(this);
        this.blockScannerThread.setDaemon(true);
        this.blockScannerThread.start();
    }

    @InterfaceAudience.Private
    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        @Override
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("text/plain");
            DataNode datanode = (DataNode)this.getServletContext().getAttribute("datanode");
            DataBlockScanner blockScanner = datanode.blockScanner;
            boolean summary = request.getParameter("listblocks") == null;
            StringBuilder buffer = new StringBuilder(8192);
            if (blockScanner == null) {
                LOG.warn("Periodic block scanner is not running");
                buffer.append("Periodic block scanner is not running. Please check the datanode log if this is unexpected.");
            } else {
                blockScanner.printBlockReport(buffer, summary);
            }
            response.getWriter().write(buffer.toString());
        }
    }
}

