/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;

public class DatanodeStorageInfo {
    public static final DatanodeStorageInfo[] EMPTY_ARRAY = new DatanodeStorageInfo[0];
    private final DatanodeDescriptor dn;
    private final String storageID;
    private StorageType storageType;
    private DatanodeStorage.State state;
    private long capacity;
    private long dfsUsed;
    private long remaining;
    private long blockPoolUsed;
    private volatile BlockInfo blockList = null;
    private int numBlocks = 0;
    private int blockReportCount = 0;
    private boolean heartbeatedSinceFailover = false;
    private boolean blockContentsStale = true;

    public static DatanodeInfo[] toDatanodeInfos(DatanodeStorageInfo[] storages) {
        return DatanodeStorageInfo.toDatanodeInfos(Arrays.asList(storages));
    }

    static DatanodeInfo[] toDatanodeInfos(List<DatanodeStorageInfo> storages) {
        DatanodeInfo[] datanodes = new DatanodeInfo[storages.size()];
        for (int i = 0; i < storages.size(); ++i) {
            datanodes[i] = storages.get(i).getDatanodeDescriptor();
        }
        return datanodes;
    }

    static DatanodeDescriptor[] toDatanodeDescriptors(DatanodeStorageInfo[] storages) {
        DatanodeDescriptor[] datanodes = new DatanodeDescriptor[storages.length];
        for (int i = 0; i < storages.length; ++i) {
            datanodes[i] = storages[i].getDatanodeDescriptor();
        }
        return datanodes;
    }

    public static String[] toStorageIDs(DatanodeStorageInfo[] storages) {
        String[] storageIDs = new String[storages.length];
        for (int i = 0; i < storageIDs.length; ++i) {
            storageIDs[i] = storages[i].getStorageID();
        }
        return storageIDs;
    }

    public static StorageType[] toStorageTypes(DatanodeStorageInfo[] storages) {
        StorageType[] storageTypes = new StorageType[storages.length];
        for (int i = 0; i < storageTypes.length; ++i) {
            storageTypes[i] = storages[i].getStorageType();
        }
        return storageTypes;
    }

    public void updateFromStorage(DatanodeStorage storage) {
        this.state = storage.getState();
        this.storageType = storage.getStorageType();
    }

    DatanodeStorageInfo(DatanodeDescriptor dn, DatanodeStorage s) {
        this.dn = dn;
        this.storageID = s.getStorageID();
        this.storageType = s.getStorageType();
        this.state = s.getState();
    }

    int getBlockReportCount() {
        return this.blockReportCount;
    }

    void setBlockReportCount(int blockReportCount) {
        this.blockReportCount = blockReportCount;
    }

    boolean areBlockContentsStale() {
        return this.blockContentsStale;
    }

    void markStaleAfterFailover() {
        this.heartbeatedSinceFailover = false;
        this.blockContentsStale = true;
    }

    void receivedHeartbeat(StorageReport report) {
        this.updateState(report);
        this.heartbeatedSinceFailover = true;
    }

    void receivedBlockReport() {
        if (this.heartbeatedSinceFailover) {
            this.blockContentsStale = false;
        }
        ++this.blockReportCount;
    }

    @VisibleForTesting
    public void setUtilizationForTesting(long capacity, long dfsUsed, long remaining, long blockPoolUsed) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = blockPoolUsed;
    }

    DatanodeStorage.State getState() {
        return this.state;
    }

    String getStorageID() {
        return this.storageID;
    }

    StorageType getStorageType() {
        return this.storageType;
    }

    long getCapacity() {
        return this.capacity;
    }

    long getDfsUsed() {
        return this.dfsUsed;
    }

    long getRemaining() {
        return this.remaining;
    }

    long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    boolean addBlock(BlockInfo b) {
        if (!b.addStorage(this)) {
            return false;
        }
        this.blockList = b.listInsert(this.blockList, this);
        ++this.numBlocks;
        return true;
    }

    boolean removeBlock(BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        if (b.removeStorage(this)) {
            --this.numBlocks;
            return true;
        }
        return false;
    }

    int numBlocks() {
        return this.numBlocks;
    }

    Iterator<BlockInfo> getBlockIterator() {
        return new BlockIterator(this.blockList);
    }

    int moveBlockToHead(BlockInfo b, int curIndex, int headIndex) {
        this.blockList = b.moveBlockToHead(this.blockList, this, curIndex, headIndex);
        return curIndex;
    }

    @VisibleForTesting
    BlockInfo getBlockListHeadForTesting() {
        return this.blockList;
    }

    void updateState(StorageReport r) {
        this.capacity = r.getCapacity();
        this.dfsUsed = r.getDfsUsed();
        this.remaining = r.getRemaining();
        this.blockPoolUsed = r.getBlockPoolUsed();
    }

    public DatanodeDescriptor getDatanodeDescriptor() {
        return this.dn;
    }

    public static void incrementBlocksScheduled(DatanodeStorageInfo ... storages) {
        for (DatanodeStorageInfo s : storages) {
            s.getDatanodeDescriptor().incrementBlocksScheduled();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DatanodeStorageInfo)) {
            return false;
        }
        DatanodeStorageInfo that = (DatanodeStorageInfo)obj;
        return this.storageID.equals(that.storageID);
    }

    public int hashCode() {
        return this.storageID.hashCode();
    }

    public String toString() {
        return "[" + (Object)((Object)this.storageType) + "]" + this.storageID + ":" + (Object)((Object)this.state);
    }

    class BlockIterator
    implements Iterator<BlockInfo> {
        private BlockInfo current;

        BlockIterator(BlockInfo head) {
            this.current = head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public BlockInfo next() {
            BlockInfo res = this.current;
            this.current = this.current.getNext(this.current.findStorageInfo(DatanodeStorageInfo.this));
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

