/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Private
public class FsAclPermission
extends FsPermission {
    private static final short ACL_BIT = 4096;
    private final boolean aclBit;

    public FsAclPermission(FsPermission perm) {
        super(perm.toShort());
        this.aclBit = true;
    }

    public FsAclPermission(short perm) {
        super(perm);
        this.aclBit = (perm & 0x1000) != 0;
    }

    @Override
    public short toExtendedShort() {
        return (short)(this.toShort() | (this.aclBit ? 4096 : 0));
    }

    @Override
    public boolean getAclBit() {
        return this.aclBit;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

