/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.net.unix.DomainSocket;

class NioInetPeer
implements Peer {
    private final Socket socket;
    private final SocketInputStream in;
    private final SocketOutputStream out;
    private final boolean isLocal;

    NioInetPeer(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new SocketInputStream(socket.getChannel(), 0L);
        this.out = new SocketOutputStream(socket.getChannel(), 0L);
        this.isLocal = socket.getInetAddress().equals(socket.getLocalAddress());
    }

    @Override
    public ReadableByteChannel getInputStreamChannel() {
        return this.in;
    }

    @Override
    public void setReadTimeout(int timeoutMs) throws IOException {
        this.in.setTimeout(timeoutMs);
    }

    @Override
    public int getReceiveBufferSize() throws IOException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public boolean getTcpNoDelay() throws IOException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public void setWriteTimeout(int timeoutMs) throws IOException {
        this.out.setTimeout(timeoutMs);
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public String getRemoteAddressString() {
        return this.socket.getRemoteSocketAddress().toString();
    }

    @Override
    public String getLocalAddressString() {
        return this.socket.getLocalSocketAddress().toString();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    public String toString() {
        return "NioInetPeer(" + this.socket.toString() + ")";
    }

    @Override
    public DomainSocket getDomainSocket() {
        return null;
    }

    @Override
    public boolean hasSecureChannel() {
        return false;
    }
}

